/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.visualeditor.querybuilder;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.QueryBuilder;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.QueryBuilderTable;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.QueryBuilderTableModel;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.TableNode;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Predicate;
import org.netbeans.modules.db.sql.visualeditor.querymodel.SQLQueryFactory;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class QueryBuilderInternalFrame
extends JInternalFrame
implements ActionListener,
KeyListener,
DragGestureListener,
DragSourceListener,
DropTargetListener {
    private boolean DEBUG = false;
    private Object _dragObject = null;
    private DropTarget _dropTarget;
    private JPopupMenu _tableColumnPopup;
    private TableNode _node;
    private QueryBuilder _queryBuilder;
    private QueryBuilderTable _qbTable;
    private QueryBuilderTableModel _queryBuilderTableModel = null;
    private static int _lastX = 0;
    private static int _lastY = 0;

    public QueryBuilderInternalFrame(QueryBuilderTableModel queryBuilderTableModel, QueryBuilder queryBuilder) {
        this._queryBuilderTableModel = queryBuilderTableModel;
        this._queryBuilder = queryBuilder;
        this._node = new TableNode(queryBuilderTableModel.getFullTableName(), queryBuilderTableModel.getCorrName(), this._queryBuilder);
        this.setResizable(true);
        this.setFrameIcon(null);
        this.setIconifiable(false);
        this.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
                try {
                    QueryBuilderInternalFrame.this.setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        });
        this.setBackground(Color.white);
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.DEBUG) {
            System.out.println(" QBIF : key pressed called. \n");
        }
        this._queryBuilder.handleKeyPress(keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void create() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this._qbTable = new QueryBuilderTable(this._queryBuilderTableModel);
        this._qbTable.setBackground(Color.white);
        JScrollPane jScrollPane = new JScrollPane(this._qbTable);
        jScrollPane.getViewport().setBackground(Color.white);
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.setBackground(Color.white);
        this.getContentPane().add(jPanel);
        this.getContentPane().setBackground(Color.white);
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this._qbTable, 2, this);
        this._dropTarget = new DropTarget(this._qbTable, 2, this);
        this.pack();
        this.setSize(175, 120);
        this.setVisible(true);
    }

    JPopupMenu createTableColumnPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(NbBundle.getMessage(QueryBuilderInternalFrame.class, (String)"ADD_TO_QUERY"));
        jMenuItem.addActionListener(this);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(NbBundle.getMessage(QueryBuilderInternalFrame.class, (String)"SORT_ASCENDING"));
        jMenuItem.addActionListener(this);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(NbBundle.getMessage(QueryBuilderInternalFrame.class, (String)"SORT_DESCENDING"));
        jMenuItem.addActionListener(this);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(NbBundle.getMessage(QueryBuilderInternalFrame.class, (String)"REMOVE_FILTER"));
        jMenuItem.addActionListener(this);
        jPopupMenu.add(jMenuItem);
        return jPopupMenu;
    }

    public QueryBuilderTableModel getQueryBuilderTableModel() {
        return this._queryBuilderTableModel;
    }

    public TableNode getNode() {
        return this._node;
    }

    public String toString() {
        return "";
    }

    String getTableName() {
        return this._queryBuilderTableModel.getTableName();
    }

    String getTableSpec() {
        return this._queryBuilderTableModel.getTableSpec();
    }

    String getFullTableName() {
        return this._queryBuilderTableModel.getFullTableName();
    }

    static Point getLastLocation() {
        return new Point(_lastX, _lastY);
    }

    static void resetLocation() {
        _lastX = 0;
        _lastY = 0;
    }

    public void setLocation(int n, int n2) {
        _lastX = n;
        _lastY = n2;
        super.setLocation(n, n2);
    }

    protected String getClassName(Object object) {
        String string = object.getClass().getName();
        int n = string.lastIndexOf(".");
        return string.substring(n + 1);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.DEBUG) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            String string = "Action event detected.\n    Event source: " + jMenuItem.getText() + " (an instance of " + this.getClassName(jMenuItem) + ")";
            System.out.println(string + "\n");
        }
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        if (this.DEBUG) {
            System.out.println(" Component point " + dragGestureEvent.getDragOrigin() + "\n");
        }
        int n = this._qbTable.rowAtPoint(dragGestureEvent.getDragOrigin());
        int n2 = this._qbTable.columnAtPoint(dragGestureEvent.getDragOrigin());
        this._dragObject = this;
        if (n < 0 || n2 < 2) {
            return;
        }
        if (this.DEBUG) {
            System.out.println(" Table row " + n + " Table column " + n2 + " Object " + this._qbTable.getValueAt(n, n2) + "\n");
        }
        String string = this._queryBuilderTableModel.getTableSpec() + "." + (String)this._qbTable.getValueAt(n, n2);
        dragGestureEvent.startDrag(DragSource.DefaultCopyDrop, new StringSelection(string), this);
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        try {
            if (this.DEBUG) {
                System.out.println(" Component point " + dropTargetDropEvent.getLocation() + "\n");
            }
            int n = this._qbTable.rowAtPoint(dropTargetDropEvent.getLocation());
            int n2 = this._qbTable.columnAtPoint(dropTargetDropEvent.getLocation());
            if (n < 0 || n2 < 2 || this._dragObject == this) {
                String string = NbBundle.getMessage(QueryBuilderInternalFrame.class, (String)"DRAG_AND_DROP_COLUMNS");
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)(string + "\n\n"), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                this._dragObject = null;
                return;
            }
            if (this.DEBUG) {
                System.out.println(" Table row " + n + " Table column " + n2 + " Object " + this._qbTable.getValueAt(n, n2) + "\n");
            }
            String string = this._queryBuilderTableModel.getTableSpec() + "." + (String)this._qbTable.getValueAt(n, n2);
            DataFlavor dataFlavor = DataFlavor.stringFlavor;
            Transferable transferable = dropTargetDropEvent.getTransferable();
            if (dropTargetDropEvent.isDataFlavorSupported(dataFlavor) && dropTargetDropEvent.isLocalTransfer()) {
                String string2 = (String)transferable.getTransferData(dataFlavor);
                if (this.DEBUG) {
                    System.out.println("dragTableColumnName = " + string2 + "\n");
                    System.out.println("dropTableColumnName = " + string + "\n");
                }
                String[] stringArray = new String[4];
                String[] stringArray2 = string2.split("\\.");
                if (stringArray2.length == 2) {
                    stringArray[0] = stringArray2[0];
                    stringArray[1] = stringArray2[1];
                } else if (stringArray2.length == 3) {
                    stringArray[0] = stringArray2[0] + "." + stringArray2[1];
                    stringArray[1] = stringArray2[2];
                } else {
                    String string3 = NbBundle.getMessage(QueryBuilderInternalFrame.class, (String)"DRAG_AND_DROP_COLUMNS");
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)(string3 + "\n\n"), 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                    this._dragObject = null;
                    return;
                }
                stringArray[2] = this._queryBuilderTableModel.getTableSpec();
                stringArray[3] = (String)this._qbTable.getValueAt(n, n2);
                if (this.DEBUG) {
                    System.out.println(" rel[0] = " + stringArray[0] + " rel[1] = " + stringArray[1] + " rel[2] = " + stringArray[2] + " rel[3] = " + stringArray[3] + "\n");
                }
                Predicate predicate = SQLQueryFactory.createPredicate(stringArray);
                this._queryBuilder._queryModel.addOrCreateAndExpression(predicate);
                if (this.DEBUG) {
                    System.out.println(this._queryBuilder._queryModel.getWhere().genText(null));
                }
                this._queryBuilder.generate();
                dropTargetDropEvent.acceptDrop(2);
                dropTargetDropEvent.dropComplete(true);
            } else {
                dropTargetDropEvent.rejectDrop();
            }
            this._dragObject = null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            unsupportedFlavorException.printStackTrace();
        }
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    class TableColumnPopupListener
    extends MouseAdapter {
        TableColumnPopupListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                QueryBuilderInternalFrame.this._tableColumnPopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

