/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.core.lib;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;

public class UnicodeReader
extends Reader {
    PushbackInputStream internalIn;
    InputStreamReader internalIn2;
    String defaultEncoding;
    private static final int BOM_SIZE = 4;

    public UnicodeReader(InputStream inputStream, String string) {
        this.internalIn = new PushbackInputStream(inputStream, 4);
        this.defaultEncoding = string;
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public String getEncoding() {
        if (this.internalIn2 == null) {
            return null;
        }
        return this.internalIn2.getEncoding();
    }

    protected void init() throws IOException {
        int n;
        String string;
        if (this.internalIn2 != null) {
            return;
        }
        byte[] byArray = new byte[4];
        int n2 = this.internalIn.read(byArray, 0, byArray.length);
        if (byArray[0] == 0 && byArray[1] == 0 && byArray[2] == -2 && byArray[3] == -1) {
            string = "UTF-32BE";
            n = n2 - 4;
        } else if (byArray[0] == -1 && byArray[1] == -2 && byArray[2] == 0 && byArray[3] == 0) {
            string = "UTF-32LE";
            n = n2 - 4;
        } else if (byArray[0] == -17 && byArray[1] == -69 && byArray[2] == -65) {
            string = "UTF-8";
            n = n2 - 3;
        } else if (byArray[0] == -2 && byArray[1] == -1) {
            string = "UTF-16BE";
            n = n2 - 2;
        } else if (byArray[0] == -1 && byArray[1] == -2) {
            string = "UTF-16LE";
            n = n2 - 2;
        } else {
            string = this.defaultEncoding;
            n = n2;
        }
        if (n > 0) {
            this.internalIn.unread(byArray, n2 - n, n);
        }
        this.internalIn2 = string == null ? new InputStreamReader(this.internalIn) : new InputStreamReader((InputStream)this.internalIn, string);
    }

    public void close() throws IOException {
        if (this.internalIn != null) {
            this.internalIn.close();
            this.internalIn = null;
        }
        if (this.internalIn2 != null) {
            this.internalIn2.close();
            this.internalIn2 = null;
        }
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        this.init();
        return this.internalIn2.read(cArray, n, n2);
    }
}

