/*
 * Decompiled with CFR 0.152.
 */
package rex.graphics.tables;

import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.w3c.dom.Document;
import rex.graphics.CubeExplorer2;
import rex.graphics.tables.CellTableModel;
import rex.metadata.CubeSlicer;
import rex.metadata.ExecuteResult;
import rex.metadata.ServerMetadata;
import rex.utils.AppColors;
import rex.xmla.XMLAExecuteProperties;
import rex.xmla.XMLAObjectsFactory;

public class CellTable
extends JTable {
    JPanel northPane2;
    int selCol = -1;
    int selRow = -1;
    CubeExplorer2 cubeExplorer;
    CustomCellRenderer customCellRenderer;
    ExecuteResult result;

    public CellTable(ExecuteResult _result, CubeSlicer _cubeSlicer, boolean showColumnTotalsOn, boolean showRowTotalsOn) {
        this.result = _result;
        this.setModel(new CellTableModel(_result, _cubeSlicer, showColumnTotalsOn, showRowTotalsOn));
        TableColumnModel colModel = this.getColumnModel();
        this.customCellRenderer = new CustomCellRenderer();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            colModel.getColumn(i).setPreferredWidth(48);
            colModel.getColumn(i).setCellRenderer(this.customCellRenderer);
        }
        this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.addComponentListener(new ResizeWatch());
        this.addMouseListener(new CellTableMouseListener());
        this.setOpaque(false);
    }

    public CellTable(ExecuteResult _result, CubeSlicer _cubeSlicer, CubeExplorer2 _cubeExplorer, boolean showColumnTotalsOn, boolean showRowTotalsOn) {
        this(_result, _cubeSlicer, showColumnTotalsOn, showRowTotalsOn);
        this.cubeExplorer = _cubeExplorer;
    }

    public void setShowRowTotalsOn(boolean showRowTotalsOn) {
        ((CellTableModel)this.getModel()).setShowRowTotalsOn(showRowTotalsOn);
        TableColumnModel colModel = this.getColumnModel();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            colModel.getColumn(i).setPreferredWidth(48);
            colModel.getColumn(i).setCellRenderer(this.customCellRenderer);
        }
    }

    public void setShowColumnTotalsOn(boolean showColumnTotalsOn) {
        ((CellTableModel)this.getModel()).setShowColumnTotalsOn(showColumnTotalsOn);
        TableColumnModel colModel = this.getColumnModel();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            colModel.getColumn(i).setPreferredWidth(48);
            colModel.getColumn(i).setCellRenderer(this.customCellRenderer);
        }
    }

    public void copyTableToClipboard() {
        int headerCount1;
        StringBuffer sbf = new StringBuffer();
        for (int top = 0; top < this.result.getAxis("Axis0").getHierarchyInfoCount(); ++top) {
            for (headerCount1 = 0; headerCount1 < this.result.getAxis("Axis1").getHierarchyInfoCount(); ++headerCount1) {
                sbf.append("\t");
            }
            for (int tc = 0; tc < this.result.getAxis("Axis0").getTupleCount(); ++tc) {
                sbf.append(this.result.getAxis("Axis0").getTupleAt(tc).getMemberAt(top).getCaption());
                if (tc >= this.result.getAxis("Axis0").getTupleCount() - 1) continue;
                sbf.append("\t");
            }
            sbf.append("\n");
        }
        for (int i = 0; i < this.result.getAxis("Axis1").getTupleCount(); ++i) {
            for (headerCount1 = 0; headerCount1 < this.result.getAxis("Axis1").getHierarchyInfoCount(); ++headerCount1) {
                sbf.append(this.result.getAxis("Axis1").getTupleAt(i).getMemberAt(headerCount1).getCaption() + "\t");
            }
            for (int j = 0; j < this.result.getAxis("Axis0").getTupleCount(); ++j) {
                sbf.append(this.getValueAt(i, j));
                if (j >= this.getColumnCount() - 1) continue;
                sbf.append("\t");
            }
            sbf.append("\n");
        }
        StringSelection stsel = new StringSelection(sbf.toString());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stsel, stsel);
    }

    void setSelectedCell() {
        this.selCol = this.getSelectedColumn();
        this.selRow = this.getSelectedRow();
        if (this.selCol >= 0 && this.selRow >= 0) {
            this.repaint();
            this.cubeExplorer.highlightRowsAndColumns(this.selRow, this.selCol);
        }
    }

    public static void main(String[] args) {
        ServerMetadata svm = new ServerMetadata("http://localhost/xmla/msxisapi.dll");
        XMLAExecuteProperties properties = XMLAObjectsFactory.newXMLAExecuteProperties();
        properties.setDataSourceInfo("Local Analysis properties");
        properties.setCatalog("Foodmart 2000");
        try {
            Document d = svm.execute("SELECT {[Measures].members * [1997].children} ON COLUMNS, {[Store].[usa].children * [Position].[All Position].children} DIMENSION PROPERTIES [Store].[Store SQFT] ON ROWS FROM [Hr]", properties);
            CubeSlicer cs = new CubeSlicer(1, 0);
            ExecuteResult r1 = new ExecuteResult(d, null);
            CellTable ct = new CellTable(r1, cs, true, true);
            JFrame frame = new JFrame("Test cell table");
            frame.setBackground(Color.YELLOW);
            frame.getContentPane().add((Component)ct, "Center");
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            frame.pack();
            frame.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class CellTableMouseListener
    extends MouseAdapter {
        CellTableMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            if (e.getClickCount() == 1) {
                CellTable.this.setSelectedCell();
            }
        }
    }

    class CustomCellRenderer
    extends JLabel
    implements TableCellRenderer {
        CustomCellRenderer() {
            this.setOpaque(false);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int colIndex) {
            if (hasFocus) {
                // empty if block
            }
            if (((CellTableModel)CellTable.this.getModel()).isAverageCell(rowIndex, colIndex)) {
                this.setOpaque(true);
                this.setBackground(AppColors.CELL_TOTAL_AVERAGE_BACKGROUND_COLOR);
            } else if (((CellTableModel)CellTable.this.getModel()).isSumCell(rowIndex, colIndex)) {
                this.setOpaque(true);
                this.setBackground(AppColors.CELL_TOTAL_SUM_BACKGROUND_COLOR);
            } else if (rowIndex % 2 == 0) {
                this.setOpaque(false);
            } else {
                this.setOpaque(true);
                this.setBackground(AppColors.ODD_ROW_LINES_BACKGROUND);
            }
            if (rowIndex == CellTable.this.selRow && colIndex == CellTable.this.selCol) {
                this.setBorder(AppColors.CELL_SELECTED_BORDER);
            } else {
                this.setBorder(null);
            }
            if (value != null) {
                this.setText(value.toString());
            } else {
                this.setText("");
            }
            return this;
        }

        public void validate() {
        }

        public void revalidate() {
        }

        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        }

        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        }
    }

    class ResizeWatch
    implements ComponentListener {
        ResizeWatch() {
        }

        public void componentHidden(ComponentEvent e) {
        }

        public void componentMoved(ComponentEvent e) {
        }

        public void componentResized(ComponentEvent e) {
        }

        public void componentShown(ComponentEvent e) {
        }
    }
}

