/*
 * Decompiled with CFR 0.152.
 */
package rex.graphics.mdxeditor.mdxbuilder.nodes;

import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import rex.graphics.mdxeditor.mdxbuilder.nodes.DefaultMBTArgNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.DefaultMBTNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTPopUpActions;
import rex.utils.I18n;
import rex.utils.LanguageChangedEvent;
import rex.utils.LanguageChangedListener;
import rex.utils.S;

public class MBTFunctionNode
extends DefaultMBTNode
implements LanguageChangedListener {
    private String functionName;
    private String toolTip;
    private String flavor;
    private static String childrenIndent = "  ";
    static ImageIcon icon = S.getAppIcon("mdxfunction.gif");

    public MBTFunctionNode(String _functionName, String desc, String syntax, String _flavor) {
        I18n.addOnLanguageChangedListener(this);
        this.functionName = _functionName;
        this.flavor = _flavor;
        this.toolTip = "<html><b>FUNCTION: </b>" + this.functionName + "<hr>" + "<b>Desc: </b><i>" + desc + "</i>" + "<hr>" + "<b>Syntax: </b>" + syntax;
    }

    public boolean isComplete() {
        if (this.getChildren() == null) {
            return true;
        }
        for (int i = 0; i < this.getChildren().size(); ++i) {
            DefaultMBTArgNode child = (DefaultMBTArgNode)this.getChild(i);
            if (child.isOptionalArg() || !child.getMdx("").trim().equals("")) continue;
            return false;
        }
        return true;
    }

    public String getFlavor() {
        return this.flavor;
    }

    public String getMdx(String indent) {
        boolean functionNameInserted = false;
        boolean bracketOpen = false;
        boolean firstArgument = true;
        if (this.getChildren() == null) {
            return this.functionName;
        }
        StringBuffer mdx = new StringBuffer("");
        for (int i = 0; i < this.getChildren().size(); ++i) {
            DefaultMBTArgNode child = (DefaultMBTArgNode)this.getChild(i);
            if (child.isHeadArg()) {
                mdx.append(indent + this.getChild(i).getMdx("") + "." + this.functionName);
                functionNameInserted = true;
                continue;
            }
            if (!functionNameInserted) {
                mdx.append(indent + this.functionName + "(");
                bracketOpen = true;
                functionNameInserted = true;
            }
            if (!bracketOpen) {
                mdx.append("(");
                bracketOpen = true;
            }
            if (((DefaultMBTArgNode)this.getChild(i)).isOptionalArg() && this.getChild(i).getMdx("").trim().equals("")) continue;
            if (firstArgument) {
                mdx.append("\n" + this.getChild(i).getMdx(indent + childrenIndent));
                firstArgument = false;
                continue;
            }
            mdx.append("\n" + this.addCommaAfterBlanks(this.getChild(i).getMdx(indent + childrenIndent)));
        }
        if (bracketOpen) {
            mdx.append("\n" + indent + ")");
        }
        return mdx.toString();
    }

    public String toString() {
        return this.functionName;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public String getToolTip() {
        return this.toolTip;
    }

    void setAcceptableFlavorsArray() {
    }

    public ImageIcon getIcon() {
        return icon;
    }

    public void handleDrop(Object droppedData, DefaultMutableTreeNode containerNode, DefaultTreeModel treeModel) {
    }

    public String[] getPopUpActionList() {
        return new String[]{MBTPopUpActions.REMOVE};
    }

    public void handlePopUpAction(String action, DefaultMutableTreeNode actionNode, DefaultTreeModel treeModel) {
        if (action.equals(MBTPopUpActions.REMOVE)) {
            this.removeMySelfFromTheParent(actionNode, treeModel);
        }
    }

    public void languageChanged(LanguageChangedEvent evt) {
        MBTPopUpActions.popUpCaptions.put(MBTPopUpActions.REMOVE, I18n.getString("menu.remove"));
    }
}

