/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.actions;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.SwingUtilities;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.modules.db.explorer.actions.DatabaseAction;
import org.netbeans.modules.db.explorer.dlg.AddDriverDialog;
import org.netbeans.modules.db.explorer.infos.DriverListNodeInfo;
import org.netbeans.modules.db.explorer.infos.DriverNodeInfo;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;

public class CustomizeDriverAction
extends DatabaseAction {
    static final long serialVersionUID = -109193000951395612L;
    private Dialog dialog;

    protected boolean enable(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length != 1) {
            return false;
        }
        DriverNodeInfo driverNodeInfo = (DriverNodeInfo)nodeArray[0].getCookie(DriverNodeInfo.class);
        return driverNodeInfo == null || !driverNodeInfo.getURL().equals("sun.jdbc.odbc.JdbcOdbcDriver");
    }

    public void performAction(Node[] nodeArray) {
        final Node[] nodeArray2 = nodeArray;
        boolean bl = false;
        final DriverNodeInfo driverNodeInfo = (DriverNodeInfo)nodeArray2[0].getCookie(DriverNodeInfo.class);
        if (driverNodeInfo == null) {
            return;
        }
        JDBCDriver jDBCDriver = driverNodeInfo.getJDBCDriver();
        if (jDBCDriver == null) {
            return;
        }
        final AddDriverDialog addDriverDialog = new AddDriverDialog(jDBCDriver);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == DialogDescriptor.OK_OPTION) {
                    String string = addDriverDialog.getDisplayName();
                    List list = addDriverDialog.getDriverLocation();
                    String string2 = addDriverDialog.getDriverClass();
                    StringBuffer stringBuffer = new StringBuffer();
                    if (list.size() < 1) {
                        stringBuffer.append(DatabaseAction.bundle().getString("AddDriverDialog_MissingFile"));
                    }
                    if (string2 == null || string2.equals("")) {
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append(", ");
                        }
                        stringBuffer.append(DatabaseAction.bundle().getString("AddDriverDialog_MissingClass"));
                    }
                    if (stringBuffer.length() > 0) {
                        String string3 = MessageFormat.format(DatabaseAction.bundle().getString("AddDriverDialog_ErrorMessage"), stringBuffer.toString());
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string3, 1));
                        return;
                    }
                    CustomizeDriverAction.this.closeDialog();
                    if (string == null || string.equals("")) {
                        string = string2;
                    }
                    try {
                        String string4 = driverNodeInfo.getJDBCDriver().getName();
                        driverNodeInfo.delete();
                        JDBCDriverManager.getDefault().addDriver(JDBCDriver.create(string4, string, string2, list.toArray(new URL[list.size()])));
                    }
                    catch (IOException iOException) {
                    }
                    catch (DatabaseException databaseException) {
                        // empty catch block
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            try {
                                DriverListNodeInfo driverListNodeInfo = (DriverListNodeInfo)nodeArray2[0].getCookie(DriverListNodeInfo.class);
                                if (driverListNodeInfo != null) {
                                    driverListNodeInfo.refreshChildren();
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                }
            }
        };
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)addDriverDialog, CustomizeDriverAction.bundle().getString("AddDriverDialogTitle"), true, actionListener);
        Object[] objectArray = new Object[]{DialogDescriptor.CANCEL_OPTION};
        dialogDescriptor.setClosingOptions(objectArray);
        this.dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        this.dialog.setVisible(true);
    }

    private void closeDialog() {
        if (this.dialog != null) {
            this.dialog.dispose();
        }
    }
}

