/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SingleSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.TabbedContainer;
import org.netbeans.swing.tabcontrol.TabbedContainerUI;
import org.netbeans.swing.tabcontrol.WinsysInfoForTabbedContainer;
import org.netbeans.swing.tabcontrol.event.ArrayDiff;
import org.netbeans.swing.tabcontrol.event.ComplexListDataEvent;
import org.netbeans.swing.tabcontrol.event.ComplexListDataListener;
import org.netbeans.swing.tabcontrol.event.TabActionEvent;
import org.netbeans.swing.tabcontrol.event.VeryComplexListDataEvent;
import org.netbeans.swing.tabcontrol.plaf.EqualPolygon;
import org.netbeans.swing.tabcontrol.plaf.FxProvider;
import org.netbeans.swing.tabcontrol.plaf.StackLayout;

public class DefaultTabbedContainerUI
extends TabbedContainerUI {
    private ActionListener actionListener = null;
    public static final String KEY_EDITOR_CONTENT_BORDER = "TabbedContainer.editor.contentBorder";
    public static final String KEY_EDITOR_TABS_BORDER = "TabbedContainer.editor.tabsBorder";
    public static final String KEY_EDITOR_OUTER_BORDER = "TabbedContainer.editor.outerBorder";
    public static final String KEY_VIEW_CONTENT_BORDER = "TabbedContainer.view.contentBorder";
    public static final String KEY_VIEW_TABS_BORDER = "TabbedContainer.view.tabsBorder";
    public static final String KEY_VIEW_OUTER_BORDER = "TabbedContainer.view.outerBorder";
    public static final String KEY_SLIDING_CONTENT_BORDER = "TabbedContainer.sliding.contentBorder";
    public static final String KEY_SLIDING_TABS_BORDER = "TabbedContainer.sliding.tabsBorder";
    public static final String KEY_SLIDING_OUTER_BORDER = "TabbedContainer.sliding.outerBorder";
    public static final String KEY_TOOLBAR_CONTENT_BORDER = "TabbedContainer.toolbar.contentBorder";
    public static final String KEY_TOOLBAR_TABS_BORDER = "TabbedContainer.toolbar.tabsBorder";
    public static final String KEY_TOOLBAR_OUTER_BORDER = "TabbedContainer.toolbar.outerBorder";
    protected ComponentListener componentListener = null;
    protected ChangeListener selectionListener = null;
    protected ComplexListDataListener modelListener = null;
    protected LayoutManager contentDisplayerLayout = null;
    protected PropertyChangeListener propertyChangeListener = null;
    protected FxProvider slideEffectManager = null;
    protected JComponent contentDisplayer = null;
    protected TabDisplayer tabDisplayer = null;
    private HierarchyListener hierarchyListener = null;
    private MouseListener forward = null;
    private Point scratchPoint = new Point();
    private boolean bug4924561knownShowing = false;
    static final boolean NO_EFFECTS = Boolean.getBoolean("nb.tabcontrol.no.fx");
    static final boolean NO_SCALE = Boolean.getBoolean("nb.tabcontrol.fx.no.scaling");
    static final boolean USE_SWINGPAINTING = Boolean.getBoolean("nb.tabcontrol.fx.swingpainting");
    static final boolean ADD_TO_GLASSPANE = Boolean.getBoolean("nb.tabcontrol.fx.use.resizing");
    static final boolean EFFECTS_EVERYWHERE = Boolean.getBoolean("nb.tabcontrol.fx.everywhere") || Boolean.getBoolean("nb.tabcontrol.fx.gratuitous");
    static final boolean USE_ALPHA = Boolean.getBoolean("nb.tabcontrol.fx.use.alpha") || Boolean.getBoolean("nb.tabcontrol.fx.gratuitous");
    static boolean SYNCHRONOUS_PAINTING = Boolean.getBoolean("nb.tabcontrol.fx.synchronous");
    static float INCREMENT = 0.07f;
    static int TIMER = 25;

    public DefaultTabbedContainerUI(TabbedContainer tabbedContainer) {
        super(tabbedContainer);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new DefaultTabbedContainerUI((TabbedContainer)jComponent);
    }

    public final void installUI(JComponent jComponent) {
        assert (jComponent == this.container);
        this.container.setLayout(this.createLayout());
        this.contentDisplayer = this.createContentDisplayer();
        this.tabDisplayer = this.createTabDisplayer();
        this.selectionListener = this.createSelectionListener();
        this.modelListener = this.createModelListener();
        this.componentListener = this.createComponentListener();
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.contentDisplayerLayout = this.createContentDisplayerLayout();
        this.slideEffectManager = this.createFxProvider();
        this.actionListener = this.createDisplayerActionListener();
        this.container.setLayout(this.createLayout());
        this.hierarchyListener = new ContainerHierarchyListener();
        this.forward = new ForwardingMouseListener(this.container);
        this.installContentDisplayer();
        this.installTabDisplayer();
        this.installBorders();
        this.installListeners();
        this.install();
        this.tabDisplayer.getSelectionModel().addChangeListener(this.selectionListener);
    }

    TabDisplayer getTabDisplayer() {
        return this.tabDisplayer;
    }

    public final void uninstallUI(JComponent jComponent) {
        assert (jComponent == this.container);
        this.tabDisplayer.getSelectionModel().removeChangeListener(this.selectionListener);
        this.uninstall();
        this.uninstallListeners();
        this.uninstallDisplayers();
        this.container = null;
        this.contentDisplayer = null;
        this.tabDisplayer = null;
        this.selectionListener = null;
        this.modelListener = null;
        this.componentListener = null;
        this.propertyChangeListener = null;
        this.contentDisplayerLayout = null;
        this.actionListener = null;
        this.forward = null;
    }

    protected void install() {
    }

    protected void uninstall() {
    }

    protected boolean uichange() {
        this.installBorders();
        return false;
    }

    protected void installContentDisplayer() {
        this.contentDisplayer.setLayout(this.contentDisplayerLayout);
        this.container.add((Component)this.contentDisplayer, "Center");
    }

    protected void installTabDisplayer() {
        this.container.add((Component)this.tabDisplayer, "North");
        this.tabDisplayer.registerShortcuts(this.container);
    }

    protected void installBorders() {
        String string;
        String string2;
        String string3;
        switch (this.container.getType()) {
            case 1: {
                string3 = KEY_EDITOR_TABS_BORDER;
                string2 = KEY_EDITOR_CONTENT_BORDER;
                string = KEY_EDITOR_OUTER_BORDER;
                break;
            }
            case 0: {
                string3 = KEY_VIEW_TABS_BORDER;
                string2 = KEY_VIEW_CONTENT_BORDER;
                string = KEY_VIEW_OUTER_BORDER;
                break;
            }
            case 2: {
                string3 = KEY_SLIDING_TABS_BORDER;
                string2 = KEY_SLIDING_CONTENT_BORDER;
                string = KEY_SLIDING_OUTER_BORDER;
                break;
            }
            case 3: {
                string3 = KEY_TOOLBAR_TABS_BORDER;
                string2 = KEY_TOOLBAR_CONTENT_BORDER;
                string = KEY_TOOLBAR_OUTER_BORDER;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown type: " + this.container.getType());
            }
        }
        try {
            Border border = (Border)UIManager.get(string2);
            this.contentDisplayer.setBorder(border);
            border = (Border)UIManager.get(string3);
            this.tabDisplayer.setBorder(border);
            border = (Border)UIManager.get(string);
            this.container.setBorder(border);
        }
        catch (ClassCastException classCastException) {
            System.err.println("Expected a border from UIManager for " + string3 + "," + string2 + "," + string);
        }
    }

    protected void installListeners() {
        this.container.addComponentListener(this.componentListener);
        this.container.addHierarchyListener(this.hierarchyListener);
        this.tabDisplayer.addMouseListener(this.forward);
        this.contentDisplayer.addMouseListener(this.forward);
    }

    protected void attachModelAndSelectionListeners() {
        this.container.getModel().addComplexListDataListener(this.modelListener);
        this.container.addPropertyChangeListener(this.propertyChangeListener);
        this.tabDisplayer.setActive(this.container.isActive());
        this.tabDisplayer.addActionListener(this.actionListener);
    }

    protected void detachModelAndSelectionListeners() {
        this.container.getModel().removeComplexListDataListener(this.modelListener);
        this.container.removePropertyChangeListener(this.propertyChangeListener);
        this.tabDisplayer.removeActionListener(this.actionListener);
    }

    protected void uninstallListeners() {
        this.container.removeComponentListener(this.componentListener);
        this.container.removeHierarchyListener(this.hierarchyListener);
        this.componentListener = null;
        this.propertyChangeListener = null;
        this.tabDisplayer.removeMouseListener(this.forward);
        this.contentDisplayer.removeMouseListener(this.forward);
    }

    protected void uninstallDisplayers() {
        this.container.remove(this.contentDisplayer);
        this.container.remove(this.tabDisplayer);
        this.tabDisplayer.unregisterShortcuts(this.container);
        this.contentDisplayer.removeAll();
        this.contentDisplayer = null;
        this.tabDisplayer = null;
    }

    protected TabDisplayer createTabDisplayer() {
        TabDisplayer tabDisplayer = null;
        WinsysInfoForTabbedContainer winsysInfoForTabbedContainer = this.container.getContainerWinsysInfo();
        tabDisplayer = winsysInfoForTabbedContainer != null ? new TabDisplayer(this.container.getModel(), this.container.getType(), winsysInfoForTabbedContainer) : new TabDisplayer(this.container.getModel(), this.container.getType(), this.container.getLocationInformer());
        tabDisplayer.setName("Tab Displayer");
        return tabDisplayer;
    }

    protected JPanel createContentDisplayer() {
        JPanel jPanel = new JPanel();
        jPanel.setName("Content displayer");
        return jPanel;
    }

    protected FxProvider createFxProvider() {
        if (NO_EFFECTS || this.tabDisplayer.getType() != 2 && !EFFECTS_EVERYWHERE) {
            return new NoOpFxProvider();
        }
        if (ADD_TO_GLASSPANE) {
            return new LiveComponentSlideFxProvider();
        }
        return new ImageSlideFxProvider();
    }

    protected LayoutManager createContentDisplayerLayout() {
        return new StackLayout();
    }

    protected LayoutManager createLayout() {
        if (this.container.getType() == 2) {
            return new SlidingTabsLayout();
        }
        if (this.container.getType() == 3) {
            return new ToolbarTabsLayout();
        }
        return new BorderLayout();
    }

    protected ComponentListener createComponentListener() {
        return new ContainerComponentListener();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new ContainerPropertyChangeListener();
    }

    private ActionListener createDisplayerActionListener() {
        return new DisplayerActionListener();
    }

    protected void ensureSelectedComponentIsShowing() {
        int n = this.tabDisplayer.getSelectionModel().getSelectedIndex();
        if (n != -1) {
            TabData tabData = this.container.getModel().getTab(n);
            this.showComponent(this.toComp(tabData));
        }
    }

    protected final Component toComp(TabData tabData) {
        return this.container.getComponentConverter().getComponent(tabData);
    }

    protected Component showComponent(Component component) {
        if (this.contentDisplayerLayout instanceof StackLayout) {
            StackLayout stackLayout = (StackLayout)this.contentDisplayerLayout;
            Component component2 = stackLayout.getVisibleComponent();
            stackLayout.showComponent(component, this.contentDisplayer);
            if (component != null) {
                Integer n = (Integer)((JComponent)component).getClientProperty("MultiViewBorderHack.topOffset");
                this.contentDisplayer.putClientProperty("MultiViewBorderHack.topOffset", n);
            } else {
                this.contentDisplayer.putClientProperty("MultiViewBorderHack.topOffset", null);
            }
            if (component2 != component) {
                this.maybeRemoveLastComponent(component2);
                return component2;
            }
        }
        return null;
    }

    protected final void showComponentWithFxProvider(Component component) {
        if (this.slideEffectManager == null || !this.container.isShowing() || !(component instanceof JComponent)) {
            Component component2 = this.showComponent(component);
            this.maybeRemoveLastComponent(component2);
        } else {
            this.slideEffectManager.start((JComponent)component, this.container.getRootPane(), this.tabDisplayer.getClientProperty("orientation"));
        }
    }

    private final void maybeRemoveLastComponent(Component component) {
        if (component != null && this.container.getContentPolicy() == 3) {
            this.contentDisplayer.remove(component);
        }
    }

    protected void initDisplayer() {
        if (this.container.getContentPolicy() == 1) {
            List<TabData> list = this.container.getModel().getTabs();
            Component component = null;
            Iterator<TabData> iterator = list.iterator();
            while (iterator.hasNext()) {
                component = this.toComp(iterator.next());
                this.contentDisplayer.add(component, "");
            }
        } else {
            int n = this.tabDisplayer.getSelectionModel().getSelectedIndex();
            if (n != -1) {
                TabData tabData = this.container.getModel().getTab(n);
                this.contentDisplayer.add(this.toComp(tabData), "");
            }
        }
        this.updateActiveState();
    }

    protected ComplexListDataListener createModelListener() {
        return new ModelListener();
    }

    protected ChangeListener createSelectionListener() {
        return new SelectionListener();
    }

    private void updateActiveState() {
        TabDisplayer tabDisplayer = this.tabDisplayer;
        TabbedContainer tabbedContainer = this.container;
        if (tabDisplayer != null && tabbedContainer != null) {
            tabDisplayer.setActive(tabbedContainer.isActive());
        }
    }

    public Rectangle getTabRect(int n, Rectangle rectangle) {
        if (rectangle == null) {
            rectangle = new Rectangle();
        }
        this.tabDisplayer.getTabRect(n, rectangle);
        Point point = this.tabDisplayer.getLocation();
        rectangle.x += point.x;
        rectangle.y += point.y;
        return rectangle;
    }

    protected void requestAttention(int n) {
        this.tabDisplayer.requestAttention(n);
    }

    protected void cancelRequestAttention(int n) {
        this.tabDisplayer.cancelRequestAttention(n);
    }

    public void setShowCloseButton(boolean bl) {
        this.tabDisplayer.setShowCloseButton(bl);
    }

    public boolean isShowCloseButton() {
        return this.tabDisplayer.isShowCloseButton();
    }

    protected final void updateOrientation() {
        if (!this.container.isDisplayable()) {
            return;
        }
        if (Boolean.FALSE.equals(this.container.getClientProperty("manageTabPosition"))) {
            return;
        }
        Object object = this.tabDisplayer.getClientProperty("orientation");
        Container container = this.container.getTopLevelAncestor();
        Rectangle rectangle = this.container.getBounds();
        rectangle = SwingUtilities.convertRectangle(this.container, rectangle, container);
        boolean bl = rectangle.width < rectangle.height;
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = container.getWidth() - (rectangle.x + rectangle.width);
        int n4 = container.getHeight() - (rectangle.y + rectangle.height);
        Object object2 = !bl ? (n4 > n2 ? TabDisplayer.ORIENTATION_NORTH : TabDisplayer.ORIENTATION_SOUTH) : (n > n3 ? TabDisplayer.ORIENTATION_EAST : TabDisplayer.ORIENTATION_WEST);
        if (object != object2) {
            this.tabDisplayer.putClientProperty("orientation", object2);
            this.container.validate();
        }
    }

    public int tabForCoordinate(Point point) {
        point = SwingUtilities.convertPoint(this.container, point, this.tabDisplayer);
        return this.tabDisplayer.tabForCoordinate(point);
    }

    public void makeTabVisible(int n) {
        this.tabDisplayer.makeTabVisible(n);
    }

    public SingleSelectionModel getSelectionModel() {
        return this.tabDisplayer.getSelectionModel();
    }

    public Image createImageOfTab(int n) {
        return this.tabDisplayer.getUI().createImageOfTab(n);
    }

    public Polygon getExactTabIndication(int n) {
        Polygon polygon = this.tabDisplayer.getUI().getExactTabIndication(n);
        this.scratchPoint.setLocation(0, 0);
        Point point = SwingUtilities.convertPoint(this.tabDisplayer, this.scratchPoint, this.container);
        polygon.translate(-point.x, -point.y);
        return this.appendContentBoundsTo(polygon);
    }

    public Polygon getInsertTabIndication(int n) {
        Polygon polygon = this.tabDisplayer.getUI().getInsertTabIndication(n);
        this.scratchPoint.setLocation(0, 0);
        Point point = SwingUtilities.convertPoint(this.tabDisplayer, this.scratchPoint, this.container);
        polygon.translate(-point.x, -point.y);
        return this.appendContentBoundsTo(polygon);
    }

    private Polygon appendContentBoundsTo(Polygon polygon) {
        int n;
        int n2 = this.contentDisplayer.getWidth();
        int n3 = this.contentDisplayer.getHeight();
        int[] nArray = new int[polygon.npoints + 4];
        int[] nArray2 = new int[nArray.length];
        int n4 = 0;
        Object object = this.tabDisplayer.getClientProperty("orientation");
        int n5 = this.tabDisplayer.getHeight();
        if (object == null || object == TabDisplayer.ORIENTATION_NORTH) {
            nArray[n4] = 0;
            nArray2[n4] = n5;
            nArray[++n4] = polygon.xpoints[polygon.npoints - 1];
            nArray2[n4] = n5;
            ++n4;
            for (n = 0; n < polygon.npoints - 2; ++n) {
                nArray[n4] = polygon.xpoints[n];
                nArray2[n4] = polygon.ypoints[n];
                ++n4;
            }
            nArray[n4] = nArray[n4 - 1];
            nArray2[n4] = n5;
            nArray[++n4] = n2 - 1;
            nArray2[n4] = n5;
            nArray[++n4] = n2 - 1;
            nArray2[n4] = n3 - 1;
            nArray[++n4] = 0;
            nArray2[n4] = n3 - 1;
        } else if (object == TabDisplayer.ORIENTATION_SOUTH) {
            int n6;
            n = this.contentDisplayer.getHeight() * 2;
            nArray[n4] = 0;
            nArray2[n4] = 0;
            nArray[++n4] = this.container.getWidth();
            nArray2[n4] = 0;
            nArray[++n4] = this.container.getWidth();
            nArray2[n4] = this.container.getHeight() - n5;
            ++n4;
            int n7 = 0;
            int n8 = Integer.MIN_VALUE;
            for (n6 = polygon.npoints - 2; n6 >= 0; --n6) {
                if (n8 < polygon.ypoints[n6]) {
                    n7 = n6;
                    n8 = polygon.ypoints[n6];
                    continue;
                }
                if (n8 == polygon.ypoints[n6]) break;
            }
            n6 = n7 - 1;
            for (int i = polygon.npoints - 1; i >= 0; --i) {
                nArray[n4] = polygon.xpoints[n6];
                nArray2[n4] = nArray2[n4] == n8 ? Math.min(this.tabDisplayer.getLocation().y, polygon.ypoints[n6] + n) : polygon.ypoints[n6] + n;
                ++n4;
                if (++n6 != polygon.npoints - 1) continue;
                n6 = 0;
            }
            nArray[n4] = 0;
            nArray2[n4] = this.container.getHeight() - n5;
        } else {
            nArray = polygon.xpoints;
            nArray2 = polygon.ypoints;
        }
        EqualPolygon equalPolygon = new EqualPolygon(nArray, nArray2, nArray.length);
        return equalPolygon;
    }

    public Rectangle getContentArea() {
        return this.contentDisplayer.getBounds();
    }

    public Rectangle getTabsArea() {
        return this.tabDisplayer.getBounds();
    }

    public int dropIndexOfPoint(Point point) {
        Point point2 = SwingUtilities.convertPoint(this.container, point, this.tabDisplayer);
        return this.tabDisplayer.getUI().dropIndexOfPoint(point2);
    }

    public Rectangle getTabsArea(Rectangle rectangle) {
        return this.tabDisplayer.getBounds();
    }

    static {
        boolean bl = Boolean.getBoolean("nb.tabcontrol.fx.gratuitous");
        String string = System.getProperty("nb.tabcontrol.fx.increment");
        if (string != null) {
            try {
                INCREMENT = Float.parseFloat(string);
            }
            catch (Exception exception) {
                System.err.println("Bad float value specified: \"" + string + "\"");
            }
        } else if (bl) {
            INCREMENT = 0.02f;
        }
        if ((string = System.getProperty("nb.tabcontrol.fx.timer")) != null) {
            try {
                TIMER = Integer.parseInt(string);
            }
            catch (Exception exception) {
                System.err.println("Bad integer value specified: \"" + string + "\"");
            }
        } else if (bl) {
            TIMER = 7;
        }
        if (bl) {
            SYNCHRONOUS_PAINTING = true;
        }
    }

    private static final class ForwardingMouseListener
    implements MouseListener {
        private final Container c;

        public ForwardingMouseListener(Container container) {
            this.c = container;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.forward(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.forward(mouseEvent);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            this.forward(mouseEvent);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.forward(mouseEvent);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.forward(mouseEvent);
        }

        private void forward(MouseEvent mouseEvent) {
            MouseListener[] mouseListenerArray = this.c.getMouseListeners();
            if (mouseListenerArray.length == 0 || mouseEvent.isConsumed()) {
                return;
            }
            MouseEvent mouseEvent2 = SwingUtilities.convertMouseEvent((Component)mouseEvent.getSource(), mouseEvent, this.c);
            block7: for (int i = 0; i < mouseListenerArray.length; ++i) {
                switch (mouseEvent2.getID()) {
                    case 504: {
                        mouseListenerArray[i].mouseEntered(mouseEvent2);
                        continue block7;
                    }
                    case 505: {
                        mouseListenerArray[i].mouseExited(mouseEvent2);
                        continue block7;
                    }
                    case 501: {
                        mouseListenerArray[i].mousePressed(mouseEvent2);
                        continue block7;
                    }
                    case 502: {
                        mouseListenerArray[i].mouseReleased(mouseEvent2);
                        continue block7;
                    }
                    case 500: {
                        mouseListenerArray[i].mouseClicked(mouseEvent2);
                        continue block7;
                    }
                    default: {
                        assert (false);
                        continue block7;
                    }
                }
            }
        }
    }

    private final class LiveComponentSlideFxProvider
    extends FxProvider
    implements ActionListener {
        private Timer timer = null;
        private Component prevGlassPane = null;
        private Dimension d = null;
        private LiveComponentResizingGlassPane customGlassPane = null;

        private LiveComponentSlideFxProvider() {
        }

        protected void doStart() {
            if (this.timer == null) {
                this.timer = new Timer(TIMER, this);
                this.timer.setRepeats(true);
            }
            this.prevGlassPane = this.root.getGlassPane();
            if (this.prevGlassPane.isVisible() && this.prevGlassPane.isShowing()) {
                this.doFinish();
                return;
            }
            this.initSize();
            LiveComponentResizingGlassPane liveComponentResizingGlassPane = this.getCustomGlassPane();
            this.root.setGlassPane(liveComponentResizingGlassPane);
            liveComponentResizingGlassPane.setIncrement(0.1f);
            liveComponentResizingGlassPane.setBounds(this.root.getBounds());
            liveComponentResizingGlassPane.setVisible(true);
            liveComponentResizingGlassPane.revalidate();
            this.timer.start();
        }

        private void initSize() {
            boolean bl;
            this.d = this.comp.getPreferredSize();
            Dimension dimension = DefaultTabbedContainerUI.this.contentDisplayer.getSize();
            this.d.width = Math.max(dimension.width, this.d.width);
            this.d.height = Math.max(dimension.height, this.d.height);
            boolean bl2 = bl = this.orientation == TabDisplayer.ORIENTATION_EAST || this.orientation == TabDisplayer.ORIENTATION_WEST;
            if (this.d.width == 0 || this.d.height == 0) {
                if (bl) {
                    this.d.width = this.root.getWidth();
                    this.d.height = DefaultTabbedContainerUI.this.tabDisplayer.getHeight();
                } else {
                    this.d.width = DefaultTabbedContainerUI.this.tabDisplayer.getWidth();
                    this.d.height = this.root.getHeight();
                }
            } else if (bl) {
                this.d.height = Math.max(this.d.height, DefaultTabbedContainerUI.this.tabDisplayer.getHeight());
            } else {
                this.d.width = Math.max(this.d.width, DefaultTabbedContainerUI.this.tabDisplayer.getWidth());
            }
        }

        public void cleanup() {
            this.timer.stop();
            this.root.setGlassPane(this.prevGlassPane);
            this.prevGlassPane.setVisible(false);
            this.customGlassPane.remove(this.comp);
        }

        protected void doFinish() {
            DefaultTabbedContainerUI.this.showComponent(this.comp);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            float f = this.customGlassPane.getIncrement();
            if (f >= 1.0f) {
                this.finish();
            } else {
                this.customGlassPane.setIncrement(f + INCREMENT);
            }
        }

        private LiveComponentResizingGlassPane getCustomGlassPane() {
            if (this.customGlassPane == null) {
                this.customGlassPane = new LiveComponentResizingGlassPane();
                this.customGlassPane.setOpaque(false);
            }
            return this.customGlassPane;
        }

        private class LiveComponentResizingGlassPane
        extends JPanel {
            private float inc = 0.0f;
            private Rectangle rect = new Rectangle();
            private Rectangle r2 = new Rectangle();
            private boolean changed = true;

            private LiveComponentResizingGlassPane() {
            }

            private void setIncrement(float f) {
                this.inc = f;
                this.changed = true;
                if (this.isShowing() && LiveComponentSlideFxProvider.this.comp.getParent() != this) {
                    this.add(LiveComponentSlideFxProvider.this.comp);
                    LiveComponentSlideFxProvider.this.comp.setVisible(true);
                }
                this.doLayout();
            }

            public void doLayout() {
                Rectangle rectangle = this.getImageBounds();
                LiveComponentSlideFxProvider.this.comp.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }

            private float getIncrement() {
                return this.inc;
            }

            private Rectangle getImageBounds() {
                if (!this.changed) {
                    return this.rect;
                }
                TabDisplayer tabDisplayer = DefaultTabbedContainerUI.this.tabDisplayer;
                this.r2.setBounds(0, 0, ((Component)tabDisplayer).getWidth(), ((Component)tabDisplayer).getHeight());
                Rectangle rectangle = SwingUtilities.convertRectangle(tabDisplayer, this.r2, this);
                if (LiveComponentSlideFxProvider.this.orientation == TabDisplayer.ORIENTATION_WEST) {
                    this.rect.x = rectangle.x + rectangle.width;
                    this.rect.y = rectangle.y;
                    this.rect.width = Math.round(this.inc * (float)((LiveComponentSlideFxProvider)LiveComponentSlideFxProvider.this).d.width);
                    this.rect.height = rectangle.height;
                } else if (LiveComponentSlideFxProvider.this.orientation == TabDisplayer.ORIENTATION_EAST) {
                    this.rect.width = Math.round(this.inc * (float)((LiveComponentSlideFxProvider)LiveComponentSlideFxProvider.this).d.width);
                    this.rect.height = rectangle.height;
                    this.rect.x = rectangle.x - this.rect.width;
                    this.rect.y = rectangle.y;
                } else if (LiveComponentSlideFxProvider.this.orientation == TabDisplayer.ORIENTATION_SOUTH) {
                    this.rect.width = rectangle.width;
                    this.rect.height = Math.round(this.inc * (float)((LiveComponentSlideFxProvider)LiveComponentSlideFxProvider.this).d.height);
                    this.rect.x = rectangle.x;
                    this.rect.y = rectangle.y - this.rect.height;
                } else if (LiveComponentSlideFxProvider.this.orientation == TabDisplayer.ORIENTATION_NORTH) {
                    this.rect.x = rectangle.x;
                    this.rect.y = rectangle.y + rectangle.height;
                    this.rect.width = rectangle.width;
                    this.rect.height = Math.round(this.inc * (float)((LiveComponentSlideFxProvider)LiveComponentSlideFxProvider.this).d.height);
                }
                this.changed = false;
                return this.rect;
            }
        }
    }

    private final class ImageSlideFxProvider
    extends FxProvider
    implements ActionListener {
        private Timer timer = null;
        private Component prevGlassPane = null;
        private Dimension d = null;
        private BufferedImage img = null;
        private ImageScalingGlassPane customGlassPane = null;

        private ImageSlideFxProvider() {
        }

        protected void doStart() {
            if (this.timer == null) {
                this.timer = new Timer(TIMER, this);
                this.timer.setRepeats(true);
            }
            this.prevGlassPane = this.root.getGlassPane();
            if (this.prevGlassPane.isVisible() && this.prevGlassPane.isShowing()) {
                this.doFinish();
                return;
            }
            this.initSize();
            this.img = this.createImageOfComponent();
            ImageScalingGlassPane imageScalingGlassPane = this.getCustomGlassPane();
            this.root.setGlassPane(imageScalingGlassPane);
            imageScalingGlassPane.setIncrement(0.1f);
            imageScalingGlassPane.setBounds(this.root.getBounds());
            imageScalingGlassPane.setVisible(true);
            imageScalingGlassPane.revalidate();
            this.timer.start();
        }

        public void cleanup() {
            this.timer.stop();
            this.root.setGlassPane(this.prevGlassPane);
            this.prevGlassPane.setVisible(false);
            if (this.img != null) {
                this.img.flush();
            }
            this.img = null;
        }

        protected void doFinish() {
            DefaultTabbedContainerUI.this.showComponent(this.comp);
        }

        private void initSize() {
            boolean bl;
            this.d = this.comp.getPreferredSize();
            Dimension dimension = DefaultTabbedContainerUI.this.contentDisplayer.getSize();
            this.d.width = Math.max(dimension.width, this.d.width);
            this.d.height = Math.max(dimension.height, this.d.height);
            boolean bl2 = bl = this.orientation == TabDisplayer.ORIENTATION_EAST || this.orientation == TabDisplayer.ORIENTATION_WEST;
            if (this.d.width == 0 || this.d.height == 0) {
                if (bl) {
                    this.d.width = this.root.getWidth();
                    this.d.height = DefaultTabbedContainerUI.this.tabDisplayer.getHeight();
                } else {
                    this.d.width = DefaultTabbedContainerUI.this.tabDisplayer.getWidth();
                    this.d.height = this.root.getHeight();
                }
            } else if (bl) {
                this.d.height = Math.max(this.d.height, DefaultTabbedContainerUI.this.tabDisplayer.getHeight());
            } else {
                this.d.width = Math.max(this.d.width, DefaultTabbedContainerUI.this.tabDisplayer.getWidth());
            }
        }

        private BufferedImage createImageOfComponent() {
            if (USE_SWINGPAINTING) {
                return null;
            }
            if (this.d.width == 0 || this.d.height == 0) {
                this.finish();
            }
            BufferedImage bufferedImage = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(this.d.width, this.d.height);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            TabDisplayer tabDisplayer = DefaultTabbedContainerUI.this.tabDisplayer;
            tabDisplayer.setBounds(0, 0, this.d.width, this.d.height);
            this.comp.paint(graphics2D);
            return bufferedImage;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            float f = this.customGlassPane.getIncrement();
            if (f >= 1.0f) {
                this.finish();
            } else {
                this.customGlassPane.setIncrement(f + INCREMENT);
            }
        }

        private ImageScalingGlassPane getCustomGlassPane() {
            if (this.customGlassPane == null) {
                this.customGlassPane = new ImageScalingGlassPane();
                this.customGlassPane.setOpaque(false);
            }
            return this.customGlassPane;
        }

        private class ImageScalingGlassPane
        extends JPanel {
            private float inc = 0.0f;
            private Rectangle rect = new Rectangle();
            private Rectangle r2 = new Rectangle();
            private boolean changed = true;

            private ImageScalingGlassPane() {
            }

            private void setIncrement(float f) {
                this.inc = f;
                this.changed = true;
                if (this.isShowing()) {
                    Rectangle rectangle = this.getImageBounds();
                    if (SYNCHRONOUS_PAINTING) {
                        this.paintImmediately(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    } else {
                        this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    }
                }
            }

            private float getIncrement() {
                return this.inc;
            }

            private Rectangle getImageBounds() {
                if (!this.changed) {
                    return this.rect;
                }
                TabDisplayer tabDisplayer = DefaultTabbedContainerUI.this.tabDisplayer;
                this.r2.setBounds(0, 0, ((Component)tabDisplayer).getWidth(), ((Component)tabDisplayer).getHeight());
                Rectangle rectangle = SwingUtilities.convertRectangle(tabDisplayer, this.r2, this);
                if (ImageSlideFxProvider.this.orientation == TabDisplayer.ORIENTATION_WEST) {
                    this.rect.x = rectangle.x + rectangle.width;
                    this.rect.y = rectangle.y;
                    this.rect.width = Math.round(this.inc * (float)((ImageSlideFxProvider)ImageSlideFxProvider.this).d.width);
                    this.rect.height = rectangle.height;
                } else if (ImageSlideFxProvider.this.orientation == TabDisplayer.ORIENTATION_EAST) {
                    this.rect.width = Math.round(this.inc * (float)((ImageSlideFxProvider)ImageSlideFxProvider.this).d.width);
                    this.rect.height = rectangle.height;
                    this.rect.x = rectangle.x - this.rect.width;
                    this.rect.y = rectangle.y;
                } else if (ImageSlideFxProvider.this.orientation == TabDisplayer.ORIENTATION_SOUTH) {
                    this.rect.width = rectangle.width;
                    this.rect.height = Math.round(this.inc * (float)((ImageSlideFxProvider)ImageSlideFxProvider.this).d.height);
                    this.rect.x = rectangle.x;
                    this.rect.y = rectangle.y - this.rect.height;
                } else if (ImageSlideFxProvider.this.orientation == TabDisplayer.ORIENTATION_NORTH) {
                    this.rect.x = rectangle.x;
                    this.rect.y = rectangle.y + rectangle.height;
                    this.rect.width = rectangle.width;
                    this.rect.height = Math.round(this.inc * (float)((ImageSlideFxProvider)ImageSlideFxProvider.this).d.height);
                }
                this.changed = false;
                return this.rect;
            }

            public void paint(Graphics graphics) {
                try {
                    if (USE_SWINGPAINTING) {
                        SwingUtilities.paintComponent(graphics, ImageSlideFxProvider.this.comp, this, this.getImageBounds());
                    } else {
                        Graphics2D graphics2D = (Graphics2D)graphics;
                        Composite composite = null;
                        composite = graphics2D.getComposite();
                        graphics2D.setComposite(AlphaComposite.getInstance(3, Math.min(0.99f, this.inc)));
                        Rectangle rectangle = this.getImageBounds();
                        if (NO_SCALE) {
                            AffineTransform affineTransform = AffineTransform.getTranslateInstance(rectangle.x, rectangle.y);
                            graphics2D.drawRenderedImage(ImageSlideFxProvider.this.img, affineTransform);
                        } else {
                            graphics2D.drawImage(ImageSlideFxProvider.this.img, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, 0, 0, ((ImageSlideFxProvider)ImageSlideFxProvider.this).d.width, ((ImageSlideFxProvider)ImageSlideFxProvider.this).d.height, this.getBackground(), null);
                        }
                        if (composite != null) {
                            graphics2D.setComposite(composite);
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    ImageSlideFxProvider.this.finish();
                }
            }
        }
    }

    private final class NoOpFxProvider
    extends FxProvider {
        private NoOpFxProvider() {
        }

        public void cleanup() {
        }

        protected void doFinish() {
            DefaultTabbedContainerUI.this.showComponent(this.comp);
        }

        protected void doStart() {
            this.finish();
        }
    }

    private class SlidingTabsLayout
    implements LayoutManager {
        private SlidingTabsLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void layoutContainer(Container container) {
            TabDisplayer tabDisplayer = DefaultTabbedContainerUI.this.tabDisplayer;
            Object object = tabDisplayer.getClientProperty("orientation");
            Dimension dimension = DefaultTabbedContainerUI.this.tabDisplayer.getPreferredSize();
            Insets insets = DefaultTabbedContainerUI.this.container.getInsets();
            int n = container.getWidth() - (insets.left + insets.right);
            int n2 = container.getHeight() - (insets.top + insets.bottom);
            if (object == TabDisplayer.ORIENTATION_NORTH) {
                tabDisplayer.setBounds(insets.left, insets.top, n, dimension.height);
                DefaultTabbedContainerUI.this.contentDisplayer.setBounds(insets.left, insets.top + dimension.height, n, container.getHeight() - (dimension.height + insets.top + insets.bottom));
            } else if (object == TabDisplayer.ORIENTATION_SOUTH) {
                DefaultTabbedContainerUI.this.contentDisplayer.setBounds(insets.top, insets.left, n, container.getHeight() - (dimension.height + insets.top + insets.bottom));
                tabDisplayer.setBounds(insets.left, container.getHeight() - (dimension.height + insets.top + insets.bottom), n, dimension.height);
            } else if (object == TabDisplayer.ORIENTATION_EAST) {
                DefaultTabbedContainerUI.this.contentDisplayer.setBounds(insets.left, insets.top, n - dimension.width, n2);
                tabDisplayer.setBounds(container.getWidth() - (insets.right + dimension.width), insets.top, dimension.width, n2);
            } else if (object == TabDisplayer.ORIENTATION_WEST) {
                tabDisplayer.setBounds(insets.left, insets.top, dimension.width, n2);
                DefaultTabbedContainerUI.this.contentDisplayer.setBounds(insets.left + dimension.width, insets.top, n - dimension.width, n2);
            } else {
                throw new IllegalArgumentException("Unknown orientation: " + object);
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            TabDisplayer tabDisplayer = DefaultTabbedContainerUI.this.tabDisplayer;
            Object object = tabDisplayer.getClientProperty("orientation");
            Dimension dimension = DefaultTabbedContainerUI.this.tabDisplayer.getPreferredSize();
            Insets insets = DefaultTabbedContainerUI.this.container.getInsets();
            Dimension dimension2 = new Dimension();
            Dimension dimension3 = DefaultTabbedContainerUI.this.contentDisplayer.getPreferredSize();
            if (DefaultTabbedContainerUI.this.tabDisplayer.getSelectionModel().getSelectedIndex() == -1) {
                dimension3.width = 0;
                dimension3.height = 0;
            }
            if (object == TabDisplayer.ORIENTATION_NORTH || object == TabDisplayer.ORIENTATION_SOUTH) {
                dimension2.height = insets.top + insets.bottom + dimension3.height + dimension.height;
                dimension2.width = insets.left + insets.right + Math.max(dimension3.width, dimension.width);
            } else {
                dimension2.width = insets.left + insets.right + dimension3.width + dimension.width;
                dimension2.height = insets.top + insets.bottom + Math.max(dimension3.height, dimension.height);
            }
            return dimension2;
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.minimumLayoutSize(container);
        }

        public void removeLayoutComponent(Component component) {
        }
    }

    private class DisplayerActionListener
    implements ActionListener {
        private DisplayerActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TabActionEvent tabActionEvent = (TabActionEvent)actionEvent;
            if (!DefaultTabbedContainerUI.this.shouldPerformAction(tabActionEvent.getActionCommand(), tabActionEvent.getTabIndex(), tabActionEvent.getMouseEvent())) {
                tabActionEvent.consume();
            }
        }
    }

    protected class ModelListener
    implements ComplexListDataListener {
        public void contentsChanged(ListDataEvent listDataEvent) {
            if (listDataEvent instanceof ComplexListDataEvent) {
                ComplexListDataEvent complexListDataEvent = (ComplexListDataEvent)listDataEvent;
                int n = complexListDataEvent.getIndex0();
                if (complexListDataEvent.isUserObjectChanged() && n != -1) {
                    boolean bl;
                    Component component = DefaultTabbedContainerUI.this.contentDisplayer.getComponent(n);
                    Component component2 = DefaultTabbedContainerUI.this.toComp(DefaultTabbedContainerUI.this.tabDisplayer.getModel().getTab(n));
                    DefaultTabbedContainerUI.this.contentDisplayer.remove(component);
                    boolean bl2 = bl = DefaultTabbedContainerUI.this.container.getContentPolicy() == 1 || n == DefaultTabbedContainerUI.this.container.getSelectionModel().getSelectedIndex();
                    if (bl) {
                        DefaultTabbedContainerUI.this.contentDisplayer.add(component2, n);
                    }
                }
                if (complexListDataEvent.isTextChanged()) {
                    this.maybeMakeSelectedTabVisible(complexListDataEvent);
                }
            }
        }

        private void maybeMakeSelectedTabVisible(ComplexListDataEvent complexListDataEvent) {
            if (!DefaultTabbedContainerUI.this.container.isShowing() || DefaultTabbedContainerUI.this.container.getWidth() < 10) {
                return;
            }
            if (DefaultTabbedContainerUI.this.tabDisplayer.getType() == 1) {
                int n = DefaultTabbedContainerUI.this.tabDisplayer.getSelectionModel().getSelectedIndex();
                if (complexListDataEvent.getIndex0() == complexListDataEvent.getIndex1() && complexListDataEvent.getIndex0() == n) {
                    DefaultTabbedContainerUI.this.tabDisplayer.makeTabVisible(n);
                }
            }
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            if (DefaultTabbedContainerUI.this.container.getContentPolicy() == 1) {
                Component component = null;
                for (int i = listDataEvent.getIndex0(); i <= listDataEvent.getIndex1(); ++i) {
                    component = DefaultTabbedContainerUI.this.toComp(DefaultTabbedContainerUI.this.container.getModel().getTab(i));
                    DefaultTabbedContainerUI.this.contentDisplayer.add(component, "");
                }
            }
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            ComplexListDataEvent complexListDataEvent = (ComplexListDataEvent)listDataEvent;
            TabData[] tabDataArray = complexListDataEvent.getAffectedItems();
            for (int i = 0; i < tabDataArray.length; ++i) {
                Component component = DefaultTabbedContainerUI.this.toComp(tabDataArray[i]);
                DefaultTabbedContainerUI.this.contentDisplayer.remove(component);
            }
        }

        public void indicesAdded(ComplexListDataEvent complexListDataEvent) {
            Component component = null;
            if (DefaultTabbedContainerUI.this.container.getContentPolicy() == 1) {
                int[] nArray = complexListDataEvent.getIndices();
                for (int i = 0; i < nArray.length; ++i) {
                    component = DefaultTabbedContainerUI.this.toComp(DefaultTabbedContainerUI.this.container.getModel().getTab(nArray[i]));
                    DefaultTabbedContainerUI.this.contentDisplayer.add(component, "");
                }
            }
        }

        public void indicesRemoved(ComplexListDataEvent complexListDataEvent) {
            int[] nArray = complexListDataEvent.getIndices();
            TabData[] tabDataArray = complexListDataEvent.getAffectedItems();
            for (int i = 0; i < nArray.length; ++i) {
                Component component = DefaultTabbedContainerUI.this.toComp(tabDataArray[i]);
                DefaultTabbedContainerUI.this.contentDisplayer.remove(component);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void indicesChanged(ComplexListDataEvent complexListDataEvent) {
            if (complexListDataEvent instanceof VeryComplexListDataEvent) {
                int n;
                ArrayDiff arrayDiff = ((VeryComplexListDataEvent)complexListDataEvent).getDiff();
                Set<Integer> set = arrayDiff.getDeletedIndices();
                Set<Integer> set2 = arrayDiff.getAddedIndices();
                TabData[] tabDataArray = arrayDiff.getOldData();
                TabData[] tabDataArray2 = arrayDiff.getNewData();
                HashSet<Component> hashSet = new HashSet<Component>();
                if (DefaultTabbedContainerUI.this.container.getContentPolicy() == 1) {
                    for (n = 0; n < tabDataArray2.length; ++n) {
                        hashSet.add(DefaultTabbedContainerUI.this.toComp(tabDataArray2[n]));
                    }
                }
                n = 0;
                Object object = DefaultTabbedContainerUI.this.contentDisplayer.getTreeLock();
                synchronized (object) {
                    TabData tabData;
                    if (!set.isEmpty()) {
                        for (Integer n2 : set) {
                            tabData = tabDataArray[n2];
                            if (hashSet.contains(DefaultTabbedContainerUI.this.toComp(tabData))) continue;
                            DefaultTabbedContainerUI.this.contentDisplayer.remove(DefaultTabbedContainerUI.this.toComp(tabData));
                            n = 1;
                        }
                    }
                    if (DefaultTabbedContainerUI.this.container.getContentPolicy() == 1 && !set2.isEmpty()) {
                        for (Integer n2 : set2) {
                            tabData = tabDataArray2[n2];
                            if (DefaultTabbedContainerUI.this.contentDisplayer.isAncestorOf(DefaultTabbedContainerUI.this.toComp(tabData))) continue;
                            DefaultTabbedContainerUI.this.contentDisplayer.add(DefaultTabbedContainerUI.this.toComp(tabData), "");
                            n = 1;
                        }
                    }
                }
                if (n != 0) {
                    DefaultTabbedContainerUI.this.contentDisplayer.revalidate();
                    DefaultTabbedContainerUI.this.contentDisplayer.repaint();
                }
            }
        }
    }

    protected class SelectionListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            if (DefaultTabbedContainerUI.this.container.isShowing() || DefaultTabbedContainerUI.this.container.getClientProperty("tc") != null) {
                int n = DefaultTabbedContainerUI.this.tabDisplayer.getSelectionModel().getSelectedIndex();
                if (n != -1) {
                    Component component = DefaultTabbedContainerUI.this.toComp(DefaultTabbedContainerUI.this.container.getModel().getTab(n));
                    component.setBounds(0, 0, DefaultTabbedContainerUI.this.contentDisplayer.getWidth(), DefaultTabbedContainerUI.this.contentDisplayer.getHeight());
                    DefaultTabbedContainerUI.this.showComponentWithFxProvider(component);
                } else {
                    DefaultTabbedContainerUI.this.showComponent(null);
                }
            }
        }
    }

    private class ToolbarTabsLayout
    implements LayoutManager {
        private ToolbarTabsLayout() {
        }

        public void layoutContainer(Container container) {
            Dimension dimension = DefaultTabbedContainerUI.this.tabDisplayer.getPreferredSize();
            Insets insets = container.getInsets();
            int n = container.getWidth() - (insets.left + insets.right);
            DefaultTabbedContainerUI.this.tabDisplayer.setBounds(insets.left, insets.top, n, dimension.height);
            DefaultTabbedContainerUI.this.contentDisplayer.setBounds(insets.left, insets.top + dimension.height, n, container.getHeight() - (insets.top + insets.bottom + dimension.height));
        }

        public Dimension minimumLayoutSize(Container container) {
            Dimension dimension = DefaultTabbedContainerUI.this.tabDisplayer.getMinimumSize();
            Dimension dimension2 = DefaultTabbedContainerUI.this.contentDisplayer.getMinimumSize();
            Insets insets = container.getInsets();
            Dimension dimension3 = new Dimension(insets.left + insets.top, insets.right + insets.bottom);
            dimension3.width += Math.max(dimension.width, dimension2.width);
            dimension3.height += dimension.height + dimension2.height;
            return dimension3;
        }

        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension = DefaultTabbedContainerUI.this.tabDisplayer.getPreferredSize();
            Dimension dimension2 = DefaultTabbedContainerUI.this.contentDisplayer.getPreferredSize();
            Insets insets = container.getInsets();
            Dimension dimension3 = new Dimension(insets.left + insets.top, insets.right + insets.bottom);
            dimension3.width += Math.max(dimension.width, dimension2.width);
            dimension3.height += dimension.height + dimension2.height;
            return dimension3;
        }

        public void removeLayoutComponent(Component component) {
        }

        public void addLayoutComponent(String string, Component component) {
        }
    }

    private class ContainerHierarchyListener
    implements HierarchyListener {
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            if ((hierarchyEvent.getChangeFlags() & 4L) != 0L) {
                boolean bl = DefaultTabbedContainerUI.this.container.isShowing();
                if (bl != DefaultTabbedContainerUI.this.bug4924561knownShowing) {
                    if (DefaultTabbedContainerUI.this.container.isShowing()) {
                        DefaultTabbedContainerUI.this.initDisplayer();
                        DefaultTabbedContainerUI.this.attachModelAndSelectionListeners();
                        DefaultTabbedContainerUI.this.ensureSelectedComponentIsShowing();
                        if (DefaultTabbedContainerUI.this.container.getType() == 2) {
                            DefaultTabbedContainerUI.this.updateOrientation();
                        }
                    } else {
                        DefaultTabbedContainerUI.this.detachModelAndSelectionListeners();
                        if (DefaultTabbedContainerUI.this.container.getType() == 2) {
                            DefaultTabbedContainerUI.this.updateOrientation();
                        }
                    }
                }
                DefaultTabbedContainerUI.this.bug4924561knownShowing = bl;
            }
        }
    }

    protected class ContainerComponentListener
    extends ComponentAdapter {
        public void componentMoved(ComponentEvent componentEvent) {
            if (DefaultTabbedContainerUI.this.container.getType() == 2) {
                DefaultTabbedContainerUI.this.updateOrientation();
            }
        }

        public void componentResized(ComponentEvent componentEvent) {
            if (DefaultTabbedContainerUI.this.container.getType() == 2) {
                DefaultTabbedContainerUI.this.updateOrientation();
            }
        }
    }

    protected class ContainerPropertyChangeListener
    implements PropertyChangeListener {
        protected ContainerPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("active".equals(propertyChangeEvent.getPropertyName())) {
                DefaultTabbedContainerUI.this.updateActiveState();
            }
        }
    }

    private static final class DefaultWindowBorder
    implements Border {
        private static final Insets insets = new Insets(1, 1, 2, 2);

        private DefaultWindowBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.translate(n, n2);
            graphics.setColor(UIManager.getColor("controlShadow"));
            graphics.drawRect(0, 0, n3 - 2, n4 - 2);
            graphics.setColor(UIManager.getColor("controlHighlight"));
            graphics.drawLine(n3 - 1, 1, n3 - 1, n4 - 1);
            graphics.drawLine(1, n4 - 1, n3 - 1, n4 - 1);
            graphics.translate(-n, -n2);
        }

        public Insets getBorderInsets(Component component) {
            return insets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }
}

