/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.url;

import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import org.netbeans.modules.url.URLDataObject;
import org.openide.awt.Mnemonics;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;

final class URLPresenter
implements Presenter.Menu,
Presenter.Toolbar,
Presenter.Popup,
ActionListener {
    private final URLDataObject dataObject;

    URLPresenter(URLDataObject uRLDataObject) {
        this.dataObject = uRLDataObject;
    }

    public JMenuItem getMenuPresenter() {
        JMenuItem jMenuItem = new JMenuItem();
        this.initialize(jMenuItem, false);
        return jMenuItem;
    }

    public JMenuItem getPopupPresenter() {
        JMenuItem jMenuItem = new JMenuItem();
        this.initialize(jMenuItem, false);
        return jMenuItem;
    }

    public Component getToolbarPresenter() {
        JButton jButton = new JButton();
        this.initialize(jButton, true);
        return jButton;
    }

    private void initialize(AbstractButton abstractButton, boolean bl) {
        Object object;
        if (bl) {
            object = ImageUtilities.loadImage((String)"org/netbeans/modules/url/urlObject.png");
            try {
                FileObject fileObject = this.dataObject.getPrimaryFile();
                FileSystem.Status status = fileObject.getFileSystem().getStatus();
                object = status.annotateIcon((Image)object, 1, this.dataObject.files());
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
            abstractButton.setIcon(new ImageIcon((Image)object));
        }
        object = new NameChangeListener(abstractButton);
        abstractButton.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)object, (Object)((Object)this.dataObject)));
        this.updateName(abstractButton);
        abstractButton.addActionListener(this);
        HelpCtx.setHelpIDString((JComponent)abstractButton, (String)this.dataObject.getHelpCtx().getHelpID());
    }

    private void updateName(AbstractButton abstractButton) {
        String string = this.dataObject.getName();
        try {
            FileObject fileObject = this.dataObject.getPrimaryFile();
            FileSystem.Status status = fileObject.getFileSystem().getStatus();
            string = status.annotateName(string, this.dataObject.files());
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
        Mnemonics.setLocalizedText((AbstractButton)abstractButton, (String)string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Node.Cookie cookie = this.dataObject.getCookie(OpenCookie.class);
        if (cookie != null) {
            ((OpenCookie)cookie).open();
        }
    }

    private class NameChangeListener
    implements PropertyChangeListener {
        private final AbstractButton presenter;

        NameChangeListener(AbstractButton abstractButton) {
            this.presenter = abstractButton;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("name".equals(propertyChangeEvent.getPropertyName())) {
                URLPresenter.this.updateName(this.presenter);
            }
        }
    }
}

