/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.EventQueue;
import java.lang.ref.Reference;
import java.lang.reflect.Method;
import java.util.List;
import org.netbeans.modules.search.BasicSearchCriteria;
import org.netbeans.modules.search.SearchDisplayer;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.windows.OutputWriter;
import org.openidex.search.SearchType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PrintDetailsTask
implements Runnable {
    private static final int BUFFER_SIZE = 8;
    private final Object[] objects;
    private final BasicSearchCriteria basicSearchCriteria;
    private final List<SearchType> searchTypes;
    private final Node[] buffer = new Node[8];
    private int bufPos = 0;
    private SearchDisplayer displayer;
    private volatile boolean interrupted = false;

    PrintDetailsTask(Object[] objectArray, BasicSearchCriteria basicSearchCriteria, List<SearchType> list) {
        this.objects = objectArray;
        this.basicSearchCriteria = basicSearchCriteria;
        this.searchTypes = list;
    }

    @Override
    public void run() {
        this.displayer = new SearchDisplayer();
        this.callDisplayerFromAWT("prepareOutput");
        int n = 0;
        for (Object object : this.objects) {
            Object object2;
            Node[] nodeArray = null;
            if (this.basicSearchCriteria != null && (object2 = this.basicSearchCriteria.getDetails(object)) != null && ((Node[])object2).length != 0) {
                nodeArray = object2;
            }
            if (!this.searchTypes.isEmpty()) {
                object2 = this.searchTypes.iterator();
                while (object2.hasNext()) {
                    SearchType searchType = (SearchType)object2.next();
                    Node[] nodeArray2 = searchType.getDetails(object);
                    if (nodeArray2 == null || nodeArray2.length == 0) continue;
                    if (nodeArray == null) {
                        nodeArray = nodeArray2;
                        continue;
                    }
                    nodeArray = this.concatNodeArrays(nodeArray, nodeArray2);
                }
            }
            if (nodeArray == null) continue;
            n = this.addToBuffer(nodeArray, 0);
            while (n < 0) {
                this.printBuffer();
                int n2 = nodeArray.length + n;
                n = this.addToBuffer(nodeArray, n2);
            }
            if (n == 0) {
                this.printBuffer();
            }
            if (this.interrupted) break;
        }
        if (n != 0 && !this.interrupted) {
            int n3 = 8 - n;
            Node[] nodeArray = new Node[n3];
            System.arraycopy(this.buffer, 0, nodeArray, 0, n3);
            this.displayer.displayNodes(nodeArray);
        }
        this.callDisplayerFromAWT("finishDisplaying");
    }

    void stop() {
        this.interrupted = true;
    }

    Reference<OutputWriter> getOutputWriterRef() {
        return this.displayer.getOutputWriterRef();
    }

    private int addToBuffer(Node[] nodeArray, int n) {
        assert (n >= 0 && n <= nodeArray.length);
        int n2 = nodeArray.length - n;
        int n3 = this.bufPos + n2;
        int n4 = 8 - n3;
        if (n4 <= 0) {
            n2 += n4;
            n3 = 0;
        }
        System.arraycopy(nodeArray, n, this.buffer, this.bufPos, n2);
        this.bufPos = n3;
        return n4;
    }

    private void printBuffer() {
        this.displayer.displayNodes(this.buffer);
    }

    private Node[] concatNodeArrays(Node[] nodeArray, Node[] nodeArray2) {
        Node[] nodeArray3 = new Node[nodeArray.length + nodeArray2.length];
        System.arraycopy(nodeArray, 0, nodeArray3, 0, nodeArray.length);
        System.arraycopy(nodeArray2, 0, nodeArray3, nodeArray.length, nodeArray2.length);
        return nodeArray3;
    }

    private void callDisplayerFromAWT(String string) {
        try {
            final Method method = SearchDisplayer.class.getDeclaredMethod(string, new Class[0]);
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        method.invoke((Object)PrintDetailsTask.this.displayer, (Object[])null);
                    }
                    catch (Exception exception) {
                        ErrorManager.getDefault().notify((Throwable)exception);
                    }
                }
            };
            if (EventQueue.isDispatchThread()) {
                runnable.run();
            } else {
                EventQueue.invokeAndWait(runnable);
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
    }
}

