/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openfile;

import java.awt.Component;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.netbeans.modules.openfile.OpenFile;
import org.netbeans.modules.openfile.RecentFiles;
import org.openide.awt.DynamicMenuContent;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.Presenter;

public class RecentFileAction
extends AbstractAction
implements Presenter.Menu,
PopupMenuListener,
ChangeListener {
    private static final String FO_PROP = "RecentFileAction.Recent_FO";
    private static final int MAX_COUNT = 15;
    private JMenu menu;

    public RecentFileAction() {
        super(NbBundle.getMessage(RecentFileAction.class, (String)"LBL_RecentFileAction_Name"));
    }

    public JMenuItem getMenuPresenter() {
        if (this.menu == null) {
            this.menu = new UpdatingMenu(this);
            this.menu.setMnemonic(NbBundle.getMessage(RecentFileAction.class, (String)"MNE_RecentFileAction_Name").charAt(0));
            if (!Utilities.isMac()) {
                this.menu.getPopupMenu().addPopupMenuListener(this);
            } else {
                this.menu.addChangeListener(this);
            }
        }
        return this.menu;
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        this.fillSubMenu();
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        this.menu.removeAll();
    }

    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.menu.isSelected()) {
            this.popupMenuWillBecomeVisible(null);
        } else {
            this.popupMenuWillBecomeInvisible(null);
        }
    }

    private void fillSubMenu() {
        List<RecentFiles.HistoryItem> list = RecentFiles.getRecentFiles();
        int n = 0;
        for (RecentFiles.HistoryItem historyItem : list) {
            Object object;
            FileObject fileObject = RecentFiles.convertURL2File(historyItem.getURL());
            if (++n > 15) break;
            Image image = null;
            try {
                object = DataObject.find((FileObject)fileObject);
                image = object.getNodeDelegate().getIcon(1);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                Logger.getLogger(RecentFiles.class.getName()).log(Level.INFO, dataObjectNotFoundException.getMessage(), dataObjectNotFoundException);
                continue;
            }
            object = null;
            object = image != null ? new JMenuItem(fileObject.getNameExt(), new ImageIcon(image)) : new JMenuItem(fileObject.getNameExt());
            ((JComponent)object).putClientProperty(FO_PROP, fileObject);
            ((AbstractButton)object).addActionListener(this);
            this.menu.add((JMenuItem)object);
        }
        this.ensureSelected();
    }

    private void ensureSelected() {
        if (this.menu.getMenuComponentCount() <= 0) {
            return;
        }
        Component component = this.menu.getMenuComponent(0);
        if (!(component instanceof JMenuItem)) {
            return;
        }
        Point point = MouseInfo.getPointerInfo().getLocation();
        SwingUtilities.convertPointFromScreen(point, this.menu);
        MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
        if (!this.menu.contains(point) && menuElementArray.length > 0 && this.menu.getPopupMenu() == menuElementArray[menuElementArray.length - 1]) {
            MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length + 1];
            System.arraycopy(menuElementArray, 0, menuElementArray2, 0, menuElementArray.length);
            JMenuItem jMenuItem = (JMenuItem)component;
            menuElementArray2[menuElementArray.length] = jMenuItem;
            MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
        FileObject fileObject = (FileObject)jMenuItem.getClientProperty(FO_PROP);
        if (fileObject != null) {
            OpenFile.open(fileObject, -1);
        }
    }

    private class UpdatingMenu
    extends JMenu
    implements DynamicMenuContent {
        private final JComponent[] content;

        public UpdatingMenu(Action action) {
            super(action);
            this.content = new JComponent[]{this};
        }

        public JComponent[] getMenuPresenters() {
            this.setEnabled(!RecentFiles.getRecentFiles().isEmpty());
            return this.content;
        }

        public JComponent[] synchMenuPresenters(JComponent[] jComponentArray) {
            return this.getMenuPresenters();
        }
    }
}

