/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.Position;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.PopupManager;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.Completion;
import org.netbeans.editor.ext.CompletionJavaDoc;
import org.netbeans.editor.ext.CompletionQuery;
import org.netbeans.editor.ext.CompletionView;
import org.netbeans.editor.ext.ExtCompletionPane;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.JavaDocPane;
import org.netbeans.editor.ext.JavaDocView;

public class JDCPopupPanel
extends JPanel
implements PropertyChangeListener,
SettingsChangeListener {
    private ExtCompletionPane completion;
    private ExtEditorUI extEditorUI;
    private FocusListener focusL;
    private List keyActionPairsList;
    private JavaDocPane javadoc;
    private int lastSize = -1;
    private static final int WINDOW_GAP = 1;
    private static final String POPUP_HIDE = "jdc-popup-hide";
    private static final String COMPLETION_UP = "completion-up";
    private static final String COMPLETION_DOWN = "completion-down";
    private static final String COMPLETION_PGUP = "completion-pgup";
    private static final String COMPLETION_PGDN = "completion-pgdn";
    private static final String COMPLETION_BEGIN = "completion-begin";
    private static final String COMPLETION_END = "completion-end";
    private static final String JAVADOC_UP = "javadoc-up";
    private static final String JAVADOC_DOWN = "javadoc-down";
    private static final String JAVADOC_PGUP = "javadoc-pgup";
    private static final String JAVADOC_PGDN = "javadoc-pgdn";
    private static final String JAVADOC_BEGIN = "javadoc-begin";
    private static final String JAVADOC_END = "javadoc-end";
    private static final String JAVADOC_LEFT = "javadoc-left";
    private static final String JAVADOC_RIGHT = "javadoc-right";
    private static final String JAVADOC_BACK = "javadoc-back";
    private static final String JAVADOC_FORWARD = "javadoc-forward";
    private static final String JAVADOC_OPEN_IN_BROWSER = "javadoc-open-in-browser";
    private static final String JAVADOC_OPEN_SOURCE = "javadoc-open-source";
    public static final String COMPLETION_SUBSTITUTE_TEXT = "completion-substitute-text";
    public static final String COMPLETION_SUBSTITUTE_TEXT_SIMPLE = "completion-substitute-text-simple";
    private static final String COMPLETION_SUBSTITUTE_TEXT_KEEP_POPUP_OPEN = "completion-substitute-text-keep-popup-open";
    private static final String COMPLETION_SUBSTITUTE_COMMON_TEXT = "completion-substitutecommon-text";
    private static final int ACTION_POPUP_HIDE = 1;
    private static final int ACTION_COMPLETION_UP = 2;
    private static final int ACTION_COMPLETION_DOWN = 3;
    private static final int ACTION_COMPLETION_PGUP = 4;
    private static final int ACTION_COMPLETION_PGDN = 5;
    private static final int ACTION_COMPLETION_BEGIN = 6;
    private static final int ACTION_COMPLETION_END = 7;
    private static final int ACTION_JAVADOC_UP = 8;
    private static final int ACTION_JAVADOC_DOWN = 9;
    private static final int ACTION_JAVADOC_PGUP = 10;
    private static final int ACTION_JAVADOC_PGDN = 11;
    private static final int ACTION_JAVADOC_BEGIN = 12;
    private static final int ACTION_JAVADOC_END = 13;
    private static final int ACTION_JAVADOC_LEFT = 14;
    private static final int ACTION_JAVADOC_RIGHT = 15;
    private static final int ACTION_JAVADOC_BACK = 16;
    private static final int ACTION_JAVADOC_FORWARD = 17;
    private static final int ACTION_JAVADOC_OPEN_IN_BROWSER = 18;
    private static final int ACTION_JAVADOC_OPEN_SOURCE = 19;
    private static final int ACTION_COMPLETION_SUBSTITUTE_TEXT = 20;
    private static final int ACTION_COMPLETION_SUBSTITUTE_TEXT_SIMPLE = 21;
    private static final int ACTION_COMPLETION_SUBSTITUTE_TEXT_KEEP_POPUP_OPEN = 22;
    private static final int ACTION_COMPLETION_SUBSTITUTE_COMMON_TEXT = 23;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JDCPopupPanel(ExtEditorUI extEditorUI, ExtCompletionPane extCompletionPane, Completion completion) {
        this.completion = extCompletionPane;
        this.extEditorUI = extEditorUI;
        this.keyActionPairsList = new ArrayList();
        this.setLayout(null);
        this.setOpaque(false);
        this.focusL = new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JTextComponent jTextComponent;
                        if (JDCPopupPanel.this.isVisible() && (jTextComponent = JDCPopupPanel.this.extEditorUI.getComponent()) != null) {
                            boolean bl;
                            Component component;
                            Window window = SwingUtilities.windowForComponent(jTextComponent);
                            Component component2 = component = window == null ? null : window.getFocusOwner();
                            if (component == null) {
                                JDCPopupPanel.this.setVisible(false);
                            }
                            boolean bl2 = JDCPopupPanel.this.javadoc != null && component == JDCPopupPanel.this.getJavaDocView();
                            boolean bl3 = JDCPopupPanel.this.javadoc != null && JDCPopupPanel.this.getJavaDocPane().getComponent().isAncestorOf(component);
                            boolean bl4 = bl = component == JDCPopupPanel.this.getCompletionView();
                            if (bl2 || bl || bl3) {
                                jTextComponent.requestFocus();
                            } else if (component != jTextComponent) {
                                JDCPopupPanel.this.setVisible(false);
                            }
                        }
                    }
                });
            }
        };
        Object object = extEditorUI.getComponentLock();
        synchronized (object) {
            JTextComponent jTextComponent = extEditorUI.getComponent();
            if (jTextComponent != null) {
                this.propertyChange(new PropertyChangeEvent((Object)extEditorUI, "component", null, jTextComponent));
            }
            extEditorUI.addPropertyChangeListener(this);
        }
        super.setVisible(false);
        Settings.addSettingsChangeListener((SettingsChangeListener)this);
    }

    public ExtCompletionPane getCompletionPane() {
        return this.completion;
    }

    private void clearJavadocContent() {
        CompletionJavaDoc completionJavaDoc = this.extEditorUI.getCompletionJavaDoc();
        if (completionJavaDoc != null) {
            completionJavaDoc.clearContent();
        }
    }

    private JavaDocView getJavaDocView() {
        CompletionJavaDoc completionJavaDoc = this.extEditorUI.getCompletionJavaDoc();
        if (completionJavaDoc != null) {
            return completionJavaDoc.getJavaDocView();
        }
        return null;
    }

    private CompletionView getCompletionView() {
        Completion completion = this.extEditorUI.getCompletion();
        if (completion != null) {
            return completion.getView();
        }
        return null;
    }

    public JavaDocPane getJavaDocPane() {
        Completion completion;
        if (this.javadoc == null && (completion = this.extEditorUI.getCompletion()) != null) {
            this.javadoc = completion.getJavaDocPane();
        }
        return this.javadoc;
    }

    public Dimension getMinimumSize() {
        return this.completion.getComponent().getMinimumSize();
    }

    public Dimension getMaximumSize() {
        Dimension dimension = this.completion.getComponent().getMaximumSize();
        Dimension dimension2 = new Dimension();
        if (this.javadoc != null) {
            dimension2 = this.javadoc.getComponent().getMaximumSize();
        }
        return new Dimension(Math.max(dimension.width, dimension2.width), dimension.height + dimension2.height);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension();
        Dimension dimension2 = this.completion.getComponent().getPreferredSize();
        Dimension dimension3 = this.completion.getComponent().getMaximumSize();
        Dimension dimension4 = new Dimension();
        Dimension dimension5 = new Dimension();
        if (this.javadoc != null) {
            dimension4 = this.javadoc.getComponent().getPreferredSize();
            dimension5 = this.javadoc.getComponent().getMaximumSize();
        }
        dimension.width = Math.min(dimension2.width, dimension3.width) + Math.min(dimension4.width, dimension5.width);
        dimension.height = Math.min(dimension2.height, dimension3.height) + Math.min(dimension4.height, dimension5.height);
        return dimension;
    }

    public void setCompletionVisible(boolean bl) {
        this.completion.setVisible(bl);
        this.setVisible(bl);
    }

    public void setJavaDocVisible(boolean bl) {
        this.getJavaDocPane().getComponent().setVisible(bl);
        if (bl || !this.getCompletionPane().isVisible()) {
            this.setVisible(bl);
        }
    }

    public void setVisible(boolean bl) {
        if (bl) {
            if (Utilities.getLastActiveComponent() != this.extEditorUI.getComponent()) {
                return;
            }
            boolean bl2 = this.javadoc != null && this.javadoc.getComponent().isVisible();
            Completion completion = this.extEditorUI.getCompletion();
            if (completion != null) {
                int n;
                CompletionQuery.Result result = completion.getLastResult();
                int n2 = n = result == null ? -1 : result.getData().size();
                if (this.lastSize != n || !this.isVisible() || bl2) {
                    this.extEditorUI.getPopupManager().install((JComponent)this);
                    this.lastSize = n;
                }
            }
            if (bl2 || this.completion.isVisible()) {
                super.setVisible(bl);
            }
        } else {
            this.lastSize = -1;
            this.clearJavadocContent();
            Completion completion = this.extEditorUI.getCompletion();
            if (completion != null) {
                completion.completionCancel();
            }
            if (this.javadoc != null) {
                this.javadoc.getComponent().setVisible(bl);
            }
            this.completion.getComponent().setVisible(bl);
            super.setVisible(bl);
            PopupManager popupManager = this.extEditorUI.getPopupManager();
            if (popupManager != null) {
                popupManager.uninstall((JComponent)this);
            }
        }
    }

    public void setSize(int n, int n2) {
        boolean bl;
        CompletionJavaDoc completionJavaDoc;
        PopupManager.Placement placement = (PopupManager.Placement)this.getClientProperty(PopupManager.Placement.class);
        Dimension dimension = this.completion.getComponent().getMinimumSize();
        if (dimension.height > n2) {
            this.putClientProperty(PopupManager.Placement.class, null);
        }
        this.completion.getComponent().setSize(n, n2);
        Dimension dimension2 = new Dimension();
        if (this.javadoc != null) {
            dimension2 = this.javadoc.getComponent().getMinimumSize();
        }
        Dimension dimension3 = this.completion.getComponent().getMaximumSize();
        Rectangle rectangle = new Rectangle(this.completion.getComponent().getSize());
        Rectangle rectangle2 = new Rectangle();
        if (this.javadoc != null) {
            rectangle2 = new Rectangle(this.javadoc.getComponent().getMaximumSize());
        }
        boolean bl2 = true;
        if (this.javadoc == null || !this.javadoc.getComponent().isVisible()) {
            bl2 = false;
        }
        if ((completionJavaDoc = this.extEditorUI.getCompletionJavaDoc()) != null && completionJavaDoc.autoPopup()) {
            boolean bl3 = bl2 = this.javadoc != null;
        }
        if (!(bl = this.getCompletionPane().isVisible())) {
            dimension.height = 0;
            dimension.width = 0;
            rectangle = new Rectangle();
        } else {
            rectangle.width = Math.min(dimension3.width, rectangle.width);
            rectangle.height = Math.min(dimension3.height, rectangle.height);
        }
        if (dimension2.height + dimension.height > n2) {
            bl2 = false;
        }
        if (bl2) {
            if (rectangle.height + rectangle2.height > n2) {
                rectangle.height = Math.max(Math.min(n2 / 2, rectangle.height), dimension.height);
                rectangle.height = Math.min(130, rectangle.height);
                rectangle2.height = Math.min(n2 - rectangle.height - 1, rectangle2.height);
            }
            if (placement == PopupManager.Below) {
                rectangle.y = 0;
                rectangle2.y = rectangle.height + 1;
            } else {
                rectangle.y = rectangle2.height + 1;
                rectangle2.y = 0;
            }
        }
        if (n < dimension2.width) {
            bl2 = false;
        } else {
            rectangle2.width = Math.min(n, rectangle2.width);
            JTextComponent jTextComponent = this.extEditorUI.getComponent();
            Rectangle rectangle3 = this.extEditorUI.getExtentBounds();
            Rectangle rectangle4 = new Rectangle();
            try {
                rectangle4 = jTextComponent.getUI().modelToView(jTextComponent, jTextComponent.getCaret().getDot(), Position.Bias.Forward);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            rectangle.x = n - rectangle2.width < rectangle4.x - rectangle3.x ? (rectangle4.x - rectangle3.x + rectangle.width < n ? rectangle4.x - rectangle3.x - n + rectangle2.width : rectangle2.width - rectangle.width) : 0;
        }
        this.completion.setVisible(false);
        boolean bl4 = this.getJavaDocPane().getComponent().isVisible();
        if (bl4 && !bl2) {
            this.getJavaDocPane().getComponent().setVisible(false);
        }
        this.remove(this.completion.getComponent());
        if (this.javadoc != null) {
            this.remove(this.javadoc.getComponent());
        }
        if (bl2) {
            if (bl) {
                this.completion.getComponent().setBounds(rectangle);
                this.getJavaDocPane().getComponent().setBounds(rectangle2);
                super.setBounds(0, 0, Math.max(rectangle.width, rectangle2.width), rectangle.height + rectangle2.height + 1);
                this.add(this.completion.getComponent());
                this.add(this.getJavaDocPane().getComponent());
                this.completion.setVisible(true);
                if (bl4) {
                    this.getJavaDocPane().getComponent().setVisible(true);
                }
            } else {
                rectangle2.x = 0;
                rectangle2.y = 0;
                this.getJavaDocPane().getComponent().setBounds(rectangle2);
                super.setBounds(0, 0, rectangle2.width, rectangle2.height);
                this.add(this.getJavaDocPane().getComponent());
                if (bl4) {
                    this.getJavaDocPane().getComponent().setVisible(true);
                }
            }
        } else {
            rectangle.x = 0;
            rectangle.y = 0;
            this.completion.getComponent().setBounds(rectangle);
            super.setBounds(0, 0, rectangle.width, rectangle.height + 1);
            this.add(this.completion.getComponent());
            this.completion.setVisible(true);
        }
    }

    public void setSize(Dimension dimension) {
        this.setSize(dimension.width, dimension.height);
    }

    public void refresh() {
        this.setVisible(true);
    }

    private void performJavaDocAction(KeyStroke keyStroke) {
        ActionListener actionListener = this.getJavaDocPane().getJavadocDisplayComponent().getActionForKeyStroke(keyStroke);
        if (actionListener != null) {
            actionListener.actionPerformed(new ActionEvent(this.getJavaDocPane().getJavadocDisplayComponent(), 1001, ""));
            this.getJavaDocPane().getJavadocDisplayComponent().repaint();
        }
    }

    private KeyStroke[] findEditorKeys(String string, KeyStroke keyStroke) {
        JTextComponent jTextComponent;
        KeyStroke[] keyStrokeArray = new KeyStroke[]{keyStroke};
        if (string != null && this.extEditorUI != null && (jTextComponent = this.extEditorUI.getComponent()) != null) {
            KeyStroke[] keyStrokeArray2;
            Action action;
            EditorKit editorKit;
            TextUI textUI = jTextComponent.getUI();
            Keymap keymap = jTextComponent.getKeymap();
            if (textUI != null && keymap != null && (editorKit = textUI.getEditorKit(jTextComponent)) instanceof BaseKit && (action = ((BaseKit)editorKit).getActionByName(string)) != null && (keyStrokeArray2 = keymap.getKeyStrokesForAction(action)) != null && keyStrokeArray2.length > 0) {
                keyStrokeArray = keyStrokeArray2;
            }
        }
        return keyStrokeArray;
    }

    private void registerKeybinding(int n, String string, KeyStroke keyStroke, String string2) {
        KeyStroke[] keyStrokeArray = this.findEditorKeys(string2, keyStroke);
        for (int i = 0; i < keyStrokeArray.length; ++i) {
            this.getInputMap().put(keyStrokeArray[i], string);
            this.keyActionPairsList.add(string);
            this.keyActionPairsList.add(keyStrokeArray[i]);
        }
        this.getActionMap().put(string, new JDCPopupAction(n));
    }

    private void unregisterKeybinding(String string, KeyStroke keyStroke) {
        this.getInputMap().remove(keyStroke);
        this.getActionMap().remove(string);
    }

    private void installKeybindings() {
        this.registerKeybinding(1, POPUP_HIDE, KeyStroke.getKeyStroke(27, 0), "escape");
        this.registerKeybinding(2, COMPLETION_UP, KeyStroke.getKeyStroke(38, 0), "caret-up");
        this.registerKeybinding(3, COMPLETION_DOWN, KeyStroke.getKeyStroke(40, 0), "caret-down");
        this.registerKeybinding(5, COMPLETION_PGDN, KeyStroke.getKeyStroke(34, 0), "page-down");
        this.registerKeybinding(4, COMPLETION_PGUP, KeyStroke.getKeyStroke(33, 0), "page-up");
        this.registerKeybinding(6, COMPLETION_BEGIN, KeyStroke.getKeyStroke(36, 0), "caret-begin-line");
        this.registerKeybinding(7, COMPLETION_END, KeyStroke.getKeyStroke(35, 0), "caret-end-line");
        this.registerKeybinding(8, JAVADOC_UP, KeyStroke.getKeyStroke(38, 1), null);
        this.registerKeybinding(9, JAVADOC_DOWN, KeyStroke.getKeyStroke(40, 1), null);
        this.registerKeybinding(11, JAVADOC_PGDN, KeyStroke.getKeyStroke(34, 1), null);
        this.registerKeybinding(10, JAVADOC_PGUP, KeyStroke.getKeyStroke(33, 1), null);
        this.registerKeybinding(12, JAVADOC_BEGIN, KeyStroke.getKeyStroke(36, 1), null);
        this.registerKeybinding(13, JAVADOC_END, KeyStroke.getKeyStroke(35, 1), null);
        this.registerKeybinding(14, JAVADOC_LEFT, KeyStroke.getKeyStroke(37, 1), null);
        this.registerKeybinding(15, JAVADOC_RIGHT, KeyStroke.getKeyStroke(39, 1), null);
        this.registerKeybinding(16, JAVADOC_BACK, KeyStroke.getKeyStroke(37, 8), null);
        this.registerKeybinding(17, JAVADOC_FORWARD, KeyStroke.getKeyStroke(39, 8), null);
        this.registerKeybinding(18, JAVADOC_OPEN_IN_BROWSER, KeyStroke.getKeyStroke(112, 9), null);
        this.registerKeybinding(19, JAVADOC_OPEN_SOURCE, KeyStroke.getKeyStroke(79, 10), null);
        this.registerKeybinding(20, COMPLETION_SUBSTITUTE_TEXT, KeyStroke.getKeyStroke(10, 0), null);
        this.registerKeybinding(21, COMPLETION_SUBSTITUTE_TEXT_SIMPLE, KeyStroke.getKeyStroke(10, 2), null);
        this.registerKeybinding(22, COMPLETION_SUBSTITUTE_TEXT_KEEP_POPUP_OPEN, KeyStroke.getKeyStroke(10, 1), null);
        this.registerKeybinding(23, COMPLETION_SUBSTITUTE_COMMON_TEXT, KeyStroke.getKeyStroke(9, 0), null);
    }

    private void uninstallKeybindings() {
        Iterator iterator = this.keyActionPairsList.iterator();
        while (iterator.hasNext()) {
            this.unregisterKeybinding((String)iterator.next(), (KeyStroke)iterator.next());
        }
        this.keyActionPairsList.clear();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("component".equals(string)) {
            if (propertyChangeEvent.getNewValue() != null) {
                JTextComponent jTextComponent = this.extEditorUI.getComponent();
                this.installKeybindings();
                jTextComponent.addFocusListener(this.focusL);
            } else {
                JTextComponent jTextComponent = (JTextComponent)propertyChangeEvent.getOldValue();
                this.uninstallKeybindings();
                jTextComponent.removeFocusListener(this.focusL);
            }
        }
    }

    public void settingsChange(SettingsChangeEvent settingsChangeEvent) {
        this.uninstallKeybindings();
        this.installKeybindings();
    }

    private class JDCPopupAction
    extends AbstractAction {
        private int action;

        private JDCPopupAction(int n) {
            this.action = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            switch (this.action) {
                case 1: {
                    JDCPopupPanel.this.setVisible(false);
                    break;
                }
                case 2: {
                    if (JDCPopupPanel.this.completion.isVisible()) {
                        JDCPopupPanel.this.getCompletionView().up();
                        break;
                    }
                    JDCPopupPanel.this.performJavaDocAction(KeyStroke.getKeyStroke(38, 0));
                    break;
                }
                case 3: {
                    if (JDCPopupPanel.this.completion.isVisible()) {
                        JDCPopupPanel.this.getCompletionView().down();
                        break;
                    }
                    JDCPopupPanel.this.performJavaDocAction(KeyStroke.getKeyStroke(40, 0));
                    break;
                }
                case 4: {
                    if (JDCPopupPanel.this.completion.isVisible()) {
                        JDCPopupPanel.this.getCompletionView().pageUp();
                        break;
                    }
                    JDCPopupPanel.this.performJavaDocAction(KeyStroke.getKeyStroke(33, 0));
                    break;
                }
                case 5: {
                    if (JDCPopupPanel.this.completion.isVisible()) {
                        JDCPopupPanel.this.getCompletionView().pageDown();
                        break;
                    }
                    JDCPopupPanel.this.performJavaDocAction(KeyStroke.getKeyStroke(34, 0));
                    break;
                }
                case 6: {
                    if (JDCPopupPanel.this.completion.isVisible()) {
                        JDCPopupPanel.this.getCompletionView().begin();
                        break;
                    }
                    JDCPopupPanel.this.performJavaDocAction(KeyStroke.getKeyStroke(36, 0));
                    break;
                }
                case 7: {
                    if (JDCPopupPanel.this.completion.isVisible()) {
                        JDCPopupPanel.this.getCompletionView().end();
                        break;
                    }
                    JDCPopupPanel.this.performJavaDocAction(KeyStroke.getKeyStroke(35, 0));
                    break;
                }
                case 8: {
                    JDCPopupPanel.this.performJavaDocAction(KeyStroke.getKeyStroke(38, 0));
                    break;
                }
                case 9: {
                    JDCPopupPanel.this.performJavaDocAction(KeyStroke.getKeyStroke(40, 0));
                    break;
                }
                case 10: {
                    JDCPopupPanel.this.performJavaDocAction(KeyStroke.getKeyStroke(33, 0));
                    break;
                }
                case 11: {
                    JDCPopupPanel.this.performJavaDocAction(KeyStroke.getKeyStroke(34, 0));
                    break;
                }
                case 12: {
                    JDCPopupPanel.this.performJavaDocAction(KeyStroke.getKeyStroke(36, 0));
                    break;
                }
                case 13: {
                    JDCPopupPanel.this.performJavaDocAction(KeyStroke.getKeyStroke(35, 0));
                    break;
                }
                case 14: {
                    JDCPopupPanel.this.performJavaDocAction(KeyStroke.getKeyStroke(37, 0));
                    break;
                }
                case 15: {
                    JDCPopupPanel.this.performJavaDocAction(KeyStroke.getKeyStroke(39, 0));
                    break;
                }
                case 16: {
                    CompletionJavaDoc completionJavaDoc = JDCPopupPanel.this.extEditorUI.getCompletionJavaDoc();
                    if (completionJavaDoc == null) break;
                    completionJavaDoc.backHistory();
                    break;
                }
                case 17: {
                    CompletionJavaDoc completionJavaDoc = JDCPopupPanel.this.extEditorUI.getCompletionJavaDoc();
                    if (completionJavaDoc == null) break;
                    completionJavaDoc.forwardHistory();
                    break;
                }
                case 18: {
                    CompletionJavaDoc completionJavaDoc = JDCPopupPanel.this.extEditorUI.getCompletionJavaDoc();
                    if (completionJavaDoc == null || !completionJavaDoc.isExternalJavaDocMounted()) break;
                    completionJavaDoc.openInExternalBrowser();
                    break;
                }
                case 19: {
                    CompletionJavaDoc completionJavaDoc = JDCPopupPanel.this.extEditorUI.getCompletionJavaDoc();
                    if (completionJavaDoc == null) break;
                    completionJavaDoc.goToSource();
                    break;
                }
                case 20: {
                    Completion completion = JDCPopupPanel.this.extEditorUI.getCompletion();
                    if (completion == null || !completion.isPaneVisible()) break;
                    if (completion.substituteText(false)) {
                        completion.setPaneVisible(false);
                        break;
                    }
                    completion.refresh(false);
                    break;
                }
                case 21: {
                    Completion completion = JDCPopupPanel.this.extEditorUI.getCompletion();
                    if (completion == null || !completion.isPaneVisible()) break;
                    if (completion.substituteSimpleText()) {
                        completion.setPaneVisible(false);
                        break;
                    }
                    completion.refresh(false);
                    break;
                }
                case 22: {
                    Completion completion = JDCPopupPanel.this.extEditorUI.getCompletion();
                    if (completion == null || !completion.isPaneVisible() || completion.substituteText(true)) break;
                    completion.refresh(false);
                    break;
                }
                case 23: {
                    Completion completion = JDCPopupPanel.this.extEditorUI.getCompletion();
                    if (completion == null || !completion.isPaneVisible()) break;
                    completion.refresh(false);
                    completion.substituteCommonText();
                }
            }
        }
    }
}

