/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lexer.editorbridge;

import java.awt.event.ActionEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.KeyStroke;
import javax.swing.plaf.TextUI;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.KeyBindingSettings;
import org.netbeans.api.editor.settings.MultiKeyBinding;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.MultiKeymap;
import org.netbeans.editor.Settings;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.editor.ext.plain.PlainSyntax;
import org.netbeans.modules.editor.NbEditorKit;
import org.netbeans.modules.lexer.editorbridge.LexerLayer;
import org.openide.filesystems.FileObject;

public class LexerEditorKit
extends NbEditorKit {
    public static final String tokenListDebugAction = "token-list-debug";
    public static final String UNKNOWN_MIME_TYPE = "text/x-unknown";
    private String mimeType;

    public static LexerEditorKit create(FileObject fileObject) {
        String string = UNKNOWN_MIME_TYPE;
        String string2 = (fileObject = fileObject.getParent()).getPath();
        if (string2.startsWith("Editors/")) {
            string = string2.substring("Editors/".length());
        }
        return new LexerEditorKit(string);
    }

    public LexerEditorKit(String string) {
        this.mimeType = string;
    }

    public LexerEditorKit() {
    }

    public String getContentType() {
        return this.mimeType;
    }

    public void install(JEditorPane jEditorPane) {
        super.install(jEditorPane);
        TextUI textUI = jEditorPane.getUI();
        if (textUI instanceof BaseTextUI) {
            ((BaseTextUI)textUI).getEditorUI().addLayer((DrawLayer)new LexerLayer(jEditorPane), 1050);
        }
    }

    public Syntax createSyntax(Document document) {
        return new PlainSyntax();
    }

    public SyntaxSupport createSyntaxSupport(BaseDocument baseDocument) {
        return new ExtSyntaxSupport(baseDocument);
    }

    protected Action[] createActions() {
        Action[] actionArray = new Action[]{new TokenListDebugAction()};
        return TextAction.augmentList(super.createActions(), actionArray);
    }

    protected String updateColoringName(String string) {
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiKeymap getKeymap() {
        JTextComponent.KeyBinding[] keyBindingArray;
        Object object;
        KeyBindingSettings keyBindingSettings;
        List list;
        MultiKeymap multiKeymap = new MultiKeymap("Keymap for " + this.mimeType);
        Map map = this.getActionMapHack();
        KeyBindingSettings keyBindingSettings2 = (KeyBindingSettings)MimeLookup.getMimeLookup((String)this.mimeType).lookup(KeyBindingSettings.class);
        if (keyBindingSettings2 != null) {
            list = keyBindingSettings2.getKeyBindings();
            keyBindingSettings = this.transform(list);
            multiKeymap.load((JTextComponent.KeyBinding[])keyBindingSettings, map);
        }
        if ((list = (KeyBindingSettings)MimeLookup.getMimeLookup((String)"text/base").lookup(KeyBindingSettings.class)) != null) {
            keyBindingSettings = list.getKeyBindings();
            object = this.transform((List)keyBindingSettings);
            multiKeymap.load(object, map);
        }
        if ((keyBindingSettings = (KeyBindingSettings)MimeLookup.getMimeLookup((String)"").lookup(KeyBindingSettings.class)) != null) {
            object = keyBindingSettings.getKeyBindings();
            keyBindingArray = this.transform((List)object);
            multiKeymap.load(keyBindingArray, map);
        }
        object = Settings.class;
        synchronized (Settings.class) {
            keyBindingArray = Settings.getValueHierarchy(((Object)((Object)this)).getClass(), (String)"key-bindings");
            for (int i = keyBindingArray.length - 1; i >= 0; --i) {
                List list2 = (List)((Settings.KitAndValue)keyBindingArray[i]).value;
                JTextComponent.KeyBinding[] keyBindingArray2 = new JTextComponent.KeyBinding[list2.size()];
                list2.toArray(keyBindingArray2);
                multiKeymap.load(keyBindingArray2, map);
            }
            // ** MonitorExit[var6_6 /* !! */ ] (shouldn't be in output)
            multiKeymap.setDefaultAction((Action)map.get("default-typed"));
            return multiKeymap;
        }
    }

    private JTextComponent.KeyBinding[] transform(List list) {
        ArrayList<org.netbeans.editor.MultiKeyBinding> arrayList = new ArrayList<org.netbeans.editor.MultiKeyBinding>(list.size());
        for (MultiKeyBinding multiKeyBinding : list) {
            org.netbeans.editor.MultiKeyBinding multiKeyBinding2;
            if (0 == multiKeyBinding.getKeyStrokeCount()) continue;
            if (1 == multiKeyBinding.getKeyStrokeCount()) {
                multiKeyBinding2 = new org.netbeans.editor.MultiKeyBinding(multiKeyBinding.getKeyStroke(0), multiKeyBinding.getActionName());
            } else {
                KeyStroke[] keyStrokeArray = multiKeyBinding.getKeyStrokeList().toArray(new KeyStroke[multiKeyBinding.getKeyStrokeList().size()]);
                multiKeyBinding2 = new org.netbeans.editor.MultiKeyBinding(keyStrokeArray, multiKeyBinding.getActionName());
            }
            arrayList.add(multiKeyBinding2);
        }
        return arrayList.toArray(new JTextComponent.KeyBinding[arrayList.size()]);
    }

    private Map getActionMapHack() {
        try {
            Method method = BaseKit.class.getDeclaredMethod("getActionMap", new Class[0]);
            method.setAccessible(true);
            return (Map)method.invoke((Object)this, new Object[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    static class TokenListDebugAction
    extends BaseAction {
        public TokenListDebugAction() {
            super(LexerEditorKit.tokenListDebugAction, 0);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)jTextComponent.getDocument());
            if (tokenHierarchy != null) {
                System.err.println("Token list:\n" + tokenHierarchy.tokenSequence());
            } else {
                System.err.println("Token hierarchy is null.");
            }
        }
    }
}

