/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeListener;
import org.netbeans.api.server.ServerInstance;
import org.netbeans.modules.glassfish.common.CommonServerSupport;
import org.netbeans.modules.glassfish.common.GlassfishInstanceProvider;
import org.netbeans.modules.glassfish.common.LogViewMgr;
import org.netbeans.modules.glassfish.common.nodes.Hk2InstanceNode;
import org.netbeans.modules.glassfish.common.ui.InstanceCustomizer;
import org.netbeans.modules.glassfish.spi.CustomizerCookie;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.spi.GlassfishModuleFactory;
import org.netbeans.modules.glassfish.spi.RemoveCookie;
import org.netbeans.spi.server.ServerInstanceFactory;
import org.netbeans.spi.server.ServerInstanceImplementation;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;
import org.openide.windows.InputOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlassfishInstance
implements ServerInstanceImplementation {
    public static final String GLASSFISH_SERVER_NAME = "GlassFish V3 Prelude";
    public static final String DEFAULT_HOST_NAME = "localhost";
    public static final String DEFAULT_ADMIN_NAME = "admin";
    public static final String DEFAULT_ADMIN_PASSWORD = "adminadmin";
    public static final int DEFAULT_HTTP_PORT = 8080;
    public static final int DEFAULT_HTTPS_PORT = 8181;
    public static final int DEFAULT_ADMIN_PORT = 4848;
    public static final String DEFAULT_DOMAINS_FOLDER = "domains";
    public static final String DEFAULT_DOMAIN_NAME = "domain1";
    private boolean removable = true;
    private transient CommonServerSupport commonSupport;
    private transient InstanceContent ic = new InstanceContent();
    private transient Lookup lookup = new AbstractLookup((AbstractLookup.Content)this.ic);
    private ServerInstance commonInstance;

    private GlassfishInstance(Map<String, String> map) {
        this.ic.add((Object)this);
        this.commonSupport = new CommonServerSupport(this.lookup, map);
        this.ic.add((Object)this.commonSupport);
        this.updateModuleSupport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateModuleSupport() {
        Properties properties = new Properties();
        String string = this.commonSupport.getGlassfishRoot();
        File file = new File(string, "config/asenv.conf");
        if (file.exists()) {
            Object object = null;
            try {
                object = new BufferedInputStream(new FileInputStream(file));
                properties.load((InputStream)object);
            }
            catch (FileNotFoundException fileNotFoundException) {
                Logger.getLogger("glassfish").log(Level.WARNING, null, fileNotFoundException);
            }
            catch (IOException iOException) {
                Logger.getLogger("glassfish").log(Level.WARNING, null, iOException);
                properties = new Properties();
            }
            finally {
                if (object != null) {
                    try {
                        ((InputStream)object).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        } else {
            Logger.getLogger("glassfish").log(Level.WARNING, file.getAbsolutePath() + " does not exist");
        }
        for (GlassfishModuleFactory glassfishModuleFactory : Lookups.forPath((String)"Servers/GlassFish").lookupAll(GlassfishModuleFactory.class)) {
            if (!glassfishModuleFactory.isModuleSupported(string, properties)) continue;
            this.ic.add(glassfishModuleFactory.createModule(this.lookup));
        }
    }

    public static GlassfishInstance create(String string, String string2, String string3, String string4, String string5, int n, int n2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("displayName", string);
        hashMap.put("installfolder", string2);
        hashMap.put("homefolder", string3);
        hashMap.put("domainsfolder", string4);
        hashMap.put("domainname", string5);
        hashMap.put("httpportnumber", Integer.toString(n));
        hashMap.put("adminPort", Integer.toString(n2));
        GlassfishInstance glassfishInstance = new GlassfishInstance(hashMap);
        glassfishInstance.commonInstance = ServerInstanceFactory.createServerInstance((ServerInstanceImplementation)glassfishInstance);
        return glassfishInstance;
    }

    public static GlassfishInstance create(Map<String, String> map) {
        GlassfishInstance glassfishInstance = new GlassfishInstance(map);
        glassfishInstance.commonInstance = ServerInstanceFactory.createServerInstance((ServerInstanceImplementation)glassfishInstance);
        return glassfishInstance;
    }

    public ServerInstance getCommonInstance() {
        return this.commonInstance;
    }

    public CommonServerSupport getCommonSupport() {
        return this.commonSupport;
    }

    public String getDeployerUri() {
        return this.commonSupport.getDeployerUri();
    }

    public String getInstallRoot() {
        return this.commonSupport.getInstallRoot();
    }

    public String getGlassfishRoot() {
        return this.commonSupport.getGlassfishRoot();
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.commonSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.commonSupport.removeChangeListener(changeListener);
    }

    public GlassfishModule.ServerState getServerState() {
        return this.commonSupport.getServerState();
    }

    void stopIfStartedByIde(long l) {
        GlassfishModule.ServerState serverState;
        if (this.commonSupport.isStartedByIde() && ((serverState = this.commonSupport.getServerState()) == GlassfishModule.ServerState.STARTING || serverState == GlassfishModule.ServerState.RUNNING && this.commonSupport.isReallyRunning())) {
            try {
                GlassfishModule.OperationState operationState;
                Future<GlassfishModule.OperationState> future = this.commonSupport.stopServer(null);
                if (l > 0L && (operationState = future.get(l, TimeUnit.MILLISECONDS)) != GlassfishModule.OperationState.COMPLETED) {
                    Logger.getLogger("glassfish").info("Stop server failed...");
                }
            }
            catch (TimeoutException timeoutException) {
                Logger.getLogger("glassfish").fine("Server " + this.getDeployerUri() + " timed out sending stop-domain command.");
            }
            catch (Exception exception) {
                Logger.getLogger("glassfish").log(Level.INFO, exception.getLocalizedMessage(), exception);
            }
        }
    }

    public String getDisplayName() {
        return this.commonSupport.getDisplayName();
    }

    public String getServerDisplayName() {
        return GLASSFISH_SERVER_NAME;
    }

    public Node getFullNode() {
        Logger.getLogger("glassfish").finer("Creating GF Instance node [FULL]");
        return new Hk2InstanceNode(this, true);
    }

    public Node getBasicNode() {
        Logger.getLogger("glassfish").finer("Creating GF Instance node [BASIC]");
        return new Hk2InstanceNode(this, false);
    }

    public JComponent getCustomizer() {
        InstanceCustomizer instanceCustomizer = new InstanceCustomizer(this.commonSupport);
        LinkedList<JPanel> linkedList = new LinkedList<JPanel>();
        Collection collection = this.lookup.lookupAll(CustomizerCookie.class);
        for (Object object : collection) {
            linkedList.addAll(object.getCustomizerPages());
        }
        Object object = null;
        for (JPanel jPanel : linkedList) {
            if (object == null) {
                object = new JTabbedPane();
                ((JTabbedPane)object).add(instanceCustomizer);
            }
            ((JTabbedPane)object).add(jPanel);
        }
        return object != null ? object : instanceCustomizer;
    }

    public boolean isRemovable() {
        return this.removable;
    }

    public void remove() {
        if (!this.removable) {
            return;
        }
        this.stopIfStartedByIde(3000L);
        String string = this.commonSupport.getDeployerUri();
        InputOutput inputOutput = LogViewMgr.getServerIO(string);
        if (inputOutput != null && !inputOutput.isClosed()) {
            inputOutput.closeInputOutput();
        }
        Collection collection = this.lookup.lookupAll(RemoveCookie.class);
        for (RemoveCookie removeCookie : collection) {
            removeCookie.removeInstance(this.getDeployerUri());
        }
        GlassfishInstanceProvider.getDefault().removeServerInstance(this);
    }
}

