/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.highlighting;

import java.util.Collection;
import org.netbeans.lib.editor.util.GapList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOffsetGapList<E>
extends GapList<E> {
    private int offsetGapStart;
    private int offsetGapLength = 0x3FFFFFFF;
    private final boolean fixedZeroOffset;

    public AbstractOffsetGapList() {
        this(false);
    }

    public AbstractOffsetGapList(boolean bl) {
        this.fixedZeroOffset = bl;
    }

    public final boolean add(E e) {
        int n = this.attachElement(e);
        this.setElementRawOffset(e, this.offset2raw(n));
        int n2 = this.findOffsetIndex(n);
        super.add(n2, e);
        return true;
    }

    public final void add(int n, E e) {
        if (n < 0 || n > this.size()) {
            throw new IndexOutOfBoundsException("index = " + n + " size = " + this.size());
        }
        int n2 = this.attachElement(e);
        this.setElementRawOffset(e, this.offset2raw(n2));
        boolean bl = true;
        if (n > 0 && this.elementOffset(n - 1) > n2) {
            System.out.println("[" + (n - 1) + "] = " + this.elementOffset(n - 1) + " > {" + n + "} = " + n2);
            bl = false;
        }
        if (n < this.size() && this.elementOffset(n) < n2) {
            System.out.println("[" + n + "] = " + this.elementOffset(n) + " < {" + n + "} = " + n2);
            bl = false;
        }
        if (!bl) {
            this.detachElement(e);
            throw new IllegalStateException("Can't insert element at index: " + n);
        }
        super.add(n, e);
    }

    public final boolean addAll(Collection<? extends E> collection) {
        for (E e : collection) {
            this.add(e);
        }
        return true;
    }

    public final boolean addAll(int n, Collection<? extends E> collection) {
        throw new UnsupportedOperationException("This is an illegal operation on OffsetGapList.");
    }

    public final boolean addArray(int n, Object[] objectArray) {
        throw new UnsupportedOperationException("This is an illegal operation on OffsetGapList.");
    }

    public final boolean addArray(int n, Object[] objectArray, int n2, int n3) {
        throw new UnsupportedOperationException("This is an illegal operation on OffsetGapList.");
    }

    public final int indexOf(Object object) {
        int n;
        int n2;
        E e = this.getAttachedElement(object);
        if (e != null && (n2 = this.findElementIndex(n = this.elementOffset(e))) >= 0) {
            for (int i = n2; i < this.size() && this.elementOffset(i) == n; ++i) {
                if (e != this.get(i)) continue;
                return i;
            }
        }
        return -1;
    }

    public final int lastIndexOf(Object object) {
        return this.indexOf(object);
    }

    public final E set(int n, E e) {
        if (n < 0 || n >= this.size()) {
            throw new IndexOutOfBoundsException("index = " + n + " size = " + this.size());
        }
        int n2 = this.attachElement(e);
        this.setElementRawOffset(e, this.offset2raw(n2));
        boolean bl = true;
        if (n > 0 && this.elementOffset(n - 1) > n2) {
            System.out.println("[" + (n - 1) + "] = " + this.elementOffset(n - 1) + " > {" + n + "} = " + n2);
            bl = false;
        }
        if (n + 1 < this.size() && this.elementOffset(n + 1) < n2) {
            System.out.println("[" + (n + 1) + "] = " + this.elementOffset(n + 1) + " < {" + n + "} = " + n2);
            bl = false;
        }
        if (bl) {
            Object object = super.set(n, e);
            this.detachElement(object);
            return (E)object;
        }
        this.detachElement(e);
        throw new IllegalStateException("Can't insert element at index: " + n);
    }

    public final void swap(int n, int n2) {
        throw new UnsupportedOperationException("This is an illegal operation on OffsetGapList.");
    }

    protected abstract int elementRawOffset(E var1);

    protected abstract void setElementRawOffset(E var1, int var2);

    protected abstract int attachElement(E var1);

    protected abstract void detachElement(E var1);

    protected abstract E getAttachedElement(Object var1);

    protected int elementOffset(E e) {
        return this.raw2Offset(this.elementRawOffset(e));
    }

    protected int elementOffset(int n) {
        return this.elementOffset(this.get(n));
    }

    public void defaultInsertUpdate(int n, int n2) {
        assert (n2 >= 0);
        if (n != this.offsetGapStart()) {
            this.moveOffsetGap(n, this.findOffsetIndex(n));
        }
        this.updateOffsetGapLength(-n2);
        this.updateOffsetGapStart(n2);
    }

    public void defaultRemoveUpdate(int n, int n2) {
        Object object;
        int n3;
        assert (n2 >= 0);
        int n4 = this.findOffsetIndex(n);
        if (n != this.offsetGapStart()) {
            this.moveOffsetGap(n, n4);
        }
        int n5 = this.size();
        int n6 = n + this.offsetGapLength + n2;
        while (n4 < n5 && (n3 = this.elementRawOffset(object = this.get(n4++))) < n6) {
            if (this.fixedZeroOffset && n3 == 0) continue;
            this.setElementRawOffset(object, n6);
        }
        this.updateOffsetGapLength(n2);
    }

    protected final void moveOffsetGap(int n, int n2) {
        if (n < this.offsetGapStart) {
            Object object;
            int n3;
            int n4 = this.size();
            for (int i = n2; i < n4 && (n3 = this.elementRawOffset(object = this.get(i))) < this.offsetGapStart; ++i) {
                if (this.fixedZeroOffset && n3 == 0) continue;
                this.setElementRawOffset(object, n3 + this.offsetGapLength);
            }
        } else {
            Object object;
            int n5;
            for (int i = n2 - 1; i >= 0 && (n5 = this.elementRawOffset(object = this.get(i))) >= this.offsetGapStart; --i) {
                if (this.fixedZeroOffset && n5 == 0) continue;
                this.setElementRawOffset(object, n5 - this.offsetGapLength);
            }
        }
        this.offsetGapStart = n;
    }

    protected final int offsetGapStart() {
        return this.offsetGapStart;
    }

    protected final void updateOffsetGapStart(int n) {
        this.offsetGapStart += n;
    }

    protected final int offsetGapLength() {
        return this.offsetGapLength;
    }

    protected final void updateOffsetGapLength(int n) {
        this.offsetGapLength += n;
        assert (this.offsetGapLength >= 0);
    }

    protected final int findOffsetIndex(int n) {
        int n2 = this.findElementIndex(n);
        return n2 < 0 ? -n2 - 1 : n2;
    }

    public final int findElementIndex(int n, int n2, int n3) {
        if (n2 < 0 || n3 > this.size() - 1) {
            throw new IndexOutOfBoundsException("lowIdx = " + n2 + ", highIdx = " + n3 + ", size = " + this.size());
        }
        int n4 = n2;
        int n5 = n3;
        while (n4 <= n5) {
            int n6 = n4 + n5 >> 1;
            int n7 = this.elementOffset(n6);
            if (n7 < n) {
                n4 = n6 + 1;
                continue;
            }
            if (n7 > n) {
                n5 = n6 - 1;
                continue;
            }
            while (n6 > 0) {
                if (this.elementOffset(--n6) >= n) continue;
                ++n6;
                break;
            }
            return n6;
        }
        return -(n4 + 1);
    }

    public final int findElementIndex(int n) {
        return this.findElementIndex(n, 0, this.size() - 1);
    }

    protected void updateElementOffsetAdd(E e) {
        int n = this.elementRawOffset(e);
        if (n >= this.offsetGapStart) {
            this.setElementRawOffset(e, n + this.offsetGapLength);
        }
    }

    protected void updateElementOffsetRemove(E e) {
        int n = this.elementRawOffset(e);
        if (n >= this.offsetGapStart) {
            this.setElementRawOffset(e, n - this.offsetGapLength);
        }
    }

    protected final int raw2Offset(int n) {
        if (this.fixedZeroOffset && n == 0) {
            return 0;
        }
        return n < this.offsetGapStart ? n : n - this.offsetGapLength;
    }

    protected final int offset2raw(int n) {
        if (this.fixedZeroOffset && n == 0) {
            return 0;
        }
        return n < this.offsetGapStart ? n : n + this.offsetGapLength;
    }

    protected void consistencyCheck() {
        super.consistencyCheck();
        if (this.offsetGapLength < 0) {
            this.consistencyError("offsetGapLength < 0");
        }
        int n = Integer.MIN_VALUE;
        int n2 = Integer.MIN_VALUE;
        int n3 = this.size();
        for (int i = 0; i < n3; ++i) {
            Object object = this.get(i);
            int n4 = this.elementRawOffset(object);
            int n5 = this.raw2Offset(n4);
            if (n4 < n) {
                this.consistencyError("Invalid rawOffset=" + n4 + " >= lastRawOffset=" + n + " at index=" + i);
            }
            if (n5 < n2) {
                this.consistencyError("Invalid offset=" + n5 + " >= lastOffset=" + n2 + " at index=" + i);
            }
            n = n4;
            n2 = n5;
        }
    }

    protected String dumpInternals() {
        return super.dumpInternals() + ", offGap(s=" + this.offsetGapStart + ", l=" + this.offsetGapLength + ")";
    }
}

