/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.welcome;

import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.LayoutManager;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.jdesktop.layout.GroupLayout;
import org.jfree.text.G2TextMeasurer;

public class GraySeparator
extends JPanel {
    public static final int SEPARATOR_NORTH = 0;
    public static final int SEPARATOR_SOUTH = 1;
    public static final int SEPARATOR_EAST = 2;
    public static final int SEPARATOR_WEST = 3;
    private int separatorType = 0;
    private boolean paintStar = false;
    ImageIcon imageIcon = new ImageIcon(G2TextMeasurer.class.getResource("/com/jaspersoft/ireport/designer/welcome/cross.png"));

    public GraySeparator() {
        this(0, false);
    }

    public GraySeparator(int type) {
        this(type, false);
    }

    public GraySeparator(int type, boolean paintStar) {
        this.initComponents();
        this.separatorType = type;
        this.paintStar = paintStar;
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(0, 300, Short.MAX_VALUE));
    }

    public void paint(Graphics g) {
        Color origColor = g.getColor();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(new Color(222, 222, 222));
        if (this.getSeparatorType() == 0) {
            int top = 25;
            g.drawLine(13, top, 13, this.getHeight());
            if (this.isPaintStar() && this.imageIcon != null) {
                g.drawImage(this.imageIcon.getImage(), 0, this.getHeight() - 27, this);
            }
        } else if (this.getSeparatorType() == 1) {
            int bottom = this.getHeight() - 25;
            g.drawLine(13, 0, 13, bottom);
            if (this.isPaintStar() && this.imageIcon != null) {
                g.drawImage(this.imageIcon.getImage(), 0, 0, this);
            }
        }
        if (this.getSeparatorType() == 3) {
            int left = 25;
            g.drawLine(left, 13, this.getWidth(), 13);
            if (this.isPaintStar() && this.imageIcon != null) {
                g.drawImage(this.imageIcon.getImage(), this.getWidth() - 27, 0, this);
            }
        } else if (this.getSeparatorType() == 2) {
            int right = this.getWidth() - 25;
            g.drawLine(0, 13, right, 13);
            if (this.isPaintStar() && this.imageIcon != null) {
                g.drawImage(this.imageIcon.getImage(), 0, 0, this);
            }
        }
    }

    public int getSeparatorType() {
        return this.separatorType;
    }

    public void setSeparatorType(int separatorType) {
        this.separatorType = separatorType;
    }

    public boolean isPaintStar() {
        return this.paintStar;
    }

    public void setPaintStar(boolean paintStar) {
        this.paintStar = paintStar;
    }
}

