/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.utils;

import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.util.Stack;

public class Java2DUtils {
    private static Stack clipBoundsStack = new Stack();
    private static Stack transforms = new Stack();

    public static void setClip(Graphics g, int x, int y, int width, int height) {
        Java2DUtils.setClip(g, new Rectangle(x, y, width, height));
    }

    public static void setClip(Graphics g, Rectangle clipBounds) {
        clipBounds = new Rectangle(clipBounds);
        ++clipBounds.width;
        ++clipBounds.height;
        Rectangle currentClipBounds = g.getClipBounds();
        if (currentClipBounds != null) {
            clipBounds = clipBounds.intersection(g.getClipBounds());
        }
        clipBoundsStack.push(currentClipBounds);
        g.setClip(clipBounds);
    }

    public static void resetClip(Graphics g) {
        g.setClip((Shape)clipBoundsStack.pop());
    }

    public static void setTransform(Graphics2D g2, AffineTransform transform) {
        AffineTransform current = g2.getTransform();
        transforms.push(current);
        g2.setTransform(transform);
    }

    public static void resetTransform(Graphics2D g2) {
        if (transforms.empty()) {
            return;
        }
        g2.setTransform((AffineTransform)transforms.pop());
    }

    public static Stroke getInvertedZoomedStroke(Stroke stroke, double zoom) {
        if (stroke == null || !(stroke instanceof BasicStroke)) {
            return stroke;
        }
        BasicStroke bs = (BasicStroke)stroke;
        float[] dashArray = bs.getDashArray();
        float[] newDashArray = null;
        if (dashArray != null) {
            newDashArray = new float[dashArray.length];
            for (int i = 0; i < newDashArray.length; ++i) {
                newDashArray[i] = (float)((double)dashArray[i] / zoom);
            }
        }
        BasicStroke newStroke = new BasicStroke((float)((double)bs.getLineWidth() / zoom), bs.getEndCap(), bs.getLineJoin(), bs.getMiterLimit(), newDashArray, (float)((double)bs.getDashPhase() / zoom));
        return newStroke;
    }
}

