/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.sheet.properties.style;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import com.jaspersoft.ireport.locale.I18n;
import java.lang.reflect.InvocationTargetException;
import net.sf.jasperreports.engine.base.JRBaseStyle;
import org.openide.nodes.PropertySupport;

public final class StyledTextProperty
extends PropertySupport.ReadWrite {
    private final JRBaseStyle style;

    public StyledTextProperty(JRBaseStyle style) {
        super("isStyledText", Boolean.class, I18n.getString("AbstractStyleNode.Property.Is_Styled_Text"), I18n.getString("AbstractStyleNode.Property.StyleTextDetail"));
        this.style = style;
    }

    public Object getValue() throws IllegalAccessException, InvocationTargetException {
        return this.style.isStyledText();
    }

    public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (val == null || val instanceof Boolean) {
            Boolean oldValue = this.style.isOwnStyledText();
            Boolean newValue = (Boolean)val;
            this.style.setStyledText(newValue);
            ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.style, "StyledText", Boolean.class, oldValue, newValue);
            IReportManager.getInstance().addUndoableEdit(urob);
        }
    }

    public boolean isDefaultValue() {
        return this.style.isOwnStyledText() == null;
    }

    public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
        this.setValue(null);
    }

    public boolean supportsDefaultValue() {
        return true;
    }
}

