/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.sheet.properties;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.sheet.editors.ComboBoxPropertyEditor;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import com.jaspersoft.ireport.locale.I18n;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.design.JRDesignTextElement;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.nodes.PropertySupport;

public class ReportFontProperty
extends PropertySupport.ReadWrite {
    private final JRDesignTextElement element;
    private final JasperDesign jd;
    PropertyEditor editor = null;

    public ReportFontProperty(JRDesignTextElement element, JasperDesign jd) {
        super("reportFont", JRReportFont.class, I18n.getString("Global.Property.Reportfont"), I18n.getString("Global.Property.Reportfont"));
        this.element = element;
        this.jd = jd;
        this.setValue("canEditAsText", false);
        this.setValue("oneline", true);
        this.setValue("suppressCustomEditor", true);
    }

    public Object getValue() throws IllegalAccessException, InvocationTargetException {
        return this.element.getReportFont() == null ? "" : this.element.getReportFont();
    }

    public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (val == null || val instanceof JRReportFont) {
            JRReportFont oldValue = this.element.getReportFont();
            JRReportFont newValue = (JRReportFont)val;
            this.element.setReportFont(newValue);
            ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.element, "ReportFont", JRReportFont.class, oldValue, newValue);
            IReportManager.getInstance().addUndoableEdit(urob);
        }
    }

    public boolean isDefaultValue() {
        return this.element.getReportFont() == null;
    }

    public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
        this.setValue(null);
    }

    public boolean supportsDefaultValue() {
        return true;
    }

    public PropertyEditor getPropertyEditor() {
        if (this.editor == null) {
            ArrayList<Tag> classes = new ArrayList<Tag>();
            List fonts = this.jd.getFontsList();
            for (int i = 0; i < fonts.size(); ++i) {
                JRReportFont font = (JRReportFont)fonts.get(i);
                classes.add(new Tag(font, font.getName()));
            }
            this.editor = new ComboBoxPropertyEditor(false, classes);
        }
        return this.editor;
    }

    public String getHtmlDisplayName() {
        return "<s>" + super.getDisplayName() + "</s>";
    }
}

