/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.sheet;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.sheet.editors.JRImportsPropertyEditor;
import com.jaspersoft.ireport.locale.I18n;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.nodes.PropertySupport;

public class JRImportsProperty
extends PropertySupport {
    PropertyEditor editor = null;
    JasperDesign jd = null;

    public JRImportsProperty(JasperDesign jd) {
        super("imports", new String[0].getClass(), I18n.getString("Property.Imports"), I18n.getString("Property.Imports.detail"), true, true);
        this.setValue("canEditAsText", Boolean.FALSE);
        this.jd = jd;
    }

    public Object getValue() throws IllegalAccessException, InvocationTargetException {
        return this.jd.getImports();
    }

    public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (val == null || !val.getClass().isArray() || !val.getClass().getComponentType().equals(String.class)) {
            throw new IllegalArgumentException();
        }
        if (this.jd.getImports() == val) {
            return;
        }
        String[] originalImports = this.jd.getImports();
        for (int i = 0; originalImports != null && i < originalImports.length; ++i) {
            this.jd.removeImport(originalImports[i]);
        }
        String[] newImports = (String[])val;
        for (int i = 0; newImports != null && i < newImports.length; ++i) {
            this.jd.addImport(newImports[i]);
        }
        IReportManager.getInstance().notifyReportChange();
    }

    public PropertyEditor getPropertyEditor() {
        if (this.editor == null) {
            this.editor = new JRImportsPropertyEditor();
        }
        return this.editor;
    }
}

