/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.dnd.DnDUtilities;
import com.jaspersoft.ireport.designer.outline.NewTypesUtils;
import com.jaspersoft.ireport.designer.outline.nodes.CrosstabGroupNode;
import com.jaspersoft.ireport.designer.outline.nodes.CrosstabGroupsChildren;
import com.jaspersoft.ireport.designer.outline.nodes.IRIndexedNode;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabParameter;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.actions.NewAction;
import org.openide.actions.PasteAction;
import org.openide.actions.ReorderAction;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.nodes.NodeTransfer;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class CrosstabGroupsNode
extends IRIndexedNode
implements PropertyChangeListener {
    private JasperDesign jd = null;
    private JRDesignCrosstab crosstab = null;
    private int type = 1;

    public CrosstabGroupsNode(JasperDesign jd, JRDesignCrosstab crosstab, Lookup doLkp, int type) {
        this(new CrosstabGroupsChildren(jd, crosstab, doLkp, type), jd, crosstab, doLkp, type);
    }

    public CrosstabGroupsNode(CrosstabGroupsChildren pc, JasperDesign jd, JRDesignCrosstab crosstab, Lookup doLkp, int type) {
        super((Children)pc, pc.getIndex(), (Lookup)new ProxyLookup(new Lookup[]{doLkp, Lookups.fixed((Object[])new Object[]{jd, crosstab})}));
        this.type = type;
        this.addNodeListener(new NodeListener(){

            public void childrenAdded(NodeMemberEvent ev) {
            }

            public void childrenRemoved(NodeMemberEvent ev) {
            }

            public void childrenReordered(NodeReorderEvent ev) {
                List list = CrosstabGroupsNode.this.getType() == 1 ? CrosstabGroupsNode.this.getCrosstab().getRowGroupsList() : CrosstabGroupsNode.this.getCrosstab().getColumnGroupsList();
                ArrayList<JRDesignCrosstabGroup> newList = new ArrayList<JRDesignCrosstabGroup>();
                Map map = CrosstabGroupsNode.this.getType() == 1 ? CrosstabGroupsNode.this.getCrosstab().getRowGroupIndicesMap() : CrosstabGroupsNode.this.getCrosstab().getColumnGroupIndicesMap();
                map.clear();
                Node[] nodes = CrosstabGroupsNode.this.getChildren().getNodes();
                for (int i = 0; i < nodes.length; ++i) {
                    JRDesignCrosstabGroup p = ((CrosstabGroupNode)nodes[i]).getGroup();
                    newList.add(p);
                    map.put(p.getName(), new Integer(i));
                }
                list.clear();
                list.addAll(newList);
                String prop = CrosstabGroupsNode.this.getType() == 1 ? "rowGroups" : "columnGroups";
                CrosstabGroupsNode.this.getCrosstab().getEventSupport().firePropertyChange(new PropertyChangeEvent(CrosstabGroupsNode.this.getCrosstab(), prop, null, null));
            }

            public void nodeDestroyed(NodeEvent ev) {
            }

            public void propertyChange(PropertyChangeEvent evt) {
            }
        });
        this.jd = jd;
        this.crosstab = crosstab;
        crosstab.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        if (this.getType() == 1) {
            this.setDisplayName("Row Groups");
            this.setIconBaseWithExtension("com/jaspersoft/ireport/designer/resources/crosstabrows-16.png");
        } else {
            this.setDisplayName("Column Groups");
            this.setIconBaseWithExtension("com/jaspersoft/ireport/designer/resources/crosstabcolumns-16.png");
        }
    }

    public PasteType getDropType(Transferable t, int action, int index) {
        JRDesignCrosstabParameter parameter;
        Node dropNode = NodeTransfer.node((Transferable)t, (int)7);
        int dropAction = DnDUtilities.getTransferAction(t);
        if (null != dropNode && null != (parameter = (JRDesignCrosstabParameter)dropNode.getLookup().lookup(JRDesignCrosstabParameter.class))) {
            return new PasteType(){

                public Transferable paste() throws IOException {
                    return null;
                }
            };
        }
        return null;
    }

    protected void createPasteTypes(Transferable t, List s) {
        super.createPasteTypes(t, s);
        PasteType paste = this.getDropType(t, 2, -1);
        if (null != paste) {
            s.add(paste);
        }
    }

    public Action[] getActions(boolean context) {
        return new Action[]{SystemAction.get(NewAction.class), SystemAction.get(PasteAction.class), SystemAction.get(ReorderAction.class)};
    }

    public boolean canDestroy() {
        return false;
    }

    public boolean hasCustomizer() {
        return true;
    }

    public JasperDesign getJasperDesign() {
        return this.jd;
    }

    public NewType[] getNewTypes() {
        if (this.getType() == 1) {
            return NewTypesUtils.getNewType((Node)this, 7);
        }
        return NewTypesUtils.getNewType((Node)this, 8);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        IReportManager.getInstance().notifyReportChange();
        if (evt.getPropertyName().equals("rowGroups") && this.getType() == 1) {
            ((CrosstabGroupsChildren)this.getChildren()).recalculateKeys();
        } else if (evt.getPropertyName().equals("columnGroups") && this.getType() == 2) {
            ((CrosstabGroupsChildren)this.getChildren()).recalculateKeys();
        }
    }

    public JRDesignCrosstab getCrosstab() {
        return this.crosstab;
    }

    public int getType() {
        return this.type;
    }
}

