/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.editor.functions;

import com.jaspersoft.ireport.designer.editor.ExpressionEditor2;
import com.jaspersoft.ireport.designer.editor.functions.Function;
import com.jaspersoft.ireport.designer.editor.functions.Parameter;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionPanel
extends JPanel {
    private List<JComboBox> editors = new ArrayList<JComboBox>();
    private JButton jButton15;
    private JLabel jLabel10;
    private JLabel jLabel8;
    private JLabel jLabelDescriprion;
    private JLabel jLabelFunctionName;
    private JLabel jLabelReturnType;
    private JPanel jPanel1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;

    public FunctionPanel() {
        this.initComponents();
    }

    public void setFunction(Function function) {
        this.jLabelFunctionName.setText(function.getName());
        this.jLabelDescriprion.setText("<html>" + function.getDescription());
        this.jLabelReturnType.setText("<html><b>" + function.getReturnType());
        int i = 0;
        int preferredHeight = 0;
        this.jPanel1.removeAll();
        for (Parameter p : function.getParameters()) {
            JComboBox editor = p.getUI();
            if (editor == null) {
                editor = new JComboBox();
                editor.setEditable(true);
            }
            this.getEditors().add(editor);
            JLabel label = new JLabel(p.getLabel());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = i;
            gridBagConstraints.insets = new Insets(0, 0, 4, 4);
            this.jPanel1.add((Component)label, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridy = i;
            gridBagConstraints.insets = new Insets(0, 0, 4, 0);
            this.jPanel1.add(editor, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridy = i;
            gridBagConstraints.insets = new Insets(0, 0, 2, 0);
            JButton functionButton = new JButton();
            functionButton.setText("");
            functionButton.setActionCommand("" + i);
            functionButton.setIcon(null);
            functionButton.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/editor/text_edit.png")));
            functionButton.setMargin(new Insets(0, 2, 0, 2));
            functionButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    int index = Integer.parseInt(evt.getActionCommand());
                    ExpressionEditor2 editor = new ExpressionEditor2();
                    editor.setExpression(FunctionPanel.this.getTextArg(index));
                    if (editor.showDialog(Misc.getMainFrame()) == 0) {
                        FunctionPanel.this.setTextArg(index, editor.getExpression());
                    }
                }
            });
            this.jPanel1.add((Component)functionButton, gridBagConstraints);
            preferredHeight += Math.max(((Component)editor).getPreferredSize().height, label.getPreferredSize().height);
            ++i;
        }
        this.jPanel1.setPreferredSize(new Dimension(0, preferredHeight));
        this.jPanel1.updateUI();
        this.doLayout();
    }

    public String getTextArg(int index) {
        if (this.getEditors().get(index).getSelectedItem() == null) {
            return "";
        }
        return "" + this.getEditors().get(index).getSelectedItem();
    }

    public void setTextArg(int index, String text) {
        this.getEditors().get(index).setSelectedItem(text);
    }

    private void initComponents() {
        this.jSeparator3 = new JSeparator();
        this.jLabelFunctionName = new JLabel();
        this.jLabel10 = new JLabel();
        this.jLabelDescriprion = new JLabel();
        this.jButton15 = new JButton();
        this.jLabelReturnType = new JLabel();
        this.jLabel8 = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.jSeparator1 = new JSeparator();
        this.jPanel1 = new JPanel();
        this.jLabelFunctionName.setFont(new Font("MS UI Gothic", 1, 14));
        this.jLabelFunctionName.setText(NbBundle.getMessage(FunctionPanel.class, (String)"FunctionPanel.jLabelFunctionName.text"));
        this.jLabel10.setText(NbBundle.getMessage(FunctionPanel.class, (String)"FunctionPanel.jLabel10.text"));
        this.jLabelDescriprion.setText(NbBundle.getMessage(FunctionPanel.class, (String)"FunctionPanel.jLabelDescriprion.text"));
        this.jButton15.setText(NbBundle.getMessage(FunctionPanel.class, (String)"FunctionPanel.jButton15.text"));
        this.jButton15.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FunctionPanel.this.jButton15ActionPerformed(evt);
            }
        });
        this.jLabelReturnType.setText(NbBundle.getMessage(FunctionPanel.class, (String)"FunctionPanel.jLabelReturnType.text"));
        this.jLabel8.setText(NbBundle.getMessage(FunctionPanel.class, (String)"FunctionPanel.jLabel8.text"));
        this.jPanel1.setLayout(new GridBagLayout());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, 380, Short.MAX_VALUE).addComponent(this.jSeparator1, -1, 380, Short.MAX_VALUE).addComponent(this.jLabelReturnType, -1, 380, Short.MAX_VALUE).addComponent(this.jLabel8, -1, 380, Short.MAX_VALUE).addComponent(this.jLabelDescriprion, -1, 380, Short.MAX_VALUE).addComponent(this.jLabelFunctionName).addComponent(this.jSeparator2, -1, 380, Short.MAX_VALUE).addComponent(this.jLabel10, -1, 380, Short.MAX_VALUE).addComponent(this.jSeparator3, -1, 380, Short.MAX_VALUE).addComponent(this.jButton15, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabelFunctionName).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabelDescriprion, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator2, -2, 10, -2).addGap(1, 1, 1).addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelReturnType, -2, 14, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator3, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton15).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jButton15ActionPerformed(ActionEvent evt) {
    }

    public List<JComboBox> getEditors() {
        return this.editors;
    }

    public void setEditors(List<JComboBox> editors) {
        this.editors = editors;
    }
}

