/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.editor;

import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.editor.ExpressionContext;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JasperDesign;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FullExpressionContext
extends ExpressionContext {
    WeakReference<JasperDesign> documentReference = null;

    public FullExpressionContext(JasperDesign jasperDesign) {
        this.documentReference = new WeakReference<JasperDesign>(jasperDesign);
    }

    @Override
    public List<JRDesignCrosstab> getCrosstabs() {
        if (this.documentReference != null && this.documentReference.get() != null) {
            ArrayList<JRDesignCrosstab> list = new ArrayList<JRDesignCrosstab>();
            List<JRBand> bands = ModelUtils.getBands((JasperDesign)this.documentReference.get());
            for (JRBand band : bands) {
                if (band == null) continue;
                this.findCrosstabs((JRElementGroup)band, list);
            }
            return list;
        }
        return Collections.EMPTY_LIST;
    }

    public List<JRDesignCrosstab> findCrosstabs(JRElementGroup group, List<JRDesignCrosstab> list) {
        List objects = group.getChildren();
        for (int i = 0; i < objects.size(); ++i) {
            Object obj = objects.get(i);
            if (obj instanceof JRDesignCrosstab) {
                list.add((JRDesignCrosstab)obj);
                continue;
            }
            if (!(obj instanceof JRElementGroup)) continue;
            this.findCrosstabs((JRElementGroup)obj, list);
        }
        return list;
    }

    @Override
    public List<JRDesignDataset> getDatasets() {
        if (this.documentReference != null && this.documentReference.get() != null) {
            ArrayList<JRDesignDataset> list = new ArrayList<JRDesignDataset>();
            list.add(((JasperDesign)this.documentReference.get()).getMainDesignDataset());
            List datasets = ((JasperDesign)this.documentReference.get()).getDatasetsList();
            for (int i = 0; i < datasets.size(); ++i) {
                list.add((JRDesignDataset)datasets.get(i));
            }
            return list;
        }
        return super.getDatasets();
    }
}

