/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.connection;

import com.jaspersoft.ireport.designer.IRURLClassLoader;
import com.jaspersoft.ireport.designer.IReportConnection;
import com.jaspersoft.ireport.designer.IReportConnectionEditor;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ReportClassLoader;
import com.jaspersoft.ireport.designer.connection.gui.EJBQLConnectionEditor;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.io.File;
import java.net.URL;
import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.sf.jasperreports.engine.JRDataSource;

public class EJBQLConnection
extends IReportConnection {
    private String name;
    private HashMap map = new HashMap();
    private String persistenceUnit;
    private EntityManager em = null;
    private EntityManagerFactory emf = null;
    private int usedby = 0;

    public Connection getConnection() {
        return null;
    }

    public boolean isJDBCConnection() {
        return false;
    }

    public boolean isJRDataSource() {
        return false;
    }

    public HashMap getProperties() {
        return this.map;
    }

    public void loadProperties(HashMap map) {
        this.map = map;
    }

    public JRDataSource getJRDataSource() {
        return null;
    }

    public EntityManager getEntityManager() throws Exception {
        if (this.em == null) {
            if (this.emf == null) {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                if (cl instanceof ReportClassLoader) {
                    List items = ((ReportClassLoader)cl).getCachedItems();
                    URL[] urls = new URL[items.size()];
                    for (int i = 0; i < items.size(); ++i) {
                        urls[i] = new File("" + items.get(i)).toURI().toURL();
                    }
                    IRURLClassLoader urlClassLoader = new IRURLClassLoader(urls, cl);
                    Thread.currentThread().setContextClassLoader(urlClassLoader);
                }
                this.emf = Persistence.createEntityManagerFactory((String)Misc.nvl(this.getProperties().get("PersistenceUnit"), null), new HashMap());
            }
            this.em = this.emf.createEntityManager();
        }
        ++this.usedby;
        return this.em;
    }

    public void closeEntityManager() {
        try {
            if (this.em != null) {
                --this.usedby;
                if (this.usedby == 0) {
                    this.em.close();
                    this.em = null;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getDescription() {
        return "EJBQL\u63a5\u7d9a";
    }

    public IReportConnectionEditor getIReportConnectionEditor() {
        return new EJBQLConnectionEditor();
    }

    public void test() throws Exception {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Thread thread = Thread.currentThread();
                    IReportManager.getInstance();
                    thread.setContextClassLoader(IReportManager.getReportClassLoader());
                    try {
                        EJBQLConnection.this.getEntityManager();
                        EJBQLConnection.this.closeEntityManager();
                        JOptionPane.showMessageDialog(Misc.getMainWindow(), "Connection test successful!", "", 1);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        JOptionPane.showMessageDialog(Misc.getMainWindow(), ex.getMessage(), "Error", 0);
                        return;
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

