/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.charts.datasets;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.charts.datasets.ChartDatasetPanel;
import com.jaspersoft.ireport.designer.charts.datasets.DatasetListsCellRenderer;
import com.jaspersoft.ireport.designer.charts.datasets.PieSeriesDialog;
import com.jaspersoft.ireport.designer.charts.datasets.PieSeriesPanel;
import com.jaspersoft.ireport.designer.editor.ExpressionContext;
import com.jaspersoft.ireport.designer.editor.ExpressionEditorArea;
import com.jaspersoft.ireport.designer.tools.HyperlinkPanel;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.jasperreports.charts.JRPieSeries;
import net.sf.jasperreports.charts.design.JRDesignPieDataset;
import net.sf.jasperreports.charts.design.JRDesignPieSeries;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRHyperlink;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignHyperlink;

public class PieDatasetPanel
extends JPanel
implements ChartDatasetPanel {
    private ExpressionContext expressionContext = null;
    private JRDesignPieDataset pieDataset = null;
    private PieSeriesPanel pieSeriesPanel = null;
    public static final int SINGLE_SERIES_MODE = 0;
    public static final int MULTIPLE_SERIES_MODE = 1;
    private int currentMode = -1;
    private JButton jButtonAdd;
    private JButton jButtonMode;
    private JButton jButtonModify;
    private JButton jButtonRemove;
    private JLabel jLabelKeyExpression1;
    private JLabel jLabelLabelExpression1;
    private JLabel jLabelMaxCount;
    private JLabel jLabelMinPercentage;
    private JList jList1;
    private JMenuItem jMenuItemCopy;
    private JMenuItem jMenuItemPaste;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel7;
    private JPanel jPanelData;
    private JPanel jPanelSeries;
    private JPopupMenu jPopupMenuPieSeries;
    private ExpressionEditorArea jRTextExpressionOtherKey;
    private ExpressionEditorArea jRTextExpressionOtherLabel;
    private JScrollPane jScrollPane1;
    private JSpinner jSpinnerMaxCount;
    private JSpinner jSpinnerMinPercentage;
    private JTabbedPane jTabbedPane1;
    private HyperlinkPanel sectionItemHyperlinkPanel2;

    public PieDatasetPanel() {
        this.initComponents();
        this.jRTextExpressionOtherKey.getExpressionEditorPane().getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent evt) {
                PieDatasetPanel.this.jRTextExpressionOtherKeyTextChanged();
            }

            public void insertUpdate(DocumentEvent evt) {
                PieDatasetPanel.this.jRTextExpressionOtherKeyTextChanged();
            }

            public void removeUpdate(DocumentEvent evt) {
                PieDatasetPanel.this.jRTextExpressionOtherKeyTextChanged();
            }
        });
        this.jRTextExpressionOtherLabel.getExpressionEditorPane().getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent evt) {
                PieDatasetPanel.this.jRTextExpressionOtherLabelTextChanged();
            }

            public void insertUpdate(DocumentEvent evt) {
                PieDatasetPanel.this.jRTextExpressionOtherLabelTextChanged();
            }

            public void removeUpdate(DocumentEvent evt) {
                PieDatasetPanel.this.jRTextExpressionOtherLabelTextChanged();
            }
        });
        this.pieSeriesPanel = new PieSeriesPanel();
        this.jList1.setModel(new DefaultListModel());
        this.jList1.setCellRenderer(new DatasetListsCellRenderer());
        SpinnerNumberModel maxCountSpinner = new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1);
        maxCountSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                SpinnerNumberModel model = (SpinnerNumberModel)PieDatasetPanel.this.jSpinnerMaxCount.getModel();
                if (model.getNumber().intValue() == 0) {
                    PieDatasetPanel.this.getPieDataset().setMaxCount(null);
                } else {
                    PieDatasetPanel.this.getPieDataset().setMaxCount(Integer.valueOf(model.getNumber().intValue()));
                }
            }
        });
        this.jSpinnerMaxCount.setModel(maxCountSpinner);
        SpinnerNumberModel minPercentagetSpinner = new SpinnerNumberModel(0.0, 0.0, 100.0, 1.0);
        minPercentagetSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                SpinnerNumberModel model = (SpinnerNumberModel)PieDatasetPanel.this.jSpinnerMinPercentage.getModel();
                if (model.getNumber().floatValue() == 0.0f) {
                    PieDatasetPanel.this.getPieDataset().setMinPercentage(null);
                } else {
                    PieDatasetPanel.this.getPieDataset().setMinPercentage(Float.valueOf(model.getNumber().floatValue()));
                }
            }
        });
        this.jSpinnerMinPercentage.setModel(minPercentagetSpinner);
    }

    public JRDesignPieDataset getPieDataset() {
        return this.pieDataset;
    }

    public void setExpressionContext(ExpressionContext ec) {
        this.expressionContext = ec;
        this.jRTextExpressionOtherKey.setExpressionContext(ec);
        this.jRTextExpressionOtherLabel.setExpressionContext(ec);
        this.sectionItemHyperlinkPanel2.setExpressionContext(ec);
        this.pieSeriesPanel.setExpressionContext(ec);
    }

    public void setPieDataset(JRDesignPieDataset pieDataset) {
        SpinnerNumberModel model;
        this.pieDataset = pieDataset;
        this.jRTextExpressionOtherKey.setText(Misc.getExpressionText(pieDataset.getOtherKeyExpression()));
        this.jRTextExpressionOtherLabel.setText(Misc.getExpressionText(pieDataset.getOtherLabelExpression()));
        if (pieDataset.getOtherSectionHyperlink() == null) {
            JRDesignHyperlink hl = new JRDesignHyperlink();
            hl.setHyperlinkType((byte)1);
            pieDataset.setOtherSectionHyperlink((JRHyperlink)hl);
        }
        this.sectionItemHyperlinkPanel2.setHyperlink(pieDataset.getOtherSectionHyperlink());
        List series = pieDataset.getSeriesList();
        if (series.size() == 0) {
            pieDataset.addPieSeries((JRPieSeries)new JRDesignPieSeries());
        }
        if (series.size() == 1) {
            this.setMode(0);
        } else {
            this.setMode(1);
        }
        try {
            model = (SpinnerNumberModel)this.jSpinnerMaxCount.getModel();
            if (pieDataset.getMaxCount() == null) {
                model.setValue(0);
            } else {
                model.setValue(pieDataset.getMaxCount());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            model = (SpinnerNumberModel)this.jSpinnerMinPercentage.getModel();
            if (pieDataset.getMinPercentage() == null) {
                model.setValue(new Double(0.0));
            } else {
                model.setValue(pieDataset.getMinPercentage().doubleValue());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setMode(int mode) {
        int i;
        if (this.currentMode == mode) {
            return;
        }
        List series = this.pieDataset.getSeriesList();
        if (mode == 0 && this.getPieDataset().getSeriesList().size() > 1) {
            if (JOptionPane.showConfirmDialog(this.pieSeriesPanel, "You have defined {0} series, only one is allowed in single series mode, do you want to discard the other ones?", "", 1, 2) != 0) {
                return;
            }
            for (i = 1; i < series.size(); ++i) {
                series.remove(i);
            }
        }
        this.jPanelData.removeAll();
        if (mode == 0) {
            this.pieSeriesPanel.setPieSeries((JRDesignPieSeries)series.get(0));
            this.jPanelData.add((Component)this.pieSeriesPanel, "Center");
            this.jButtonMode.setText("Use more series");
        } else {
            ((DefaultListModel)this.jList1.getModel()).removeAllElements();
            for (i = 0; i < series.size(); ++i) {
                JRDesignPieSeries pieSeries = (JRDesignPieSeries)series.get(i);
                ((DefaultListModel)this.jList1.getModel()).addElement(pieSeries);
            }
            this.jPanelData.add((Component)this.jPanelSeries, "Center");
            this.jButtonMode.setText("Use one series");
        }
        this.currentMode = mode;
        this.jPanelData.updateUI();
    }

    public void jRTextExpressionOtherKeyTextChanged() {
        JRDesignExpression exp = null;
        if (this.jRTextExpressionOtherKey.getText().trim().length() > 0) {
            exp = new JRDesignExpression();
            exp.setValueClassName("java.lang.Object");
            exp.setText(this.jRTextExpressionOtherKey.getText());
        }
        this.pieDataset.setOtherKeyExpression((JRExpression)exp);
    }

    public void jRTextExpressionOtherLabelTextChanged() {
        JRDesignExpression exp = null;
        if (this.jRTextExpressionOtherLabel.getText().trim().length() > 0) {
            exp = new JRDesignExpression();
            exp.setValueClassName("java.lang.String");
            exp.setText(this.jRTextExpressionOtherLabel.getText());
        }
        this.pieDataset.setOtherLabelExpression((JRExpression)exp);
    }

    private void initComponents() {
        this.jPopupMenuPieSeries = new JPopupMenu();
        this.jMenuItemCopy = new JMenuItem();
        this.jMenuItemPaste = new JMenuItem();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel3 = new JPanel();
        this.jPanelData = new JPanel();
        this.jPanelSeries = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jPanel4 = new JPanel();
        this.jButtonAdd = new JButton();
        this.jButtonModify = new JButton();
        this.jButtonRemove = new JButton();
        this.jPanel5 = new JPanel();
        this.jButtonMode = new JButton();
        this.jPanel7 = new JPanel();
        this.jLabelKeyExpression1 = new JLabel();
        this.jRTextExpressionOtherKey = new ExpressionEditorArea();
        this.jLabelLabelExpression1 = new JLabel();
        this.jRTextExpressionOtherLabel = new ExpressionEditorArea();
        this.sectionItemHyperlinkPanel2 = new HyperlinkPanel();
        this.jPanel1 = new JPanel();
        this.jLabelMaxCount = new JLabel();
        this.jSpinnerMaxCount = new JSpinner();
        this.jLabelMinPercentage = new JLabel();
        this.jSpinnerMinPercentage = new JSpinner();
        this.jMenuItemCopy.setText("Copy series");
        this.jMenuItemCopy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PieDatasetPanel.this.jMenuItemCopyActionPerformed(evt);
            }
        });
        this.jPopupMenuPieSeries.add(this.jMenuItemCopy);
        this.jMenuItemPaste.setText("Paste series");
        this.jMenuItemPaste.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PieDatasetPanel.this.jMenuItemPasteActionPerformed(evt);
            }
        });
        this.jPopupMenuPieSeries.add(this.jMenuItemPaste);
        this.setLayout(new BorderLayout());
        this.jPanel3.setLayout(new GridBagLayout());
        this.jPanelData.setLayout(new BorderLayout());
        this.jPanelSeries.setLayout(new GridBagLayout());
        this.jList1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                PieDatasetPanel.this.jList1MouseClicked(evt);
            }
        });
        this.jList1.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                PieDatasetPanel.this.jList1ValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanelSeries.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel4.setMinimumSize(new Dimension(100, 0));
        this.jPanel4.setPreferredSize(new Dimension(100, 0));
        this.jPanel4.setLayout(new GridBagLayout());
        this.jButtonAdd.setText("Add");
        this.jButtonAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PieDatasetPanel.this.jButtonAddActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 4);
        this.jPanel4.add((Component)this.jButtonAdd, gridBagConstraints);
        this.jButtonModify.setText("Modify");
        this.jButtonModify.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PieDatasetPanel.this.jButtonModifyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 4);
        this.jPanel4.add((Component)this.jButtonModify, gridBagConstraints);
        this.jButtonRemove.setText("Remove");
        this.jButtonRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PieDatasetPanel.this.jButtonRemoveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 4);
        this.jPanel4.add((Component)this.jButtonRemove, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 99;
        gridBagConstraints.weighty = 1.0;
        this.jPanel4.add((Component)this.jPanel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.jPanelSeries.add((Component)this.jPanel4, gridBagConstraints);
        this.jPanelData.add((Component)this.jPanelSeries, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel3.add((Component)this.jPanelData, gridBagConstraints);
        this.jButtonMode.setText("Use more series...");
        this.jButtonMode.setPreferredSize(new Dimension(150, 23));
        this.jButtonMode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PieDatasetPanel.this.jButtonModeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel3.add((Component)this.jButtonMode, gridBagConstraints);
        this.jTabbedPane1.addTab("Pie series", this.jPanel3);
        this.jPanel7.setLayout(new GridBagLayout());
        this.jLabelKeyExpression1.setText("Other Key expression");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.jPanel7.add((Component)this.jLabelKeyExpression1, gridBagConstraints);
        this.jRTextExpressionOtherKey.setBorder(BorderFactory.createEtchedBorder());
        this.jRTextExpressionOtherKey.setMinimumSize(new Dimension(10, 10));
        this.jRTextExpressionOtherKey.setPreferredSize(new Dimension(10, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel7.add((Component)this.jRTextExpressionOtherKey, gridBagConstraints);
        this.jLabelLabelExpression1.setText("Other Label expression");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.jPanel7.add((Component)this.jLabelLabelExpression1, gridBagConstraints);
        this.jRTextExpressionOtherLabel.setBorder(BorderFactory.createEtchedBorder());
        this.jRTextExpressionOtherLabel.setMinimumSize(new Dimension(10, 10));
        this.jRTextExpressionOtherLabel.setPreferredSize(new Dimension(10, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel7.add((Component)this.jRTextExpressionOtherLabel, gridBagConstraints);
        this.jTabbedPane1.addTab("Other section value", this.jPanel7);
        this.jTabbedPane1.addTab("Other section hyperlink", this.sectionItemHyperlinkPanel2);
        this.add((Component)this.jTabbedPane1, "Center");
        this.jTabbedPane1.getAccessibleContext().setAccessibleName("");
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabelMaxCount.setText("Max number of slices to show");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 0);
        this.jPanel1.add((Component)this.jLabelMaxCount, gridBagConstraints);
        this.jSpinnerMaxCount.setPreferredSize(new Dimension(50, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jSpinnerMaxCount, gridBagConstraints);
        this.jLabelMinPercentage.setText("Min slice percentage");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 4, 0);
        this.jPanel1.add((Component)this.jLabelMinPercentage, gridBagConstraints);
        this.jSpinnerMinPercentage.setPreferredSize(new Dimension(50, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel1.add((Component)this.jSpinnerMinPercentage, gridBagConstraints);
        this.add((Component)this.jPanel1, "South");
    }

    /*
     * Enabled aggressive block sorting
     */
    private void jList1MouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 1) {
            if (evt.getButton() == 3) {
                this.jMenuItemCopy.setEnabled(this.jList1.getSelectedIndex() >= 0);
                this.jMenuItemPaste.setEnabled(IReportManager.getInstance().getChartSeriesClipBoard() != null && IReportManager.getInstance().getChartSeriesClipBoard().size() > 0);
                this.jPopupMenuPieSeries.show(this.jList1, evt.getPoint().x, evt.getPoint().y);
                return;
            }
        }
        if (evt.getClickCount() != 2) return;
        if (evt.getButton() != 1) return;
        this.jButtonModifyActionPerformed(null);
    }

    private void jList1ValueChanged(ListSelectionEvent evt) {
        if (this.jList1.getSelectedIndex() >= 0) {
            this.jButtonModify.setEnabled(true);
            this.jButtonRemove.setEnabled(true);
        } else {
            this.jButtonModify.setEnabled(false);
            this.jButtonRemove.setEnabled(false);
        }
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        PieSeriesDialog csd = new PieSeriesDialog(Misc.getMainFrame(), true);
        csd.setExpressionContext(this.getExpressionContext());
        csd.setPieSeries(new JRDesignPieSeries());
        csd.setVisible(true);
        if (csd.getDialogResult() == 0) {
            JRDesignPieSeries series = csd.getPieSeries();
            this.getPieDataset().getSeriesList().add(series);
            ((DefaultListModel)this.jList1.getModel()).addElement(series);
        }
    }

    private void jButtonModifyActionPerformed(ActionEvent evt) {
        if (this.jList1.getSelectedIndex() >= 0) {
            JRDesignPieSeries cs = (JRDesignPieSeries)this.jList1.getSelectedValue();
            PieSeriesDialog csd = new PieSeriesDialog(Misc.getMainFrame(), true);
            csd.setExpressionContext(this.getExpressionContext());
            csd.setPieSeries(cs);
            csd.setVisible(true);
            if (csd.getDialogResult() == 0) {
                JRDesignPieSeries modifiedSeries = csd.getPieSeries();
                cs.setKeyExpression(modifiedSeries.getKeyExpression());
                cs.setValueExpression(modifiedSeries.getValueExpression());
                cs.setLabelExpression(modifiedSeries.getLabelExpression());
                cs.setSectionHyperlink(modifiedSeries.getSectionHyperlink());
                this.jList1.updateUI();
            }
        }
    }

    private void jButtonRemoveActionPerformed(ActionEvent evt) {
        while (this.jList1.getSelectedIndex() >= 0) {
            this.getPieDataset().getSeriesList().remove(this.jList1.getSelectedValue());
            ((DefaultListModel)this.jList1.getModel()).removeElementAt(this.jList1.getSelectedIndex());
        }
    }

    private void jMenuItemCopyActionPerformed(ActionEvent evt) {
        Object[] values = this.jList1.getSelectedValues();
        ArrayList<Object> copy_c = new ArrayList<Object>();
        try {
            for (int i = 0; i < values.length; ++i) {
                copy_c.add(((JRDesignPieSeries)values[i]).clone());
            }
            IReportManager.getInstance().setChartSeriesClipBoard(copy_c);
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    private void jMenuItemPasteActionPerformed(ActionEvent evt) {
        List series = IReportManager.getInstance().getChartSeriesClipBoard();
        if (series != null && series.size() > 0) {
            for (int i = 0; i < series.size(); ++i) {
                if (!(series.get(i) instanceof JRDesignPieSeries)) continue;
                JRDesignPieSeries cs = (JRDesignPieSeries)series.get(i);
                try {
                    cs = (JRDesignPieSeries)cs.clone();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    continue;
                }
                this.getPieDataset().addPieSeries((JRPieSeries)cs);
                ((DefaultListModel)this.jList1.getModel()).addElement(cs);
            }
            this.jList1.updateUI();
        }
    }

    private void jButtonModeActionPerformed(ActionEvent evt) {
        this.setMode(this.currentMode == 0 ? 1 : 0);
    }

    public void setFocusedExpression(Object[] expressionInfo) {
    }

    public void containerWindowOpened() {
    }

    public ExpressionContext getExpressionContext() {
        return this.expressionContext;
    }
}

