/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.actions;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.outline.nodes.ElementGroupNode;
import com.jaspersoft.ireport.designer.outline.nodes.ElementNode;
import com.jaspersoft.ireport.designer.undo.AddElementGroupUndoableEdit;
import com.jaspersoft.ireport.designer.undo.AddElementUndoableEdit;
import com.jaspersoft.ireport.designer.undo.AggregatedUndoableEdit;
import com.jaspersoft.ireport.designer.undo.DeleteElementGroupUndoableEdit;
import com.jaspersoft.ireport.designer.undo.DeleteElementUndoableEdit;
import com.jaspersoft.ireport.designer.undo.RemoveElementGroupUndoableEdit;
import com.jaspersoft.ireport.locale.I18n;
import java.util.ArrayList;
import net.sf.jasperreports.crosstabs.design.JRDesignCellContents;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignElementGroup;
import net.sf.jasperreports.engine.design.JRDesignFrame;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

public final class UnGroupElementsAction
extends NodeAction {
    public String getName() {
        return I18n.getString("UnGroupElementsAction.name");
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected void performAction(Node[] activatedNodes) {
        AggregatedUndoableEdit undoEdit = new AggregatedUndoableEdit();
        undoEdit.setPresentationName(this.getName());
        ArrayList<JRDesignElement> elements = new ArrayList<JRDesignElement>();
        ArrayList<JRDesignElement> groups = new ArrayList<JRDesignElement>();
        for (int i = 0; i < activatedNodes.length; ++i) {
            int index;
            JRDesignElement element;
            JRDesignElementGroup jRDesignElementGroup = ((ElementGroupNode)activatedNodes[i].getParentNode()).getElementGroup();
            if (activatedNodes[i] instanceof ElementNode) {
                element = ((ElementNode)activatedNodes[i]).getElement();
                index = jRDesignElementGroup.getChildren().indexOf(element);
                jRDesignElementGroup.removeElement(element);
                undoEdit.concatenate(new DeleteElementUndoableEdit(element, jRDesignElementGroup, index));
                this.addElement(element, jRDesignElementGroup.getElementGroup());
                undoEdit.concatenate(new AddElementUndoableEdit(element, jRDesignElementGroup.getElementGroup()));
                elements.add(element);
            } else if (activatedNodes[i] instanceof ElementGroupNode) {
                element = ((ElementGroupNode)activatedNodes[i]).getElementGroup();
                index = jRDesignElementGroup.getChildren().indexOf(element);
                jRDesignElementGroup.removeElementGroup((JRDesignElementGroup)element);
                undoEdit.concatenate(new DeleteElementGroupUndoableEdit((JRDesignElementGroup)element, jRDesignElementGroup, index));
                this.addElementGroup((JRDesignElementGroup)element, jRDesignElementGroup.getElementGroup());
                undoEdit.concatenate(new AddElementGroupUndoableEdit((JRDesignElementGroup)element, jRDesignElementGroup.getElementGroup()));
                groups.add(element);
            }
            if (jRDesignElementGroup.getChildren().size() != 0) continue;
            undoEdit.concatenate(new RemoveElementGroupUndoableEdit(jRDesignElementGroup, jRDesignElementGroup.getElementGroup()));
            this.removeElementGroup(jRDesignElementGroup, jRDesignElementGroup.getElementGroup());
        }
        for (JRDesignElementGroup jRDesignElementGroup : groups) {
            IReportManager.getInstance().addSelectedObject(jRDesignElementGroup);
        }
        for (JRDesignElement jRDesignElement : elements) {
            IReportManager.getInstance().addSelectedObject(jRDesignElement);
        }
        IReportManager.getInstance().addUndoableEdit(undoEdit);
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes.length == 0) {
            return false;
        }
        for (int i = 0; i < activatedNodes.length; ++i) {
            if ((activatedNodes[i] instanceof ElementNode || activatedNodes[i] instanceof ElementGroupNode) && activatedNodes[i].getParentNode() instanceof ElementGroupNode) continue;
            return false;
        }
        return true;
    }

    private void addElement(JRDesignElement element, JRElementGroup elementGroup) {
        if (elementGroup instanceof JRDesignElementGroup) {
            ((JRDesignElementGroup)elementGroup).addElement(element);
        } else if (elementGroup instanceof JRDesignBand) {
            ((JRDesignBand)elementGroup).addElement(element);
        } else if (elementGroup instanceof JRDesignCellContents) {
            ((JRDesignCellContents)elementGroup).addElement(element);
        } else if (elementGroup instanceof JRDesignFrame) {
            ((JRDesignFrame)elementGroup).addElement((JRElement)element);
        }
    }

    private void addElementGroup(JRDesignElementGroup element, JRElementGroup elementGroup) {
        if (elementGroup instanceof JRDesignElementGroup) {
            ((JRDesignElementGroup)elementGroup).addElementGroup(element);
        } else if (elementGroup instanceof JRDesignBand) {
            ((JRDesignBand)elementGroup).addElementGroup(element);
        } else if (elementGroup instanceof JRDesignCellContents) {
            ((JRDesignCellContents)elementGroup).addElementGroup(element);
        } else if (elementGroup instanceof JRDesignFrame) {
            ((JRDesignFrame)elementGroup).addElementGroup((JRElementGroup)element);
        }
    }

    private void removeElementGroup(JRDesignElementGroup element, JRElementGroup elementGroup) {
        if (elementGroup instanceof JRDesignElementGroup) {
            ((JRDesignElementGroup)elementGroup).removeElementGroup(element);
        } else if (elementGroup instanceof JRDesignBand) {
            ((JRDesignBand)elementGroup).removeElementGroup(element);
        } else if (elementGroup instanceof JRDesignCellContents) {
            ((JRDesignCellContents)elementGroup).removeElementGroup(element);
        } else if (elementGroup instanceof JRDesignFrame) {
            ((JRDesignFrame)elementGroup).removeElementGroup((JRElementGroup)element);
        }
    }
}

