/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.actions;

import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.ReportObjectScene;
import com.jaspersoft.ireport.designer.widgets.BandSeparatorWidget;
import java.awt.Color;
import java.awt.Point;
import java.util.List;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.netbeans.api.visual.action.MoveStrategy;
import org.netbeans.api.visual.widget.Widget;

public class BandMoveStrategy
implements MoveStrategy {
    boolean reversOrder = false;

    public BandMoveStrategy() {
        this(false);
    }

    public BandMoveStrategy(boolean reversOrder) {
        this.reversOrder = reversOrder;
    }

    public Point locationSuggested(Widget w, Point originalLocation, Point suggestedLocation) {
        JRBand b = ((BandSeparatorWidget)w).getBand();
        JasperDesign jd = ((ReportObjectScene)w.getScene()).getJasperDesign();
        if (!this.reversOrder && b.getHeight() == 0) {
            List<JRBand> bands = ModelUtils.getBands(jd);
            JRBand rightBand = bands.get(0);
            for (JRBand tmpBand : bands) {
                if (tmpBand == b) break;
                if (tmpBand.getHeight() == 0) continue;
                rightBand = tmpBand;
            }
            b = rightBand;
        }
        int bLocation = ModelUtils.getBandLocation(b, jd);
        int maxY = bLocation + ModelUtils.getMaxBandHeight((JRDesignBand)b, jd);
        w.setForeground(ReportObjectScene.EDITING_DESIGN_LINE_COLOR);
        if (bLocation >= suggestedLocation.y) {
            suggestedLocation.y = bLocation;
            w.setForeground(Color.RED);
        } else {
            suggestedLocation.y = Math.min(maxY, suggestedLocation.y);
            if (suggestedLocation.y == maxY) {
                w.setForeground(Color.RED);
            }
        }
        return new Point(0, suggestedLocation.y);
    }
}

