/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer;

import com.jaspersoft.ireport.designer.IReportConnectionEditor;
import com.jaspersoft.ireport.designer.connection.gui.BasicIReportConnectionEditor;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReport;

public abstract class IReportConnection {
    private String name = "";

    public boolean isJDBCConnection() {
        return false;
    }

    public boolean isJRDataSource() {
        return true;
    }

    public abstract String getDescription();

    public Connection getConnection() {
        return null;
    }

    public JRDataSource getJRDataSource(JasperReport jasper) {
        return this.getJRDataSource();
    }

    public JRDataSource getJRDataSource() {
        return new JREmptyDataSource();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public HashMap getProperties() {
        return new HashMap();
    }

    public void loadProperties(HashMap map) {
    }

    public void save(PrintWriter pw) {
        HashMap hm = this.getProperties();
        pw.println("\t<iReportConnection name=\"" + this.getName() + "\" connectionClass=\"" + this.getClass().getName() + "\">");
        for (String key : hm.keySet()) {
            pw.println("\t\t<connectionParameter name=\"" + key + "\"><![CDATA[" + hm.get(key) + "]]></connectionParameter>");
        }
        pw.println("\t</iReportConnection>");
    }

    public String toString() {
        return this.getName();
    }

    public Map getSpecialParameters(Map map) throws JRException {
        return map;
    }

    public Map disposeSpecialParameters(Map map) {
        return map;
    }

    public void test() throws Exception {
    }

    public IReportConnectionEditor getIReportConnectionEditor() {
        return new BasicIReportConnectionEditor();
    }

    public void showErrorMessage(final String errorMsg, final String title) {
        Runnable r = new Runnable(){

            public void run() {
                JOptionPane.showMessageDialog(Misc.getMainWindow(), errorMsg, title, 0);
            }
        };
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(r);
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        } else {
            r.run();
        }
    }
}

