/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.analyzer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.db.sql.analyzer.FromClause;
import org.netbeans.modules.db.sql.analyzer.QualIdent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLStatement {
    int startOffset;
    int endOffset;
    private final List<List<String>> selectValues;
    private final FromClause fromClause;
    private final List<SQLStatement> subqueries;

    public SQLStatement(int n, int n2, List<List<String>> list, FromClause fromClause, List<SQLStatement> list2) {
        this.startOffset = n;
        this.endOffset = n2;
        this.selectValues = list;
        this.fromClause = fromClause;
        this.subqueries = list2;
    }

    public FromClause getFromClause() {
        return this.fromClause;
    }

    public FromClause getTablesInEffect(int n) {
        ArrayList<SQLStatement> arrayList = new ArrayList<SQLStatement>();
        this.fillStatementPath(n, arrayList);
        if (arrayList.size() == 0) {
            return null;
        }
        if (arrayList.size() == 1) {
            return ((SQLStatement)arrayList.get(0)).getFromClause();
        }
        Collections.reverse(arrayList);
        HashSet<QualIdent> hashSet = new HashSet<QualIdent>();
        HashMap<String, QualIdent> hashMap = new HashMap<String, QualIdent>();
        for (SQLStatement sQLStatement : arrayList) {
            FromClause fromClause = sQLStatement.getFromClause();
            if (fromClause == null) continue;
            hashSet.addAll(fromClause.getUnaliasedTableNames());
            for (Map.Entry<String, QualIdent> entry : fromClause.getAliasedTableNames().entrySet()) {
                String string = entry.getKey();
                QualIdent qualIdent = entry.getValue();
                if (hashMap.containsKey(string)) continue;
                hashMap.put(string, qualIdent);
            }
        }
        return new FromClause(Collections.unmodifiableSet(hashSet), Collections.unmodifiableMap(hashMap));
    }

    public List<List<String>> getSelectValues() {
        return this.selectValues;
    }

    public List<SQLStatement> getSubqueries() {
        return this.subqueries;
    }

    private void fillStatementPath(int n, List<SQLStatement> list) {
        if (n >= this.startOffset && n <= this.endOffset) {
            list.add(this);
            for (SQLStatement sQLStatement : this.subqueries) {
                sQLStatement.fillStatementPath(n, list);
            }
        }
    }
}

