/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.addons.transformer;

import com.jaspersoft.ireport.addons.transformer.CompileTransformerOptions;
import com.jaspersoft.ireport.addons.transformer.TransformException;
import com.jaspersoft.ireport.addons.transformer.Transformer;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.awt.Component;
import java.io.File;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.design.JasperDesign;

public class CompileTransformer
implements Transformer {
    private CompileTransformerOptions optionsPanel = null;

    public JasperDesign transform(String srcFileName) throws TransformException {
        File oldJasper;
        String jasperFileName = Misc.changeFileExtension((String)srcFileName, (String)"jasper");
        if (((CompileTransformerOptions)this.getComponent()).isDefaultDirectory()) {
            File f = new File(jasperFileName);
            if (!IReportManager.getPreferences().getBoolean("useReportDirectoryToCompile", true)) {
                jasperFileName = IReportManager.getPreferences().get("reportDirectoryToCompile", ".");
                if (!jasperFileName.endsWith(File.separator)) {
                    jasperFileName = jasperFileName + File.separator;
                }
                jasperFileName = jasperFileName + f.getName();
            }
        }
        if (((CompileTransformerOptions)this.getComponent()).isBackupJasper() && (oldJasper = new File(jasperFileName)).exists()) {
            oldJasper.renameTo(new File(Misc.changeFileExtension((String)srcFileName, (String)"jrxml.bak")));
        }
        try {
            JasperCompileManager.compileReportToFile((String)srcFileName, (String)jasperFileName);
        }
        catch (JRException ex) {
            throw new TransformException((Exception)((Object)ex));
        }
        return null;
    }

    public String getName() {
        return "\u30d5\u30a1\u30a4\u30eb\u3092\u30b3\u30f3\u30d1\u30a4\u30eb";
    }

    public Component getComponent() {
        if (this.optionsPanel == null) {
            this.optionsPanel = new CompileTransformerOptions();
        }
        return this.optionsPanel;
    }
}

