/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.addons.background;

import com.jaspersoft.ireport.addons.background.TransformBackgroundImageAction;
import com.jaspersoft.ireport.designer.AbstractReportObjectScene;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.PopupMenuProvider;
import org.netbeans.api.visual.action.ResizeProvider;
import org.netbeans.api.visual.action.ResizeStrategy;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.openide.util.actions.SystemAction;

public class BackgroundImageWidget
extends Widget {
    private WidgetAction resizeAction = null;
    private WidgetAction moveAction = null;
    private WidgetAction popupMenuAction = null;
    private boolean transforming = false;
    private boolean keepRatio = true;
    private float transparency = 0.25f;
    private ImageIcon img = null;
    private JPopupMenu popupMenu = null;

    public BackgroundImageWidget(Scene scene, ImageIcon img) {
        super(scene);
        this.setBorder(BorderFactory.createEmptyBorder((int)8));
        this.resizeAction = ActionFactory.createResizeAction((ResizeStrategy)new ResizeStrategy(){

            public Rectangle boundsSuggested(Widget widget, Rectangle originalBounds, Rectangle suggestedBounds, ResizeProvider.ControlPoint controlPoint) {
                if (BackgroundImageWidget.this.isKeepRatio() && BackgroundImageWidget.this.getImg() != null) {
                    double ratioH = (double)BackgroundImageWidget.this.getImg().getIconWidth() / (double)BackgroundImageWidget.this.getImg().getIconHeight();
                    double ratioW = (double)BackgroundImageWidget.this.getImg().getIconHeight() / (double)BackgroundImageWidget.this.getImg().getIconWidth();
                    if (originalBounds.width - suggestedBounds.width != 0) {
                        suggestedBounds.height = (int)((double)suggestedBounds.width * ratioW);
                    } else {
                        suggestedBounds.width = (int)((double)suggestedBounds.height * ratioH);
                    }
                }
                return suggestedBounds;
            }
        }, (ResizeProvider)ActionFactory.createDefaultResizeProvider());
        this.moveAction = ActionFactory.createMoveAction();
        this.popupMenuAction = ActionFactory.createPopupMenuAction((PopupMenuProvider)new PopupMenuProvider(){

            public JPopupMenu getPopupMenu(Widget widget, Point localLocation) {
                return ((BackgroundImageWidget)widget).getPopupMenu();
            }
        });
        this.setImg(img);
        this.setPreferredLocation(new Point(-8, -8));
        this.loadState();
        this.addDependency(new Widget.Dependency(){

            public void revalidateDependency() {
                BackgroundImageWidget.this.saveState();
            }
        });
    }

    private JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            JMenuItem fitPageWidth = new JMenuItem("Fit page width");
            fitPageWidth.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int w = ((AbstractReportObjectScene)BackgroundImageWidget.this.getScene()).getJasperDesign().getPageWidth();
                    if (w == 0) {
                        return;
                    }
                    int h = (int)((double)BackgroundImageWidget.this.img.getIconHeight() * ((double)w / (double)BackgroundImageWidget.this.img.getIconWidth()));
                    BackgroundImageWidget.this.setPreferredBounds(new Rectangle(0, 0, w + 16, h + 16));
                    BackgroundImageWidget.this.setPreferredLocation(new Point(-8, -8));
                    BackgroundImageWidget.this.revalidate();
                    BackgroundImageWidget.this.getScene().validate();
                }
            });
            this.popupMenu.add(fitPageWidth);
            JMenu transparencyMenu = new JMenu("Transparency");
            this.createTransparencyMenu(transparencyMenu, new float[]{0.05f, 0.1f, 0.15f, 0.2f, 0.25f, 0.3f, 0.4f, 0.5f, 0.75f, 1.0f});
            this.popupMenu.add(transparencyMenu);
            final JCheckBoxMenuItem cmi = new JCheckBoxMenuItem("Keep ratio");
            cmi.setSelected(this.isKeepRatio());
            cmi.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    BackgroundImageWidget.this.setKeepRatio(cmi.isSelected());
                }
            });
            this.popupMenu.add(cmi);
            this.popupMenu.add(new JSeparator());
            JMenuItem endChanges = new JMenuItem("End Transformation");
            endChanges.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ((TransformBackgroundImageAction)SystemAction.get(TransformBackgroundImageAction.class)).getMenu().setSelected(false);
                    ((TransformBackgroundImageAction)SystemAction.get(TransformBackgroundImageAction.class)).actionPerformed(null);
                }
            });
            this.popupMenu.add(endChanges);
        }
        return this.popupMenu;
    }

    private void createTransparencyMenu(JMenu menu, float[] values) {
        final ButtonGroup bg = new ButtonGroup();
        ActionListener alTransparency = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                float f = Float.valueOf(bg.getSelection().getActionCommand()).floatValue();
                BackgroundImageWidget.this.setTransparency(f);
            }
        };
        for (int i = 0; i < values.length; ++i) {
            JRadioButtonMenuItem mi = new JRadioButtonMenuItem("" + (int)(values[i] * 100.0f) + "%");
            mi.addActionListener(alTransparency);
            mi.setActionCommand(values[i] + "");
            if (values[i] == this.getTransparency()) {
                mi.setSelected(true);
            }
            menu.add(mi);
            bg.add(mi);
        }
    }

    public boolean isTransforming() {
        return this.transforming;
    }

    public void setTransforming(boolean transforming) {
        if (transforming == this.transforming) {
            return;
        }
        this.transforming = transforming;
        if (transforming) {
            this.getActions().addAction(this.resizeAction);
            this.getActions().addAction(this.moveAction);
            this.getActions().addAction(this.popupMenuAction);
            this.setBorder(BorderFactory.createResizeBorder((int)8, (Color)Color.BLACK, (boolean)true));
            this.setPreferredSize(new Dimension(this.img.getIconWidth() + 16, this.img.getIconHeight() + 16));
        } else {
            this.getActions().removeAction(this.resizeAction);
            this.getActions().removeAction(this.moveAction);
            this.getActions().removeAction(this.popupMenuAction);
            this.setBorder(BorderFactory.createEmptyBorder((int)8));
            this.setPreferredSize(new Dimension(this.img.getIconWidth() + 16, this.img.getIconHeight() + 16));
        }
        this.revalidate();
        this.getScene().validate();
    }

    public ImageIcon getImg() {
        return this.img;
    }

    public void setImg(ImageIcon img) {
        this.img = img;
        this.setPreferredBounds(new Rectangle(0, 0, img.getIconWidth() + 16, img.getIconHeight() + 16));
    }

    protected void paintWidget() {
        if (this.img == null) {
            super.paintWidget();
        } else {
            Insets is = this.getBorder().getInsets();
            int x = this.getBounds().x + is.right;
            int y = this.getBounds().y + is.top;
            int w = this.getBounds().width - is.right - is.left;
            int h = this.getBounds().height - is.top - is.bottom;
            Composite oldComposite = this.getGraphics().getComposite();
            this.getGraphics().setComposite(AlphaComposite.getInstance(3, this.getTransparency()));
            this.getGraphics().drawImage(this.img.getImage(), x, y, w, h, null);
            this.getGraphics().setComposite(oldComposite);
        }
    }

    public float getTransparency() {
        return this.transparency;
    }

    public void setTransparency(float transparency) {
        this.transparency = transparency;
        this.repaint();
        this.saveState();
    }

    public boolean isKeepRatio() {
        return this.keepRatio;
    }

    public void setKeepRatio(boolean keepRatio) {
        if (this.keepRatio == keepRatio) {
            return;
        }
        this.keepRatio = keepRatio;
        if (keepRatio && this.getImg() != null) {
            double ratioH = (double)this.getImg().getIconWidth() / (double)this.getImg().getIconHeight();
            double ratioW = (double)this.getImg().getIconHeight() / (double)this.getImg().getIconWidth();
            Rectangle r = this.getBounds();
            if ((double)this.getBounds().width / (double)this.getBounds().height > ratioH) {
                r.height = (int)((double)this.getBounds().width * ratioW);
            } else {
                r.width = (int)((double)this.getBounds().height * ratioH);
            }
            this.setPreferredBounds(r);
            this.getScene().validate();
        }
        this.saveState();
    }

    public void setImageVisible(boolean b) {
        super.setVisible(b);
        if (!b) {
            this.setTransforming(false);
        }
    }

    public void saveState() {
        if (this.getLocation() == null || this.getBounds() == null) {
            return;
        }
        String bounds = this.isVisible() + "," + this.isKeepRatio() + "," + this.getTransparency() + "," + this.getLocation().x + "," + this.getLocation().y + "," + this.getBounds().x + "," + this.getBounds().y + "," + this.getBounds().width + "," + this.getBounds().height;
        ((AbstractReportObjectScene)this.getScene()).getJasperDesign().setProperty("ireport.background.image.properties", bounds);
    }

    public void loadState() {
        String propString = ((AbstractReportObjectScene)this.getScene()).getJasperDesign().getProperty("ireport.background.image.properties");
        if (propString != null) {
            String[] props = propString.split(",");
            int index = 0;
            this.setVisible(Boolean.valueOf(props[index]));
            this.setKeepRatio(Boolean.valueOf(props[++index]));
            this.setTransparency(Float.valueOf(props[++index]).floatValue());
            Point location = new Point(Integer.valueOf(props[++index]), Integer.valueOf(props[++index]));
            Rectangle bounds = new Rectangle(Integer.valueOf(props[++index]), Integer.valueOf(props[++index]), Integer.valueOf(props[++index]), Integer.valueOf(props[++index]));
            this.setPreferredLocation(location);
            this.setPreferredBounds(bounds);
            this.revalidate();
            this.getScene().validate();
        }
    }
}

