/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.preferences;

import java.net.URL;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jboss.tools.project.examples.Messages;
import org.jboss.tools.project.examples.ProjectExamplesActivator;
import org.jboss.tools.project.examples.model.IProjectExampleSite;
import org.jboss.tools.project.examples.model.ProjectExampleSite;
import org.jboss.tools.project.examples.model.ProjectUtil;
import org.jboss.tools.project.examples.model.SiteCategory;
import org.jboss.tools.project.examples.preferences.SiteDialog;
import org.jboss.tools.project.examples.preferences.Sites;

public class ProjectExamplesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button button;
    private Sites sites;
    private TreeViewer viewer;
    private ProjectExampleSite selectedSite;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.button = new Button(composite, 32);
        this.button.setText(Messages.ProjectExamplesPreferencePage_Show_experimental_sites);
        IPreferenceStore store = ProjectExamplesActivator.getDefault().getPreferenceStore();
        this.button.setSelection(store.getBoolean("showExperimentalSites"));
        Group sitesGroup = new Group(composite, 0);
        sitesGroup.setText(Messages.ProjectExamplesPreferencePage_Sites);
        GridLayout gl = new GridLayout(2, false);
        sitesGroup.setLayout((Layout)gl);
        sitesGroup.setLayoutData((Object)new GridData(1808));
        this.viewer = new TreeViewer((Composite)sitesGroup, 2816);
        this.viewer.setContentProvider((IContentProvider)new SitesContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new SitesLabelProvider());
        this.sites = new Sites();
        this.viewer.setInput((Object)this.sites);
        this.viewer.getControl().setLayoutData((Object)new GridData(1808));
        this.viewer.expandAll();
        Composite buttonComposite = new Composite((Composite)sitesGroup, 0);
        buttonComposite.setLayout((Layout)new GridLayout(1, false));
        buttonComposite.setLayoutData((Object)new GridData(4, 128, false, false));
        Button addButton = new Button(buttonComposite, 8);
        addButton.setLayoutData((Object)new GridData(768));
        addButton.setText(Messages.ProjectExamplesPreferencePage_Add);
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                String name;
                SiteDialog dialog = new SiteDialog(ProjectExamplesPreferencePage.this.getShell(), null, ProjectExamplesPreferencePage.this.sites);
                int ok = dialog.open();
                if (ok == 0 && (name = dialog.getName()) != null) {
                    URL url = dialog.getURL();
                    ProjectExampleSite site = new ProjectExampleSite();
                    site.setUrl(url);
                    site.setName(name);
                    site.setEditable(true);
                    ProjectExamplesPreferencePage.this.sites.add(site);
                    ProjectExamplesPreferencePage.this.viewer.refresh();
                }
            }
        });
        final Button editButton = new Button(buttonComposite, 8);
        editButton.setLayoutData((Object)new GridData(768));
        editButton.setText(Messages.ProjectExamplesPreferencePage_Edit);
        editButton.setEnabled(false);
        editButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String name;
                if (ProjectExamplesPreferencePage.this.selectedSite == null) {
                    return;
                }
                SiteDialog dialog = new SiteDialog(ProjectExamplesPreferencePage.this.getShell(), ProjectExamplesPreferencePage.this.selectedSite, ProjectExamplesPreferencePage.this.sites);
                int ok = dialog.open();
                if (ok == 0 && (name = dialog.getName()) != null) {
                    URL url = dialog.getURL();
                    ProjectExampleSite site = ProjectExamplesPreferencePage.this.selectedSite;
                    site.setUrl(url);
                    site.setName(name);
                    site.setEditable(true);
                    ProjectExamplesPreferencePage.this.viewer.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        final Button removeButton = new Button(buttonComposite, 8);
        removeButton.setLayoutData((Object)new GridData(768));
        removeButton.setText(Messages.ProjectExamplesPreferencePage_Remove);
        removeButton.setEnabled(false);
        removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ProjectExamplesPreferencePage.this.selectedSite != null) {
                    ProjectExamplesPreferencePage.this.sites.remove(ProjectExamplesPreferencePage.this.selectedSite);
                    ProjectExamplesPreferencePage.this.viewer.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ITreeSelection treeSelection;
                Object object;
                editButton.setEnabled(false);
                removeButton.setEnabled(false);
                ProjectExamplesPreferencePage.this.selectedSite = null;
                ISelection selection = event.getSelection();
                if (selection instanceof ITreeSelection && (object = (treeSelection = (ITreeSelection)selection).getFirstElement()) instanceof ProjectExampleSite) {
                    ProjectExamplesPreferencePage.this.selectedSite = (ProjectExampleSite)object;
                    boolean editable = ((ProjectExampleSite)object).isEditable();
                    editButton.setEnabled(editable);
                    removeButton.setEnabled(editable);
                }
            }
        });
        return composite;
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        this.button.setSelection(false);
        this.sites.getUserSites().clear();
        this.storeSites();
        super.performDefaults();
    }

    public boolean performOk() {
        this.storeSites();
        return super.performOk();
    }

    private void storeSites() {
        IPreferenceStore store = ProjectExamplesActivator.getDefault().getPreferenceStore();
        store.setValue("showExperimentalSites", this.button.getSelection());
        try {
            String userSites = ProjectUtil.getAsXML(this.sites.getUserSites());
            store.setValue("userSites", userSites);
        }
        catch (Exception e) {
            ProjectExamplesActivator.log(e);
        }
    }

    class SitesContentProvider
    implements ITreeContentProvider {
        SitesContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Sites) {
                return ((Sites)parentElement).getSiteCategories();
            }
            if (parentElement instanceof SiteCategory) {
                return ((SiteCategory)parentElement).getSites().toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof Sites || element instanceof SiteCategory;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class SitesLabelProvider
    extends LabelProvider {
        SitesLabelProvider() {
        }

        public Image getImage(Object element) {
            return super.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof IProjectExampleSite) {
                return ((IProjectExampleSite)element).getName();
            }
            return super.getText(element);
        }
    }
}

