/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.jboss.tools.project.examples.model.Category;
import org.jboss.tools.project.examples.model.ProjectFix;
import org.jboss.tools.project.examples.model.ProjectModelElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Project
implements ProjectModelElement {
    private String name = "";
    private String shortDescription = "";
    private String description = "";
    private String url = "";
    private long size;
    private Category category;
    private List<String> includedProjects;
    private boolean welcome = false;
    private String type;
    private String welcomeURL;
    private String site;
    private List<ProjectFix> fixes = new ArrayList<ProjectFix>();
    private List<ProjectFix> unsatisfiedFixes;

    public Project() {
        this.setCategory(Category.OTHER);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public Category getCategory() {
        return this.category;
    }

    public void setCategory(Category category) {
        this.category = category;
    }

    public String getSizeAsText() {
        String sizeString = "";
        BigDecimal sizeDecimal = new BigDecimal(this.size);
        BigDecimal MB = new BigDecimal(0x100000);
        BigDecimal KB = new BigDecimal(1024);
        sizeString = sizeDecimal.compareTo(MB) > 0 ? String.format("%5.2fM", sizeDecimal.divide(MB)) : (sizeDecimal.compareTo(KB) > 0 ? String.format("%5.2fK", sizeDecimal.divide(KB)) : String.format("%d", this.size));
        return sizeString;
    }

    public List<String> getIncludedProjects() {
        return this.includedProjects;
    }

    public void setIncludedProjects(List<String> includedProjects) {
        this.includedProjects = includedProjects;
    }

    public boolean isWelcome() {
        return this.welcome;
    }

    public void setWelcome(boolean welcome) {
        this.welcome = welcome;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getWelcomeURL() {
        return this.welcomeURL;
    }

    public void setWelcomeURL(String welcomeURL) {
        this.welcomeURL = welcomeURL;
    }

    @Override
    public String getSite() {
        return this.site;
    }

    public void setSite(String site) {
        this.site = site;
    }

    public List<ProjectFix> getFixes() {
        return this.fixes;
    }

    public void setFixes(List<ProjectFix> fixes) {
        this.fixes = fixes;
    }

    public List<ProjectFix> getUnsatisfiedFixes() {
        return this.unsatisfiedFixes;
    }

    public void setUnsatisfiedFixes(List<ProjectFix> unsatisfiedFixes) {
        this.unsatisfiedFixes = unsatisfiedFixes;
    }
}

