/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.filetransfer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLEncoder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.ContainerFactory;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.security.ConnectContextFactory;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.filetransfer.IFileTransferListener;
import org.eclipse.ecf.filetransfer.IIncomingFileTransfer;
import org.eclipse.ecf.filetransfer.IRemoteFile;
import org.eclipse.ecf.filetransfer.IRemoteFileSystemBrowserContainerAdapter;
import org.eclipse.ecf.filetransfer.IRemoteFileSystemListener;
import org.eclipse.ecf.filetransfer.IRetrieveFileTransferContainerAdapter;
import org.eclipse.ecf.filetransfer.IncomingFileTransferException;
import org.eclipse.ecf.filetransfer.RemoteFileSystemException;
import org.eclipse.ecf.filetransfer.UserCancelledException;
import org.eclipse.ecf.filetransfer.events.IFileTransferEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceiveDataEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceiveDoneEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceiveStartEvent;
import org.eclipse.ecf.filetransfer.events.IRemoteFileSystemBrowseEvent;
import org.eclipse.ecf.filetransfer.events.IRemoteFileSystemEvent;
import org.eclipse.ecf.filetransfer.identity.FileCreateException;
import org.eclipse.ecf.filetransfer.identity.FileIDFactory;
import org.eclipse.ecf.filetransfer.service.IRetrieveFileTransferFactory;
import org.eclipse.ecf.provider.filetransfer.retrieve.AbstractRetrieveFileTransfer;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.provisional.p2.core.IServiceUI;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.project.examples.Messages;
import org.jboss.tools.project.examples.ProjectExamplesActivator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class ECFExamplesTransport {
    private static final int LOGIN_RETRIES = 3;
    private static final ProtocolException ERROR_401 = new ProtocolException();
    private static final String SERVER_REDIRECT = Messages.ECFExamplesTransport_Server_redirected_too_many_times;
    public static final String PREFERENCE_NODE = "org.jboss.tools.project.examples";
    public static final String PROP_USERNAME = "username";
    public static final String PROP_PASSWORD = "password";
    private static ECFExamplesTransport INSTANCE;
    private ServiceTracker retrievalFactoryTracker;

    private ECFExamplesTransport() {
    }

    public static synchronized ECFExamplesTransport getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ECFExamplesTransport();
        }
        return INSTANCE;
    }

    public long getLastModified(URL location) throws CoreException {
        String locationString = location.toExternalForm();
        try {
            IConnectContext context = this.getConnectionContext(locationString, false);
            int i = 0;
            while (i < 3) {
                try {
                    return this.doGetLastModified(locationString, context);
                }
                catch (ProtocolException e) {
                    if (ERROR_401 == e) {
                        context = this.getConnectionContext(locationString, true);
                    }
                }
                catch (Exception e) {
                    e.getMessage();
                }
                ++i;
            }
        }
        catch (UserCancelledException userCancelledException) {
            throw new OperationCanceledException();
        }
        throw new CoreException((IStatus)new Status(4, PREFERENCE_NODE, Messages.ECFExamplesTransport_IO_error, null));
    }

    private long doGetLastModified(String location, IConnectContext context) throws ProtocolException {
        IContainer container;
        try {
            container = ContainerFactory.getDefault().createContainer();
        }
        catch (ContainerCreateException containerCreateException) {
            return 0L;
        }
        IRemoteFileSystemBrowserContainerAdapter adapter = (IRemoteFileSystemBrowserContainerAdapter)container.getAdapter(IRemoteFileSystemBrowserContainerAdapter.class);
        if (adapter == null) {
            return 0L;
        }
        IRemoteFile remoteFile = this.checkFile(adapter, location, context);
        if (remoteFile == null) {
            return 0L;
        }
        return remoteFile.getInfo().getLastModified();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus download(String name, String url, OutputStream destination, IProgressMonitor monitor) {
        try {
            context = this.getConnectionContext(url, false);
            i = 0;
            if (true) ** GOTO lbl43
        }
        catch (UserCancelledException v0) {
            var11_13 = Status.CANCEL_STATUS;
            try {
                destination.close();
                return var11_13;
            }
            catch (IOException v1) {}
            return var11_13;
        }
        catch (CoreException e) {
            try {
                var11_14 = e.getStatus();
            }
            catch (Throwable var10_15) {
                try {
                    destination.close();
                    throw var10_15;
                }
                catch (IOException v2) {}
                throw var10_15;
                do {
                    block23: {
                        try {
                            status = this.performDownload(name, url, destination, context, monitor);
                            if (status.isOK()) {
                                var11_12 = status;
                            }
                            ** GOTO lbl-1000
                        }
                        catch (ProtocolException e) {
                            if (e == ECFExamplesTransport.ERROR_401) {
                                context = this.getConnectionContext(url, true);
                            }
                            break block23;
                        }
                        try {
                            destination.close();
                            return var11_12;
                        }
                        catch (IOException v3) {}
                        return var11_12;
lbl-1000:
                        // 1 sources

                        {
                            exception = status.getException();
                            if (!(exception instanceof IncomingFileTransferException) || (code = ((IncomingFileTransferException)exception).getErrorCode()) != 401) break block23;
                            context = this.getConnectionContext(url, true);
                        }
                    }
                    ++i;
lbl43:
                    // 2 sources

                } while (i < 3);
            }
            try {
                destination.close();
                return var11_14;
            }
            catch (IOException v4) {}
            return var11_14;
        }
        try {
            destination.close();
            return new Status(4, "org.jboss.tools.project.examples", Messages.ECFExamplesTransport_IO_error, null);
        }
        catch (IOException v5) {}
        return new Status(4, "org.jboss.tools.project.examples", Messages.ECFExamplesTransport_IO_error, null);
    }

    public IStatus performDownload(String name, String toDownload, OutputStream target, IConnectContext context, IProgressMonitor monitor) throws ProtocolException {
        IRetrieveFileTransferFactory factory = (IRetrieveFileTransferFactory)this.getFileTransferServiceTracker().getService();
        if (factory == null) {
            return new Status(4, PREFERENCE_NODE, Messages.ECFExamplesTransport_IO_error);
        }
        return this.transfer(name, (IRetrieveFileTransferContainerAdapter)factory.newInstance(), toDownload, target, context, monitor);
    }

    private IStatus transfer(final String name, IRetrieveFileTransferContainerAdapter retrievalContainer, String toDownload, final OutputStream target, IConnectContext context, final IProgressMonitor monitor) throws ProtocolException {
        Object[] result = new IStatus[1];
        IFileTransferListener listener = new IFileTransferListener((IStatus[])result){
            private long transferStartTime;
            protected int oldWorked;
            private final /* synthetic */ IStatus[] val$result;
            {
                this.val$result = iStatusArray;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            public void handleTransferEvent(IFileTransferEvent event) {
                long totalWork2;
                long fileLength;
                if (event instanceof IIncomingFileTransferReceiveStartEvent) {
                    IIncomingFileTransferReceiveStartEvent rse = (IIncomingFileTransferReceiveStartEvent)event;
                    try {
                        if (target != null) {
                            rse.receive(target);
                            this.transferStartTime = System.currentTimeMillis();
                        }
                        if (monitor != null) {
                            fileLength = rse.getSource().getFileLength();
                            totalWork2 = fileLength == -1L ? 100L : fileLength;
                            int work = totalWork2 > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)totalWork2;
                            monitor.beginTask(NLS.bind((String)Messages.ECFExamplesTransport_Downloading, (Object)name), work);
                            this.oldWorked = 0;
                        }
                    }
                    catch (IOException e) {
                        IStatus status = ECFExamplesTransport.this.convertToStatus(e);
                        IStatus[] totalWork2 = this.val$result;
                        // MONITORENTER : this.val$result
                        this.val$result[0] = status;
                        this.val$result.notify();
                        // MONITOREXIT : totalWork2
                    }
                }
                if (event instanceof IIncomingFileTransferReceiveDataEvent) {
                    IIncomingFileTransfer source = ((IIncomingFileTransferReceiveDataEvent)event).getSource();
                    if (monitor != null) {
                        if (monitor.isCanceled()) {
                            source.cancel();
                            return;
                        }
                        fileLength = source.getFileLength();
                        totalWork2 = fileLength == -1L ? 100L : fileLength;
                        double factor = totalWork2 > Integer.MAX_VALUE ? 2.147483647E9 / (double)totalWork2 : 1.0;
                        long received = source.getBytesReceived();
                        int worked = (int)Math.round(factor * (double)received);
                        double downloadRateBytesPerSecond = (double)received / ((double)(System.currentTimeMillis() + 1L - this.transferStartTime) / 1000.0);
                        String downloadRateString = AbstractRetrieveFileTransfer.toHumanReadableBytes((double)downloadRateBytesPerSecond);
                        String receivedString = AbstractRetrieveFileTransfer.toHumanReadableBytes((double)received);
                        String fileLengthString = AbstractRetrieveFileTransfer.toHumanReadableBytes((double)fileLength);
                        monitor.subTask(NLS.bind((String)Messages.ECFExamplesTransport_ReceivedSize_Of_FileSize_At_RatePerSecond, (Object[])new String[]{receivedString, fileLengthString, downloadRateString}));
                        monitor.worked(worked - this.oldWorked);
                        this.oldWorked = worked;
                    }
                }
                if (!(event instanceof IIncomingFileTransferReceiveDoneEvent)) return;
                Exception exception = ((IIncomingFileTransferReceiveDoneEvent)event).getException();
                IStatus status = ECFExamplesTransport.this.convertToStatus(exception);
                IStatus[] iStatusArray = this.val$result;
                // MONITORENTER : this.val$result
                this.val$result[0] = status;
                this.val$result.notify();
                // MONITOREXIT : iStatusArray
                return;
            }
        };
        try {
            retrievalContainer.setConnectContextForAuthentication(context);
            retrievalContainer.sendRetrieveRequest(FileIDFactory.getDefault().createFileID(retrievalContainer.getRetrieveNamespace(), toDownload), listener, null);
        }
        catch (IncomingFileTransferException e) {
            IStatus status = e.getStatus();
            Throwable exception = status.getException();
            if (exception instanceof IOException && exception.getMessage() != null && (exception.getMessage().indexOf("401") != -1 || exception.getMessage().indexOf(SERVER_REDIRECT) != -1)) {
                throw ERROR_401;
            }
            return status;
        }
        catch (FileCreateException e) {
            return e.getStatus();
        }
        this.waitFor(toDownload, result);
        return result[0];
    }

    private IRemoteFile checkFile(IRemoteFileSystemBrowserContainerAdapter retrievalContainer, String location, IConnectContext context) throws ProtocolException {
        IOException ioException;
        String message;
        final Object[] result = new Object[2];
        final Object FAIL = new Object();
        IRemoteFileSystemListener listener = new IRemoteFileSystemListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void handleRemoteFileEvent(IRemoteFileSystemEvent event) {
                Exception exception = event.getException();
                if (exception != null) {
                    Object[] objectArray = result;
                    synchronized (result) {
                        result[0] = FAIL;
                        result[1] = exception;
                        result.notify();
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return;
                    }
                }
                if (!(event instanceof IRemoteFileSystemBrowseEvent)) return;
                IRemoteFileSystemBrowseEvent fsbe = (IRemoteFileSystemBrowseEvent)event;
                IRemoteFile[] remoteFiles = fsbe.getRemoteFiles();
                if (remoteFiles != null && remoteFiles.length > 0 && remoteFiles[0] != null) {
                    Object[] objectArray = result;
                    synchronized (result) {
                        result[0] = remoteFiles[0];
                        result.notify();
                        // ** MonitorExit[var5_6] (shouldn't be in output)
                        return;
                    }
                }
                Object[] objectArray = result;
                synchronized (result) {
                    result[0] = FAIL;
                    result.notify();
                    // ** MonitorExit[var5_7] (shouldn't be in output)
                    return;
                }
            }
        };
        try {
            retrievalContainer.setConnectContextForAuthentication(context);
            retrievalContainer.sendBrowseRequest(FileIDFactory.getDefault().createFileID(retrievalContainer.getBrowseNamespace(), location), listener);
        }
        catch (RemoteFileSystemException remoteFileSystemException) {
            return null;
        }
        catch (FileCreateException fileCreateException) {
            return null;
        }
        this.waitFor(location, result);
        if (result[0] == FAIL && result[1] instanceof IOException && (message = (ioException = (IOException)result[1]).getMessage()) != null && (message.indexOf(" 401 ") != -1 || message.indexOf(SERVER_REDIRECT) != -1)) {
            throw ERROR_401;
        }
        if (result[0] instanceof IRemoteFile) {
            return (IRemoteFile)result[0];
        }
        return null;
    }

    public IConnectContext getConnectionContext(String xmlLocation, boolean prompt) throws UserCancelledException, CoreException {
        String nodeKey;
        ISecurePreferences securePreferences = SecurePreferencesFactory.getDefault();
        IPath hostLocation = new Path(xmlLocation).removeLastSegments(1);
        try {
            nodeKey = URLEncoder.encode(hostLocation.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            nodeKey = URLEncoder.encode(hostLocation.toString());
        }
        String nodeName = "org.jboss.tools.project.examples/" + nodeKey;
        ISecurePreferences prefNode = null;
        if (securePreferences.nodeExists(nodeName)) {
            prefNode = securePreferences.node(nodeName);
        }
        if (!prompt) {
            String password;
            String username;
            block18: {
                if (prefNode == null) {
                    return null;
                }
                try {
                    username = prefNode.get(PROP_USERNAME, null);
                    password = prefNode.get(PROP_PASSWORD, null);
                    if (username != null && password != null) break block18;
                    return null;
                }
                catch (StorageException e) {
                    String msg = Messages.ECFExamplesTransport_Internal_Error;
                    throw new CoreException((IStatus)new Status(4, PREFERENCE_NODE, msg, (Throwable)e));
                }
            }
            return ConnectContextFactory.createUsernamePasswordConnectContext((String)username, (Object)password);
        }
        Bundle bundle = Platform.getBundle((String)"org.eclipse.equinox.p2.ui.sdk");
        if (bundle != null && bundle.getState() != 32) {
            try {
                bundle.start();
            }
            catch (BundleException bundleException) {}
        }
        ServiceTracker adminUITracker = new ServiceTracker(ProjectExamplesActivator.getBundleContext(), IServiceUI.class.getName(), null);
        adminUITracker.open();
        IServiceUI adminUIService = (IServiceUI)adminUITracker.getService();
        IServiceUI.AuthenticationInfo loginDetails = null;
        if (adminUIService != null) {
            loginDetails = adminUIService.getUsernamePassword(hostLocation.toString());
        }
        if (loginDetails == null) {
            throw new UserCancelledException();
        }
        if (loginDetails.saveResult()) {
            if (prefNode == null) {
                prefNode = securePreferences.node(nodeName);
            }
            try {
                prefNode.put(PROP_USERNAME, loginDetails.getUserName(), true);
                prefNode.put(PROP_PASSWORD, loginDetails.getPassword(), true);
                prefNode.flush();
            }
            catch (StorageException e1) {
                String msg = Messages.ECFExamplesTransport_Internal_Error;
                throw new CoreException((IStatus)new Status(4, PREFERENCE_NODE, msg, (Throwable)e1));
            }
            catch (IOException e) {
                String msg = Messages.ECFExamplesTransport_Internal_Error;
                throw new CoreException((IStatus)new Status(4, PREFERENCE_NODE, msg, (Throwable)e));
            }
        }
        return ConnectContextFactory.createUsernamePasswordConnectContext((String)loginDetails.getUserName(), (Object)loginDetails.getPassword());
    }

    private IStatus convertToStatus(Exception e) {
        if (e == null) {
            return Status.OK_STATUS;
        }
        if (e instanceof UserCancelledException) {
            return new Status(8, PREFERENCE_NODE, e.getMessage(), (Throwable)e);
        }
        return new Status(4, PREFERENCE_NODE, e.getMessage(), (Throwable)e);
    }

    private void waitFor(String location, Object[] barrier) {
        WaitJob wait = new WaitJob(location, barrier);
        wait.schedule();
        while (barrier[0] == null) {
            boolean logged = false;
            try {
                wait.join();
            }
            catch (InterruptedException e) {
                if (logged) continue;
                ProjectExamplesActivator.log(e);
            }
        }
    }

    private synchronized ServiceTracker getFileTransferServiceTracker() {
        if (this.retrievalFactoryTracker == null) {
            this.retrievalFactoryTracker = new ServiceTracker(ProjectExamplesActivator.getBundleContext(), IRetrieveFileTransferFactory.class.getName(), null);
            this.retrievalFactoryTracker.open();
            this.startBundle("org.eclipse.ecf");
            this.startBundle("org.eclipse.ecf.provider.filetransfer");
        }
        return this.retrievalFactoryTracker;
    }

    private boolean startBundle(String bundleId) {
        PackageAdmin packageAdmin = (PackageAdmin)ServiceHelper.getService((BundleContext)ProjectExamplesActivator.getBundleContext(), (String)PackageAdmin.class.getName());
        if (packageAdmin == null) {
            return false;
        }
        Bundle[] bundles = packageAdmin.getBundles(bundleId, null);
        if (bundles != null && bundles.length > 0) {
            int i = 0;
            while (i < bundles.length) {
                try {
                    if ((bundles[0].getState() & 2) == 0) {
                        bundles[0].start();
                        return true;
                    }
                }
                catch (BundleException bundleException) {}
                ++i;
            }
        }
        return false;
    }

    public static Object getService(BundleContext context, String name) {
        if (context == null) {
            return null;
        }
        ServiceReference reference = context.getServiceReference(name);
        if (reference == null) {
            return null;
        }
        Object result = context.getService(reference);
        context.ungetService(reference);
        return result;
    }

    static class WaitJob
    extends Job {
        private final Object[] barrier;

        WaitJob(String location, Object[] barrier) {
            super(Messages.ECFExamplesTransport_Loading);
            this.barrier = barrier;
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected IStatus run(IProgressMonitor monitor) {
            Object[] objectArray = this.barrier;
            synchronized (this.barrier) {
                while (true) {
                    if (this.barrier[0] != null) {
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return Status.OK_STATUS;
                    }
                    try {
                        this.barrier.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }
}

