/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ant;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.DirSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.PatternSet;
import org.codehaus.groovy.ant.LoggingHelper;
import org.codehaus.groovy.tools.groovydoc.ClasspathResourceManager;
import org.codehaus.groovy.tools.groovydoc.FileOutputTool;
import org.codehaus.groovy.tools.groovydoc.GroovyDocTool;

public class Groovydoc
extends Task {
    private final LoggingHelper log = new LoggingHelper(this);
    private Path sourcePath;
    private File destDir;
    private List packageNames;
    private List excludePackageNames;
    private String windowTitle;
    private boolean privateScope = false;
    private boolean useDefaultExcludes = true;
    private boolean includeNoSourcePackages = false;
    private List packageSets;
    private List sourceFilesToDoc;
    private List links = new ArrayList();

    public Groovydoc() {
        this.packageNames = new ArrayList();
        this.excludePackageNames = new ArrayList();
        this.packageSets = new ArrayList();
        this.sourceFilesToDoc = new ArrayList();
    }

    public void setSourcepath(Path src) {
        if (this.sourcePath == null) {
            this.sourcePath = src;
        } else {
            this.sourcePath.append(src);
        }
    }

    public void setDestdir(File dir) {
        this.destDir = dir;
    }

    public void setPackagenames(String packages) {
        StringTokenizer tok = new StringTokenizer(packages, ",");
        while (tok.hasMoreTokens()) {
            String packageName = tok.nextToken();
            this.packageNames.add(packageName);
        }
    }

    public void setUse(boolean b) {
    }

    public void setWindowtitle(String title) {
        this.windowTitle = title;
    }

    public void setPrivate(boolean b) {
        this.privateScope = b;
    }

    private void parsePackages(List resultantPackages, Path sp) {
        ArrayList<String> addedPackages = new ArrayList<String>();
        ArrayList<DirSet> dirSets = new ArrayList<DirSet>(this.packageSets);
        if (this.sourcePath != null) {
            String pkg;
            PatternSet ps = new PatternSet();
            if (this.packageNames.size() > 0) {
                for (String p : this.packageNames) {
                    pkg = p.replace('.', '/');
                    if (pkg.endsWith("*")) {
                        pkg = pkg + "*";
                    }
                    ps.createInclude().setName(pkg);
                }
            } else {
                ps.createInclude().setName("**");
            }
            for (String p : this.excludePackageNames) {
                pkg = p.replace('.', '/');
                if (pkg.endsWith("*")) {
                    pkg = pkg + "*";
                }
                ps.createExclude().setName(pkg);
            }
            String[] pathElements = this.sourcePath.list();
            for (int i = 0; i < pathElements.length; ++i) {
                File dir = new File(pathElements[i]);
                if (dir.isDirectory()) {
                    DirSet ds = new DirSet();
                    ds.setDefaultexcludes(this.useDefaultExcludes);
                    ds.setDir(dir);
                    ds.createPatternSet().addConfiguredPatternset(ps);
                    dirSets.add(ds);
                    continue;
                }
                this.log.warn("Skipping " + pathElements[i] + " since it is no directory.");
            }
        }
        for (DirSet ds : dirSets) {
            File baseDir = ds.getDir(this.getProject());
            this.log.debug("scanning " + baseDir + " for packages.");
            DirectoryScanner dsc = ds.getDirectoryScanner(this.getProject());
            String[] dirs = dsc.getIncludedDirectories();
            boolean containsPackages = false;
            for (int i = 0; i < dirs.length; ++i) {
                File pd = new File(baseDir, dirs[i]);
                String[] files = pd.list(new FilenameFilter(){

                    public boolean accept(File dir1, String name) {
                        return name.endsWith(".java") || name.endsWith(".groovy") || name.endsWith(".gv") || name.endsWith(".gvy") || name.endsWith(".gsh") || Groovydoc.this.includeNoSourcePackages && name.equals("package.html");
                    }
                });
                for (String filename : Arrays.asList(files)) {
                    this.sourceFilesToDoc.add(dirs[i] + File.separator + filename);
                }
                if (files.length <= 0) continue;
                if ("".equals(dirs[i])) {
                    this.log.warn(baseDir + " contains source files in the default package," + " you must specify them as source files" + " not packages.");
                    continue;
                }
                containsPackages = true;
                String packageName = dirs[i].replace(File.separatorChar, '.');
                if (addedPackages.contains(packageName)) continue;
                addedPackages.add(packageName);
                resultantPackages.add(packageName);
            }
            if (containsPackages) {
                sp.createPathElement().setLocation(baseDir);
                continue;
            }
            this.log.verbose(baseDir + " doesn't contain any packages, dropping it.");
        }
    }

    public void execute() throws BuildException {
        ArrayList packagesToDoc = new ArrayList();
        Path sourceDirs = new Path(this.getProject());
        if (this.sourcePath != null) {
            sourceDirs.addExisting(this.sourcePath);
        }
        this.parsePackages(packagesToDoc, sourceDirs);
        GroovyDocTool htmlTool = new GroovyDocTool(new ClasspathResourceManager(), this.sourcePath, new String[]{"org/codehaus/groovy/tools/groovydoc/gstring-templates/top-level/index.html", "org/codehaus/groovy/tools/groovydoc/gstring-templates/top-level/overview-frame.html", "org/codehaus/groovy/tools/groovydoc/gstring-templates/top-level/allclasses-frame.html", "org/codehaus/groovy/tools/groovydoc/gstring-templates/top-level/overview-summary.html", "org/codehaus/groovy/tools/groovydoc/gstring-templates/top-level/stylesheet.css"}, new String[]{"org/codehaus/groovy/tools/groovydoc/gstring-templates/package-level/package-frame.html", "org/codehaus/groovy/tools/groovydoc/gstring-templates/package-level/package-summary.html"}, new String[]{"org/codehaus/groovy/tools/groovydoc/gstring-templates/class-level/classDocName.html"}, this.links);
        try {
            htmlTool.add(this.sourceFilesToDoc);
            FileOutputTool output = new FileOutputTool();
            htmlTool.renderToOutput(output, this.destDir.getCanonicalPath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public LinkArgument createLink() {
        LinkArgument la = new LinkArgument();
        this.links.add(la);
        return la;
    }

    public static class LinkArgument {
        private String href;
        private String packages;

        public String getPackages() {
            return this.packages;
        }

        public void setPackages(String packages) {
            this.packages = packages;
        }

        public String getHref() {
            return this.href;
        }

        public void setHref(String hr) {
            this.href = hr;
        }
    }
}

