using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;

namespace Oratorio
{
    public class ProgramException : Exception
    {
        public ProgramException(string message)
            : base(message)
        {
        }
        public ProgramException(string message, Exception innerException)
            : base(message, innerException)
        {
        }

        public void Report(Form form)
        {
			System.Diagnostics.Debug.WriteLine(this.ToString());
            string sMessage = Message;
            if (GetBaseException() != null)
            {
                sMessage += "\r\n";
                sMessage += GetBaseException().Message;
            }
            MessageBox.Show(sMessage, Application.ProductName);
        }
    }
}
