using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Xml;

namespace Oratorio
{

    public class ConnectSettingStore : List<ConnectSettingData>
    {
        protected string _settingPath;

        protected const string PREFIX_CONNECT = "connect";
        protected const string FILE_NAME = "connect.config";

        protected readonly string _settingNode;
        protected readonly string _settingFolder;
        protected Properties.ApplicationSettingsConverter _converter = new Properties.ApplicationSettingsConverter();

        public ConnectSettingStore()
        {
            _settingNode = GetType().Name;
            _settingFolder = new Properties.ApplicationSettingsProvider().SettingFolder;
            _settingPath = Path.Combine(_settingFolder, FILE_NAME);
        }

        public string SettingPath
        {
            get { return _settingPath; }
//            set { _settingPath = value; }
        }

        public string SettingFolder
        {
            get { return _settingFolder; }
        }
	

        public void Load()
        {
            XmlDocument doc = new XmlDocument();
            doc.Load(_settingPath);

            IDictionary<string, string> settings = null;
            _converter.ConvertXmlToSettings(doc, _settingNode, out settings);
            for (int index = 0; ; index++)
            {
                string nameKey = PREFIX_CONNECT + "." + index.ToString() + "." + ConnectSettingData.KEY_SETTING_NAME;
                if (!settings.ContainsKey(nameKey) || settings[nameKey].Length == 0)
                {
                    break;
                }

                ConnectSettingData data = new ConnectSettingData();
                Dictionary<string, string> values = new Dictionary<string, string>();
                string[] keys = ConnectSettingData.GetKeyArray();
                //    ConnectSettingData.KEY_SETTING_NAME,
                //    ConnectSettingData.KEY_UID,
                //    ConnectSettingData.KEY_PWD,
                //    ConnectSettingData.KEY_DRIVER,
                //    ConnectSettingData.KEY_DATABASE,
                //    ConnectSettingData.KEY_SERVER,
                //    ConnectSettingData.KEY_DBQ,
                //    ConnectSettingData.KEY_DSN,
                //    ConnectSettingData.KEY_SETTING_METHOD,
                //    ConnectSettingData.KEY_PORT,
                //};
                foreach (string keyName in keys)
                {
//                    data.Remove(key);
                    string itemKey = PREFIX_CONNECT + "." + index.ToString() + "." + keyName;
                    if (settings.ContainsKey(itemKey))
                    {
                        string keyValue = settings[itemKey];
                        if (keyName == ConnectSettingData.KEY_PWD)
                        {
                            keyValue = encodePassword(keyValue);
                        }
                        data[keyName] = keyValue;
                        //data.Add(key, settings[key2]);
                    }
                    else
                    {
                        data[keyName] = "";
                        //data.Add(key, "");
                    }
                }
                this.Add(data);
            }
        }

        public void Save()
        {
            Dictionary<string, string> settings = new Dictionary<string, string>();
            int index = 0;
            foreach (ConnectSettingData data in this)
            {
                if (data.IsUnsaveCert())
                {
                    data.Uid = "";
                    data.Pwd = "";
                }
                foreach (KeyValuePair<string, string> item in data)
                {
                    string value = item.Value;
                    if (item.Key == ConnectSettingData.KEY_PWD)
                    {
                        value = encodePassword(value);
                    }
                    settings[PREFIX_CONNECT + "." + index.ToString() + "." + item.Key] = value;
                }
                index++;
            }

            if (!Directory.Exists(SettingFolder))
            {
                Directory.CreateDirectory(SettingFolder);
            }

            XmlDocument doc = _converter.ConvertSettingsToXml(settings, _settingNode);
            doc.Save(_settingPath);
        }

        protected static string encodePassword(string sPass)
        {
            string sResult = "";
            char[] chs = sPass.ToCharArray();
            for (int nLoop = 0; nLoop < chs.Length; nLoop++)
            {
                char nChar = chs[nLoop];
                if(nChar >= 0x21 && nChar <= 0x7E)
                {
                    nChar += (char)47;
                    if(nChar > 0x7E)
                    {
                        nChar -= (char)94;
                    }
                }
//                sResult += String.fromCharCode(nChar);
                sResult += nChar;
            }
            return sResult;
        }

    }
}
