#!

@cpps	= <*.cpp>;
push(@cpps,<../libcommon/*.cpp>);
for(@cpps){
	$obj = $_;
	/([\w\-\.]+)\.cpp$/;
	$obj{$_}=$1.".o";
}

for(sort(keys %obj)){
	open(FILE,"gcc -MM -I ../include $_ |");
	push(@lines,<FILE>);
	close(FILE);
	push(@lines,"\t\$(CC) \$(CF64) \$(CFBASE) \$(CFINCLUDE) -o $obj{$_} $_ \n\n");
}

@nasms	= <*.nas>;
for(@nasms){
	$obj = $_;
	/([\w\-\.]+)\.nas$/;
	$nobj{$_}=$1.".o";
}
for(sort(keys %nobj)){
	push(@lines,"\n$nobj{$_}: $obj \n\tyasm -m amd64 -f elf -o $nobj{$_} $_ \n\n");
}

open(FILE,">Makefile");
binmode(FILE);
print FILE <<EOT;
include ../user/Makefile.inc

CFINCLUDE	= -I../include

EOT
print FILE "../lib/pekoe64.a:\t" . join("\\\n\t",sort(values %obj)). "\\\n\t". join("\\\n\t",sort(values %nobj)) . "\n\t\$(AR) r ../lib/pekoe64.a ./*.o\n\n";
print FILE "clean:\n\t-rm -f *.o\n\n";
print FILE @lines;
close(FILE);
