//
//	OrangePekoe Leaf API
//
//	(c)2004 The OrangePekoe project
//

#ifndef	_LEAFAPI_H_
#define	_LEAFAPI_H_

typedef uint64	time64_t;

//	CRT
extern "C"{
#define	main64	main
extern	pvoid	native_api;
void*	malloc(size_t);
void	free(void*);
}
inline	void*	operator new(size_t n){return malloc(n);}
inline	void	operator delete(void* p){free(p);}
inline	void*	operator new[](size_t n){return malloc(n);}
inline	void	operator delete[](void* p){free(p);}

#ifdef _PEKOE32_
extern "C"{
uint64	pekoe_syscall(uint,...);
}
#else
extern "C++"{
uint64	pekoe_syscall(uint);
uint64	pekoe_syscall(uint,intptr);
uint64	pekoe_syscall(uint,intptr,intptr);
uint64	pekoe_syscall(uint,intptr,intptr,intptr);
uint64	pekoe_syscall(uint,intptr,intptr,intptr,intptr);
}
#endif


//	KERNEL MODE SPINLOCK
struct KMODE_SPINLOCK{
	intptr	lock;
};

//	RAISE NATIVE EXCEPTION
struct NATIVE_EXCEPTION_PARAM {
#ifdef _PEKOE64_
	intptr	save_cr2;
	intptr	rax,rcx,rdx,rbx,rbp,rsi,rdi,r8,r9,r10,r11,r12,r13,r14,r15;
	intptr	intnum,errcode,rip,cs,rflags,rsp,ss;
#else
	intptr	save_cr2;
	intptr	edi,esi,ebp,padding,ebx,edx,ecx,eax,es,ds;
	intptr	intnum,errcode,eip,cs,eflags,esp,ss;
#endif
};

//	BIOS Service
struct CALLBIOSPARAM {
	uint32	intnum;
	uint32	eax,ecx,edx,ebx,ebp,esi,edi;
	uint16	es,ds;
	uint32	eflags;
};


//	FILESYSTEM
struct CALLFS_OPEN {
	intptr	fscmd;
	intptr	device;
	intptr	index;
};
struct CALLFS_IOCTL {
	intptr	fscmd;
	intptr	device;
	intptr	ioctl_cmd,length;
	pvoid	data;
};
struct CALLFS_DTX {
	intptr	fscmd;
	intptr	device;
	intptr	index,offset;
	pvoid	data;
	intptr	count;
};
enum {
	devcall_open=0,		//	CALLFS_OPEN
	devcall_close,		//	CALLFS_OPEN
	devcall_ioctl,		//	CALLFS_IOCTL
	devcall_read,		//	CALLFS_DTX
	devcall_write,		//	CALLFS_DTX
	devcall_read_dir,	//	CALLFS_DTX
};
enum {
	ioctl_reset_device=0,	//	ALL DEVICE
	ioctl_read_toc,			//	FS ONLY
	ioctl_get_information,	//	ALL DEVICE
	ioctl_sync,				//	FS/STORAGE
};
struct record_info{
	uint64	nTotalRecords;
	uint32	BytesParRecord;
	uint32	reserved1;
	uint64	nFreeRecords;
	uint64	NextRecord;
};
struct volume_info{
	uint64	nTotalSector;
	uint32	BytesParSector;
	uint32	reserved1;
	uint64	reserved2;
	uint64	FirstRecord;
	record_info	records;
};
struct readdir_t{
	uint8	raw[32];
	uint32	attr;
	uint32	devid;
	uint64	index;
	uint64	size;
	time64_t	cdate,adate,mdate;
	uint64	fp;					// in FCB only
	uint32	BytesParRecord;		// in FCB only
	uint32	nReferenceCounter;	// in FCB only
	char	filename[32];
};


//	Graphics Server
struct	GSSTATUS{
	uint8	bpp,flags;
	uint16	width,height,length;
	byte*	framebuffer;
#if _PEKOE_BIT_WIDTH_<64
	uint32	reserved;
#endif
};

struct SYS_READ_CLOCK{
	uint8	sec,min,hour,date,month,year;
	uint8	padding[2];
};

struct VESALIST{
	uint16	mode;
	uint8	bpp,padding;
	uint16	x,y;
};

//	virtual alloc
enum{
	MEM_COMMIT		= 0x0001,
	MEM_RESERVE		= 0x0002,
	MEM_DECOMMIT	= 0x0004,
	MEM_RELEASE		= 0x0008,
};

inline	void	sys_yield(void){ pekoe_syscall(0x0000); }
inline	void	sys_wait(void){ pekoe_syscall(0x0001); }
inline	void	sys_sleep(intptr ms){ pekoe_syscall(0x0002,ms); }
inline	uint32	sys_get_tick_count(void){ return pekoe_syscall(0x0003); }
inline	uint64	sys_get_tick_count64(void){ return pekoe_syscall(0x0003); }
inline	int		sys_try_to_acquire_spinlock(KMODE_SPINLOCK* p){ return pekoe_syscall(0x0004,(intptr)p); }
inline	void	sys_acquire_spinlock(KMODE_SPINLOCK* p){ pekoe_syscall(0x0005,(intptr)p); }
inline	void	sys_release_spinlock(KMODE_SPINLOCK* p){ p->lock=0; } /* 6 */
inline	void	sys_beep(uint32 sw){ pekoe_syscall(0x0007,sw); }
#ifdef __UNSAFE__
inline	pvoid	sys_install_pal(){ return (pvoid)(intptr)pekoe_syscall(0x0008); }
inline	void	sys_set_idt(uint8 n,void(*p)(),uint32 a){ pekoe_syscall(0x0009,n,(intptr)p,a); }
inline	void	sys_enable_irq(uint8 ir,void(*p)()){ pekoe_syscall(0x000A,ir,(intptr)p); }
inline	void	sys_disable_irq(uint8 ir){ pekoe_syscall(0x000B); }
inline	void	sys_reflect_irq(uint8 ir){ pekoe_syscall(0x000C); }
#endif
inline	intptr	sys_get_memory_status(int t){ return pekoe_syscall(0x000D,t); }
#ifdef __UNSAFE__
inline	void	sys_hook_syscall(int f,void**p){ pekoe_syscall(0x000E,f,(intptr)p); }
inline	void	sys_hook_syscall(int f,void*p,void *q){ pekoe_syscall(0x000E,f,(intptr)p,(intptr)q); }
inline	void	sys_start_kernel(){ pekoe_syscall(0x000F); }
inline	int		sys_raise_pid(){ pekoe_syscall(0x0010); }
inline	void	sys_terminate(int pid){ pekoe_syscall(0x0011,pid); }
inline	pvoid	sys_alloc_page(size_t n){ return(pvoid)pekoe_syscall(0x0012,n); }
inline	void	sys_free_page(pvoid p){ pekoe_syscall(0x0013,(intptr)p); }
inline	pvoid	sys_alloc_system_resource(size_t n){ return(pvoid)pekoe_syscall(0x0014,n); }
#endif
inline	intptr	sys_virtual_protect(pvoid addr,intptr size,uint protect)
	{ return pekoe_syscall(0x0015,(intptr)addr,size,protect); }
inline	pvoid	sys_virtual_alloc(pvoid addr,intptr size,uint type,uint protect)
	{ return(pvoid)(intptr)pekoe_syscall(0x0016,(intptr)addr,size,type,protect); }
inline	void	sys_ginit(void){ pekoe_syscall(0x001D); }
inline	uint64	sys_get_version(void){ return pekoe_syscall(0x001E); }
inline	void	sys_raise_exception(NATIVE_EXCEPTION_PARAM* p){ pekoe_syscall(0x001F,(intptr)p); }
inline	void	sys_set_color(int d){ pekoe_syscall(0x0020,d); }
inline	void	sys_set_color(int f,int b){ pekoe_syscall(0x0020,f+b*16); }
inline	void	sys_clearconsole(void){ pekoe_syscall(0x0021); }
inline	void	sys_set_cursor(uint32 d){ pekoe_syscall(0x0022,d); }
inline	void	sys_set_cursor(int x,int y){ pekoe_syscall(0x0022,x+(y<<16)); }
inline	intptr	sys_call_filesys(void* fs){ return pekoe_syscall(0x0023,(intptr)fs); }
#ifdef __UNSAFE__
inline	void	sys_callbios(CALLBIOSPARAM* cb){ pekoe_syscall(0x0024,(intptr)cb); }
inline	int		sys_register_class(uint devid,void* p){ return pekoe_syscall(0x0025,devid,(intptr)p); }
#endif
inline	void	sys_powerdown(void){ pekoe_syscall(0x0026); }
inline	void	sys_reboot(void){ pekoe_syscall(0x0027); }
#ifdef __UNSAFE__
inline	pvoid	sys_alloc_firstfit(size_t n){ return (pvoid)(intptr)pekoe_syscall(0x0028,n); }
inline	pvoid	sys_realloc_firstfit(pvoid p,size_t n){ return (pvoid)(intptr)pekoe_syscall(0x0029,(intptr)p,n); }
inline	pvoid	sys_alloc_real(size_t n){ return (pvoid)(intptr)pekoe_syscall(0x002A,n); }
inline	void	sys_free_real(pvoid p){ pekoe_syscall(0x002B,(intptr)p); }
inline	void	sys_select_memory_map(uint map){ pekoe_syscall(0x002C,map); }
inline	uint	sys_get_current_memory_map(void){ return pekoe_syscall(0x002D); }
#endif
inline	pvoid	sys_access_memstat(void){ return (pvoid)(intptr)pekoe_syscall(0x002E); }
inline	intptr	sys_get_physical_address(pvoid p){ return pekoe_syscall(0x002F,(intptr)p); }
inline	byte*	sys_read_rom_font(void){ return (byte*)(intptr)pekoe_syscall(0x0030); }
#ifdef __UNSAFE__
inline	int		sys_gs_register_server(void* p,void* q){ return pekoe_syscall(0x0031,(intptr)p,(intptr)q); }
#endif
#ifdef _PEKOE64_
inline	int		sys_gs_set_mode(int w,int h,uint8 bpp){ return pekoe_syscall(0x0032,(intptr)((uint64)h<<32)+(w<<16)+(bpp)); }
inline	int		sys_gs_set_mode(GSSTATUS* p){ return pekoe_syscall(0x0032,*(uint64*)p); }
#else
inline	int		sys_gs_set_mode(int w,int h,uint8 bpp){ return pekoe_syscall(0x0032,0,w,h,bpp); }
inline	int		sys_gs_set_mode(GSSTATUS* p){ return pekoe_syscall(0x0032,p); }
#endif
inline	int		sys_gs_get_status(GSSTATUS* p){ return pekoe_syscall(0x0033,(intptr)p); }
inline	int		sys_gs_draw_pixel(int x,int y){ return pekoe_syscall(0x0034,x,y); }
inline	int		sys_gs_set_pixel_RGB(int x,int y,uint32 color){ return pekoe_syscall(0x0035,x,y,color); }
inline	int		sys_gs_set_pixel(int x,int y,uint8 color){ return pekoe_syscall(0x0036,x,y,color); }
inline	VESALIST*	sys_get_vesa_list(){ return (VESALIST*)(intptr)pekoe_syscall(0x003A); }
inline	int		sys_gs_send_packet(void*gbc){ return pekoe_syscall(0x003B,(intptr)gbc); }
inline	int		sys_nls_get_codepage(){ return pekoe_syscall(0x003C,0x00); }
inline	int		sys_nls_set_codepage(int cp){ return pekoe_syscall(0x003C,0x01,cp); }
inline	uint32	sys_nls_convert_ucs_to_oem(int cp,uint32 code){ return pekoe_syscall(0x003C,0x02,cp,code); }
inline	int		sys_nls_utf8_len(char* s){ return pekoe_syscall(0x003C,0x05,(intptr)s); }
inline	int		sys_nls_utf8_to_ucs2(char* s,short* t,int l){ return pekoe_syscall(0x003C,0x06,(intptr)s,(intptr)t,l); }
inline	uint32	sys_dosx_get_current_drive_devid(){ return pekoe_syscall(0x003F,1,0); }
inline	intptr	sys_dosx_get_current_directory_index(){ return pekoe_syscall(0x003F,1,1); }
#ifdef __UNSAFE__
inline	void	sys_hal_halt_processor(){ pekoe_syscall(0x0041); }
#endif
inline	int		sys_get_current_thread(){ return pekoe_syscall(0x0042); }
//		int		sys_create_thread(){ return pekoe_syscall(0x0043,0,0,0); }
#ifdef __UNSAFE__
inline	pvoid	sys_map_video_memory(intptr base,size_t n){ return (pvoid)(intptr)pekoe_syscall(0x0044,base,n); }
#endif
inline	void	sys_read_clock(SYS_READ_CLOCK* rc){ pekoe_syscall(0x0045,(intptr)rc); }
inline	int		sys_terminate_thread(){ return pekoe_syscall(0x0046); }

#ifdef _PEKOE64_
inline	pvoid	sys_get_address(intptr p){ return (pvoid)(0xFFFFFE0000000000+p); }
#else
inline	pvoid	sys_get_address(intptr p){ return (pvoid)(0xE0000000+p); }
#endif
inline	intptr	sys_get_real_address(pvoid p){ return ((intptr)p&0xFFFFF); }

inline	int	sys_fs_open(uint32 devid,intptr index){
	CALLFS_OPEN param;
	param.fscmd=devcall_open;
	param.device=devid;
	param.index=index;
	return sys_call_filesys(&param);
}
inline	int	sys_fs_close(uint32 devid,intptr index){
	CALLFS_OPEN param;
	param.fscmd=devcall_close;
	param.device=devid;
	param.index=index;
	return sys_call_filesys(&param);
}
inline	int	sys_fs_ioctl(uint32 devid,intptr cmd,intptr length,pvoid data){
	CALLFS_IOCTL param;
	param.fscmd=devcall_ioctl;
	param.device=devid;
	param.ioctl_cmd=cmd;
	param.length=length;
	param.data=data;
	return sys_call_filesys(&param);
}
inline	int	sys_fs_read(uint32 devid,intptr index,intptr offset,pvoid buffer,int count){
	CALLFS_DTX param;
	param.fscmd=devcall_read;
	param.device=devid;
	param.index=index;
	param.offset=offset;
	param.data=buffer;
	param.count=count;
	int err=sys_call_filesys(&param);
	return (err<0)?err:count-param.count;
}
inline	int	sys_fs_write(uint32 devid,intptr index,intptr offset,pvoid buffer,int count){
	CALLFS_DTX param;
	param.fscmd=devcall_write;
	param.device=devid;
	param.index=index;
	param.offset=offset;
	param.data=buffer;
	param.count=count;
	int err=sys_call_filesys(&param);
	return (err<0)?err:count-param.count;
}
inline	int	sys_fs_read_dir(uint32 devid,intptr index,intptr offset,pvoid buffer){
	CALLFS_DTX param;
	param.fscmd=devcall_read_dir;
	param.device=devid;
	param.index=index;
	param.offset=offset;
	param.data=buffer;
	param.count=1;
	return sys_call_filesys(&param);
}

#endif
