//
//	Interface for Pointer Device
//
#ifndef	_I_POINTER_DEVICE_H_
#define	_I_POINTER_DEVICE_H_

#include <pekoe.h>

interface	IPointerDevice;
interface	IPointerEventHandler;
extern	IPointerDevice* getMouseInstance(void);

interface	IPointerDevice {
protected:
	byte*	cursor;
	IPointerEventHandler*	delegate;
	int		left,top,width,height;
	int		x,y;
	uint32	button;
	int		dispflag;
	IPointerDevice():cursor(0),delegate(0),left(0),top(0),width(0),height(0),x(0),y(0),button(0),dispflag(0){}
public:
	virtual	~IPointerDevice()=0;
	virtual	void	hide()=0;
	virtual	void	show()=0;
	inline	int		get_X(){ return x; }
	inline	int		get_Y(){ return y; }
	inline	uint32	get_Button(){ return button; }
	inline	byte*	set_Cursor(byte* p){ return cursor=p; }
	inline	byte*	get_Cursor(){ return cursor; }
	inline	void	set_EventHandler(IPointerEventHandler* p){ delegate=p; }
	inline	void	set_Bound(int x1,int y1){ left=0,top=0,width=x1,height=y1; }
	inline	void	set_Bound(int x1,int y1,int x2,int y2){ left=x1,top=y1,width=x2,height=y2; }
	inline	int		conditionalHide(int x1,int y1,int x2,int y2){
		int oldflag=dispflag;
		if(x>x1-16&&x<x2&&y>y1-16&&y<y2) hide();
		return oldflag;
	}
	inline	int		hideConditional(int x1,int y1,int x2,int y2){ return conditionalHide(x1,y1,x2,y2); }
};

interface	IPointerEventHandler {
public:
	virtual	void OnMove(IPointerDevice* src,int x,int y)=0;
	virtual	void OnButtonDown(IPointerDevice* src,uint32 button,uint32 change)=0;
	virtual	void OnButtonUp(IPointerDevice* src,uint32 button,uint32 change)=0;
};

#endif
