/*!
    \file   string.cpp
    \brief  standard library

    standard library

    Copyright (c) 2002,2003 Higepon and the individuals listed on the ChangeLog entries.
    All rights reserved.
    License=MIT/X Licnese

    \author  HigePon
    \version $Revision: 1.15 $
    \date   create:2002/12/15 update:$Date: 2004/03/18 13:42:26 $
*/
#include <string.h>

/*!
    \brief ltoa
*/
char* ltoa(long value, char* str, int base) {
    static const char xdigit[] = {"0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ"};
    unsigned long ulvalue;
    unsigned int ubase;
    int sign = 0;
    char work[sizeof(long)*8+2];
    char* ps = work + (sizeof(long)*8+1);

    *ps = '\0';
    if (base < 0) {
        ubase = -base;
        if (value < 0) {
            value = -value;
            sign  = -1;
        }
    } else {
        ubase = base;
    }

    ulvalue  = value;
    if (2 <= ubase && ubase <  sizeof(xdigit)) {
        do {
            *--ps = xdigit[(unsigned)(ulvalue % ubase)];
        } while ((ulvalue /= ubase) != 0);
    }

    if (sign < 0)
        *--ps = '-';

	strcpy(str,ps);

    return str;
}
