//
//	stdint.h
//

#ifndef	_STDINT_H_
#define	_STDINT_H_

#include <types.h>

#ifdef __STDC_LIMIT_MACROS
#define	INT8_MIN			-0x80
#define	INT8_MAX			0x7F
#define	UINT8_MAX			0xFF
#define	INT16_MIN			-0x8000
#define	INT16_MAX			0x7FFF
#define	UINT16_MAX			0xFFFF
#define	INT32_MIN			-0x80000000
#define	INT32_MAX			0x7FFFFFFF
#define	UINT32_MAX			0xFFFFFFFF
#define	INT64_MIN			-0x8000000000000000
#define	INT64_MAX			0x7FFFFFFFFFFFFFFF
#define	UINT64_MAX			0xFFFFFFFFFFFFFFFF

#define	INT_LEAST8_MIN		INT_8_MIN
#define	INT_LEAST8_MAX		INT_8_MAX
#define	UINT_LEAST8_MAX		UINT_8_MAX
#define	INT_LEAST16_MIN		INT_16_MIN
#define	INT_LEAST16_MAX		INT_16_MAX
#define	UINT_LEAST16_MAX	UINT_16_MAX
#define	INT_LEAST32_MIN		INT_32_MIN
#define	INT_LEAST32_MAX		INT_32_MAX
#define	UINT_LEAST32_MAX	UINT_32_MAX
#define	INT_LEAST64_MIN		INT_64_MIN
#define	INT_LEAST64_MAX		INT_64_MAX
#define	UINT_LEAST64_MAX	UINT_64_MAX

#ifdef _PEKOE32_
#define	INTPTR_MIN			INT32_MIN
#define	INTPTR_MAX			INT32_MAX
#define	UINTPTR_MAX			UINT32_MAX
#else
#define	INTPTR_MIN			INT64_MIN
#define	INTPTR_MAX			INT64_MAX
#define	UINTPTR_MAX			UINT64_MAX
#endif

#define	INTMAX_MIN			INT64_MIN
#define	INTMAX_MAX			INT64_MAX
#define	UINTMAX_MAX			UINT64_MAX

#define	INT8_C(n)			((int_least8)n)
#define	UINT8_C(n)			((uint_least8)n)
#define	INT16_C(n)			((int_least16)n)
#define	UINT16_C(n)			((uint_least16)n)
#define	INT32_C(n)			((int_least32)n)
#define	UINT32_C(n)			((uint_least32)n)
#define	INT64_C(n)			((int_least64)n)
#define	UINT64_C(n)			((uint_least64)n)
#define	INTMAX_C(n)			((intmax_t)n)
#define	UINTMAX_C(n)		((uintmax_t)n)

#define	SIZE_MAX			UINTMAX_MAX
#endif

typedef	int8	int8_t;
typedef	uint8	uint8_t;
typedef	int16	int16_t;
typedef	uint16	uint16_t;
typedef	int32	int32_t;
typedef	uint32	uint32_t;
typedef	int64	int64_t,uintmax_t;
typedef	uint64	uint64_t,intmax_t;
typedef	sintptr	intptr_t;
typedef	intptr	uintptr_t;

typedef	int8	int_fast8_t;
typedef	int32	int_fast16_t,int_fast32_t;
typedef	int64	int_fast64_t;
typedef	uint8	uint_fast8_t;
typedef	uint32	uint_fast16_t,uint_fast32_t;
typedef	uint64	uint_fast64_t;

typedef	int32	int_least8_t,int_least16_t,int_least32_t;
typedef	int64	int_least64_t;
typedef	uint32	uint_least8_t,uint_least16_t,uint_least32_t;
typedef	uint64	uint_least64_t;

#endif
