/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

//
// ʐUNX
// 
//
//	ύX
//	2004/01/08 VK쐬	T.Nishiki 
//
package jp.co.ntt.lms.xms.framework;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;

import javax.servlet.RequestDispatcher;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import jp.co.ntt.lms.xmo.util.ChangeEncode;
import jp.co.ntt.lms.xmo.util.DebugLog;
import jp.co.ntt.lms.xmo.Environment;
import jp.co.ntt.lms.xms.common.user.User;
import jp.co.ntt.lms.xms.common.util.StringUtil;


/**
 * ʐUNXB<br>
 * ƖȔɌʂɊÂāAU蕪ʂ肵A
 * ̉ʂ𐶐邽߂̃ANVƃtH[hiroI肷B
 * I肵ANVNǍAiroɃtH[hB
 * 
 * @author T.Nishiki
 */
public class XmsScreenControl {

	/**
	 * ʃf[^̏o͐B<br>
	 */
	private static File CSV_OUTPUT_DIR;

	/**
	 * f[^E_E[h̃obt@TCYB<br>
	 */
	private final static int DOWNLOAD_BUFFER_SIZE;

	/**
	 * CjVCUB<br>
	 * statictB[h̏B
	 */
	static {

		DebugLog.write(
			XmsScreenControl.class,
			"HEAD XmsScreenControl.static-initilizer",
			DebugLog.ROW);
		// f[^E_E[h̃obt@TCY
		DOWNLOAD_BUFFER_SIZE = 1024;

		DebugLog.write(
			XmsScreenControl.class,
			"TAIL XmsScreenControl.static-initilizer",
			DebugLog.ROW);
	}

	/**
	 * ʏ̎擾ANVNXNB<br>
	 * sANVNX̂ʐU`t@C擾B
	 * ̂擾łꍇA[hĎsB
	 * iroɃtH[h邩A_E[h{邩𔻒肵A
	 * K؂ȕ@ŏIB
	 * 
	 * @param xmsRequest NGXgEIuWFNgB
	 * @param xmsResponse X|XEIuWFNgB
	 * @throws XmsException ɗOꍇB
	 */
	public void processRequest(XmsRequest xmsRequest, XmsResponse xmsResponse)
		throws XmsException {
		DebugLog.write(
			XmsScreenControl.class,
			"HEAD processRequest()",
			DebugLog.ROW);

		// s鏈iCSVpj
		String mode = null;
		// CSV_E[htrue
		boolean requestCSV = false;
		// NANVNX
		XmsScreenAction action = null;

		HttpServletRequest request = null;
		XmsScreenBean bean = null;

		try {
			request = xmsRequest.getRequest();
			// [h擾ACSV_E[hł΁A
			// t@C̓ǂݍ݁{_E[h݂B			
			mode = xmsRequest.getParameter(Constant.REQUEST_MODE);
			if ((mode != null)
				&& (mode.equals(Constant.REQUEST_VALUE_MODE_CSV))) {
				requestCSV = doRequestCsv(xmsRequest, xmsResponse);
			}
			// CSV_E[hłȂA邢́A
			// vCSV_E[hł͂ȂꍇA
			// ANVNXNB
			if (requestCSV == false) {
				////////////////////////////////////////////////////////////////
				// sNX̑I
				action = getScreenAction(xmsRequest, xmsResponse);
				if (action != null) {
					// s
					action.perform(xmsRequest, xmsResponse);

					// ԋplIuWFNgʏoB
					bean = xmsResponse.getScreenBean();

					// XR[vɂʏIuWFNg̐ݒ
					if (bean != null) {
						request = xmsRequest.getRequest();
						// XR[vZbV̏ꍇ
						if (xmsResponse.getScope() == XmsResponse.SESSION) {
							HttpSession session = request.getSession();
							session.setAttribute(
								xmsResponse.getScreenBeanName(),
								bean);
						}
						// XR[vNGXg̏ꍇ
						else if (
							xmsResponse.getScope() == XmsResponse.REQUEST) {
							request.setAttribute(
								xmsResponse.getScreenBeanName(),
								bean);
						}
					}
				}
				////////////////////////////////////////////////////////////////
				// bruϊۑ
				int type = xmsResponse.getOutType();
				if (type == XmsResponse.JSP_CSV) {
					makeCsvFile(xmsRequest, xmsResponse, action);
				}
				////////////////////////////////////////////////////////////////
				// ̃T[ubg̏I@̕
				if (type == XmsResponse.DOWNLOAD) {
					terminateWithCsvDownload(xmsRequest, xmsResponse, action);
				} else {
					terminateWithForward(xmsRequest, xmsResponse);
				}
			}
		} catch (XmsException e) {
			throw e;
		} catch (Exception e) {
			throw new XmsSystemException(e);
		} finally {
			DebugLog.write(
				XmsScreenControl.class,
				"TAIL processRequest()",
				DebugLog.ROW);
		}

	}

	/**
	 * XmsWarningExceptionpirotH[hłāAIB<br>
	 * eANVŎw肵ĂXmsWarningExceptionJSPɃtH[hB
	 * Ŏw肳ꂽexceptiońAConstant.KEY_ERRORL[
	 * NGXgƂĐݒ肷B
	 * Oꍇ́AterminateWithThrowableĂяoB
	 * 
	 * @param xmsRequest NGXgEIuWFNgB
	 * @param xmsResponse X|XEIuWFNgB
	 * @param exception G[̌ƂȂOIuWFNgB
	 * @see #terminateWithThrowable(XmsRequest, XmsResponse, Throwable)
	 * @see Constant#KEY_ERROR
	 * @see XmsWarningException
	 */
	void terminateWithWarningException(
		XmsRequest xmsRequest,
		XmsResponse xmsResponse,
		XmsWarningException exception) {

		// HTTP NGXg
		HttpServletRequest request = null;
		// ANVhc
		String actionId = null;
		// tH[htqk
		String url = null;

		try {
			request = xmsRequest.getRequest();
			// tH[hirõpX擾
			actionId = xmsRequest.getParameter(Constant.REQUEST_ACTION_ID);
			url = XmsScreenXMLPerser.getWarningExceptiontJspPath(actionId);
			// G[̗OZbg
			request.setAttribute(Constant.KEY_ERROR, exception);

			forward(xmsRequest, url);
		} catch (Exception e) {
			terminateWithThrowable(xmsRequest, xmsResponse, exception);
		}
	}

	/**
	 * XmsSystemExceptionpirotH[hłāAIB<br>
	 * eANVŎw肵ĂXmsSystemExceptionJSPɃtH[hB
	 * Ŏw肳ꂽexceptiońAConstant.KEY_ERRORL[
	 * NGXgƂĐݒ肷B
	 * Oꍇ́AterminateWithThrowableĂяoB
	 * 
	 * @param xmsRequest NGXgEIuWFNgB
	 * @param xmsResponse X|XEIuWFNgB
	 * @param exception G[̌ƂȂOIuWFNgB
	 * @see #terminateWithThrowable(XmsRequest, XmsResponse, Throwable)
	 * @see Constant#KEY_ERROR
	 * @see XmsSystemException
	 */
	void terminateWithSystemException(
		XmsRequest xmsRequest,
		XmsResponse xmsResponse,
		XmsSystemException exception) {

		// HTTP NGXg
		HttpServletRequest request = null;
		// ANVhc
		String actionId = null;
		// tH[htqk
		String url = null;

		try {
			request = xmsRequest.getRequest();
			// tH[hirõpX擾
			actionId = xmsRequest.getParameter(Constant.REQUEST_ACTION_ID);
			url = XmsScreenXMLPerser.getSystemExceptiontJspPath(actionId);
			// G[̗OZbg
			request.setAttribute(Constant.KEY_ERROR, exception);

			forward(xmsRequest, url);
		} catch (Exception e) {
			terminateWithThrowable(xmsRequest, xmsResponse, exception);
		}
	}

	/**
	 * XmsInnerExceptionpirotH[hłāAIB<br>
	 * eANVŎw肵ĂXmsInnerExceptionJSPɃtH[hB
	 * Ŏw肳ꂽexceptiońAConstant.KEY_ERRORL[
	 * NGXgƂĐݒ肷B
	 * Oꍇ́AterminateWithThrowableĂяoB
	 * 
	 * @param xmsRequest NGXgEIuWFNgB
	 * @param xmsResponse X|XEIuWFNgB
	 * @param exception G[̌ƂȂOIuWFNgB
	 * @see #terminateWithThrowable(XmsRequest, XmsResponse, Throwable)
	 * @see Constant#KEY_ERROR
	 * @see XmsInnerException
	 */
	void terminateWithInnerException(
		XmsRequest xmsRequest,
		XmsResponse xmsResponse,
		XmsInnerException exception) {

		// HTTP NGXg
		HttpServletRequest request = null;
		// ANVhc
		String actionId = null;
		// tH[htqk
		String url = null;

		try {
			request = xmsRequest.getRequest();
			// tH[hirõpX擾
			actionId = xmsRequest.getParameter(Constant.REQUEST_ACTION_ID);
			url = XmsScreenXMLPerser.getInnerExceptiontJspPath(actionId);
			// G[̗OZbg
			request.setAttribute(Constant.KEY_ERROR, exception);

			forward(xmsRequest, url);
		} catch (Exception e) {
			terminateWithThrowable(xmsRequest, xmsResponse, exception);
		}
	}

	/**
	 * ʃG[iroւ̃tH[hłāAIB<br>
	 * Ŏw肳ꂽexceptiońAConstant.KEY_ERRORL[
	 * NGXgƂĐݒ肷B
	 * @param xmsRequest NGXgEIuWFNgB
	 * @param xmsResponse X|XEIuWFNgB
	 * @param throwable G[̌ƂȂO^G[IuWFNgB
	 * @see Constant#KEY_ERROR
	 */
	void terminateWithThrowable(
		XmsRequest xmsRequest,
		XmsResponse xmsResponse,
		Throwable throwable) {

		// HTTP NGXg
		HttpServletRequest request = null;
		// tH[htqk
		String url = null;

		try {
			request = xmsRequest.getRequest();
			// tH[hirõpX擾
			url = XmsScreenXMLPerser.getThrowableJspPath();
			// G[̗OZbg
			request.setAttribute(Constant.KEY_ERROR, throwable);
			forward(xmsRequest, url);
		} catch (Throwable th) {
			DebugLog.write(XmsScreenControl.class, th, DebugLog.HIGHT);
		}
	}

	/**
	 * bru_E[hvꂽꍇ̏B<br>
	 * w肵brut@Ct@CVXeɂ΁A
	 * _E[h̃X|XNCAgɎsB
	 * @param xmsRequest  HTTPNGXgB
	 * @param xmsResponse HTTPX|XB
	 * @return boolean ̃\bhłbru_E[htrueA
	 *                  _E[hȂꍇfalse߂B
	 */
	private boolean doRequestCsv(
		XmsRequest xmsRequest,
		XmsResponse xmsResponse)
		throws XmsException {

		HttpServletResponse response = null;
		String fileName = null;
		String downloadFileName = null;
		InputStream is = null;
		boolean returnValue = false;
		boolean exceptionFlag = false;
		
		XmsScreenAction action = null;
		try {
			response = xmsRequest.getResponse();
			// w肵t@Cꍇ́A_E[hEX|XsB
			fileName = xmsRequest.getParameter(Constant.REQUEST_FILENAME);
			if (fileName != null) {
				File csvFile = new File(getOutputDir(), fileName);
				if (csvFile.isFile() == true) {
					// _E[h_CAOɕ\t@CI
					action = getScreenAction(xmsRequest, xmsResponse);
					downloadFileName = action.getDownloadFileName(xmsRequest,xmsResponse);
					if ( StringUtil.isNullString(downloadFileName) == true ) {
						downloadFileName = getDownloadFileName(xmsRequest);
					}
					// t@C̃Xg[J
					is = new BufferedInputStream(new FileInputStream(csvFile));
					responseForFileDownload(response, is, downloadFileName);
					// _E[hB
					returnValue = true;
				}
			}
			exceptionFlag = true;
		} catch (Exception e) {
			throw new XmsSystemException(e);

		} finally {
			// ̓Xg[̃N[Y
			if (is != null) {
				try {
					is.close();
				} catch (Exception e) {
					if (exceptionFlag == true) {
						throw new XmsSystemException(e);
					}
				} finally {
					is = null;
				}
			}
		}

		return returnValue;
	}

	/**
	 * _E[hEX|XsB<br>
	 * @param response HTTPX|XB
	 * @param is       _E[hf[^̎擾ƂȂ̓Xg[B
	 * @param fileName _E[hEt@CB
	 * @throws XmsException _E[hɃG[ꍇB
	 */
	private void responseForFileDownload(
		HttpServletResponse response,
		InputStream is,
		String fileName)
		throws XmsException {

		// X|Xւ̏o̓Xg[
		OutputStream responseStream = null;
		// o̓obt@
		byte[] buffer = null;
		// ǂݍ݃TCY
		int bufferLength = 0;
		// ONX
		boolean exceptionFlag = false;

		try {
			// X|XpɃwb_ݒ
			response.setHeader(
				"Content-Disposition",
				"filename=\"" + new String(fileName.getBytes(),"ISO8859-1") + "\"");
			response.setContentType("text/unknown");
			//o̓Xg[擾B
			responseStream = response.getOutputStream();
			// _E[hsB
			buffer = new byte[DOWNLOAD_BUFFER_SIZE];
			while (true) {
				bufferLength = is.read(buffer);
				if (bufferLength <= 0) {
					break;
				}
				responseStream.write(buffer, 0, bufferLength);
			}
			exceptionFlag = true;

		} catch (Exception e) {
			throw new XmsSystemException(e);
		} finally {
			// X|Xւ̏o̓Xg[̃N[Y
			try {
				responseStream.close();
			} catch (Exception e) {
				if (exceptionFlag == true) {
					throw new XmsSystemException(e);
				}
			} finally {
				responseStream = null;
			}
		}
	}

	/**
	 * _E[hEX|XsB<br>
	 * @param response HTTPX|XB
	 * @param data     _E[hf[^B
	 * @param fileName _E[hEt@CB
	 * @throws XmsException _E[hɃG[ꍇB
	 * @see #responseForFileDownload(HttpServletResponse, InputStream, String)
	 */
	private void responseForFileDownload(
		HttpServletResponse response,
		String data,
		String fileName)
		throws XmsException,Exception {
		// Xg[ɕϊāAI[o[[h\bhĂԁB
		ByteArrayInputStream is = null;
		try {
			Environment objEnv = new Environment();
			String lsCsvEncode = objEnv.getCsvEncode();
			is = new ByteArrayInputStream(data.getBytes(lsCsvEncode));
		} catch(Exception e) {
			throw e;
		}

		responseForFileDownload(response, is, fileName);
	}

	/**
	 * brut@C𐶐B<br>
	 * ANVʃNXA𐶐ANVNXɂāA
	 * bruf[^ɕϊAt@CɕۑB
	 * ۑt@CResultFileListɕۑA
	 * ResultFileList̂̂̓ZbVo^B
	 * ZbVɂȂ_ŁAResultFileListɓo^
	 * t@Cɍvt@C͍폜B
	 * ܂At@Cbeanɂo^B
	 * 
	 * @param xmsRequest NGXgEIuWFNgB
	 * @param xmsResponse X|XEIuWFNgB
	 * @param action bean𐶐Abruϊ\ȃANVENXB
	 * @throws XmsException ϊEo͒ɃG[ꍇB
	 * @see ResultFileList
	 */
	private void makeCsvFile(
		XmsRequest xmsRequest,
		XmsResponse xmsResponse,
		XmsScreenAction action)
		throws XmsException {
		// HTTPNGXg
		HttpServletRequest request = null;

		XmsScreenBean bean = null;
		// bruf[^
		String csv = null;
		// t@C
		String fileName = null;
		// t@Cւ̏o̓Xg[
		OutputStream os = null;
		// ZbVEIuWFNg
		HttpSession session = null;
		// t@Cۑp
		ResultFileList resultFileList = null;
		// OtO
		boolean exceptionFlag = false;
		try {
			request = xmsRequest.getRequest();
			bean = xmsResponse.getScreenBean();
			csv = action.convertToCSV(bean);

			// CSVt@Cɕۑ
			fileName = makeCsvFileName(xmsRequest);
			File csvFile = new File(getOutputDir(), fileName);
			os = new BufferedOutputStream(new FileOutputStream(csvFile));

			Environment objEnv = new Environment();
			String lsCsvEncode = objEnv.getCsvEncode();
			os.write(csv.getBytes(lsCsvEncode));
			
			// t@CZbVɓo^
			session = request.getSession(true);
			resultFileList =
				(ResultFileList) session.getAttribute(
					Constant.KEY_RESULT_FILE_LIST);
			if (resultFileList == null) {
				resultFileList = new ResultFileList(getOutputDir());
				session.setAttribute(
					Constant.KEY_RESULT_FILE_LIST,
					resultFileList);
			}
			resultFileList.add(fileName);

			// t@CBeanɒǉo^
			bean.setResultFileName(fileName);
			exceptionFlag = true;
		} catch (XmsException e) {
			throw e;
		} catch (Exception e) {
			throw new XmsSystemException(e);
		} finally {
			// o̓Xg[̃N[Y
			if (os != null) {
				try {
					os.close();
				} catch (Exception e) {
					if (exceptionFlag == true) {
						throw new XmsSystemException(e);
					}
				} finally {
					os = null;
				}
			}
		}

	}

	/**
	 * bru_E[hāAIB
	 * @param xmsRequest HTTPNGXB
	 * @param xmsResponse HTTPX|XB
	 * @param action bean𐶐Abruϊ\ȃANVENXB
	 * @throws XmsException _E[hɃG[ꍇB
	 */
	private void terminateWithCsvDownload(
		XmsRequest xmsRequest,
		XmsResponse xmsResponse,
		XmsScreenAction action)
		throws XmsException {

		// HTTPX|X
		HttpServletResponse response = null;
		// ʕ\pBean
		XmsScreenBean bean = null;
		// bruf[^
		String csv = null;
		// brut@C
		String fileName = null;

		try {
			response = xmsRequest.getResponse();
			bean = xmsResponse.getScreenBean();

			// bruf[^̎擾
			csv = action.convertToCSV(bean);

			// _E[ht@Č
			// ANVɓƎ̌܂肪΁A̖OgpA
			// Ȃ΍쐬B
			fileName = action.getDownloadFileName(xmsRequest, xmsResponse);
			if (StringUtil.isNullString(fileName) == true) {
				fileName = getDownloadFileName(xmsRequest);
			}
			responseForFileDownload(response, csv, fileName);
		} catch (XmsException e) {
			throw e;
		} catch (Exception e) {
			throw new XmsSystemException(e);
		} finally {
		}
	}

	/**
	 * iro܂͑̃\[Xւ̃tH[hłāAIB
	 * @param xmsRequest HTTPNGXgB
	 * @param xmsResponse HTTPX|XB
	 * @throws XmsException tH[hɃG[ꍇB
	 */
	private void terminateWithForward(
		XmsRequest xmsRequest,
		XmsResponse xmsResponse)
		throws XmsException {

		// ANVhc
		String actionId = null;
		// tH[htqh
		String uri = null;
		// XVns
		String businessStatus = null;

		try {
			// tH[hURI擾
			actionId = xmsRequest.getParameter(Constant.REQUEST_ACTION_ID);
			businessStatus = xmsResponse.getBusinessStatus();
			int type = xmsResponse.getOutType();
			uri = XmsScreenXMLPerser.getUriToForward(
				actionId, businessStatus, type);
			forward(xmsRequest, uri);
		} catch (XmsException e) {
			throw e;
		} catch (Exception e) {
			throw new XmsSystemException(e);
		}
	}

	/**
	 * tH[hsB
	 * @param xmsRequest NGXgEIuWFNgB
	 * @param uri tH[hƂȂURIB
	 * @throws XmsException tH[hɃG[ꍇB
	 */
	private void forward(XmsRequest xmsRequest, String uri)
		throws XmsException {

		// HTTP NGXg
		HttpServletRequest request = null;
		// HTTPX|X
		HttpServletResponse response = null;
		RequestDispatcher dispatcher = null;
		try {
			request = xmsRequest.getRequest();
			response = xmsRequest.getResponse();
			dispatcher = request.getRequestDispatcher(uri);
			dispatcher.forward(request, response);
		} catch (Exception e) {
			throw new XmsSystemException(e);
		}
	}

	/**
	 * brut@C߂B<br>
	 * [UOCID
	 * + VXeiYYYYMMddHHmmss`j{&quot;.csv&quot;߂B
	 * 
	 * @return String 肵t@CB
	 */
	private String makeCsvFileName(XmsRequest xmsRequest) throws XmsException {
		// VXe
		Date systemDate = null;
		// HTTPNGXg
		HttpServletRequest request = null;
		// [UID
		String userId = null;
		// ̃\bh̖߂lpobt@
		StringBuffer fileNameBuffer = null;

		// HTTPZbV
		HttpSession session = null;
		// [UIuWFNg
		User user = null;

		try {
			fileNameBuffer = new StringBuffer();

			// [UID
			request = xmsRequest.getRequest();
			session = request.getSession(false);
			if ( session != null ) {
				// [UIuWFNg擾
				user = (User)session.getAttribute(Constant.KEY_USER);
				if ( user != null ) {
					userId = user.getLoginID();
				}
			}
			if (StringUtil.isNullString(userId) == false) {
				fileNameBuffer.append(ChangeEncode.setHttpChar(userId));
			}
			// VXe
			systemDate = new Date();
			fileNameBuffer.append(Constant.DATE_FORMATTER.format(systemDate));
			// gq
			fileNameBuffer.append(".csv");
		} catch (Exception e) {
			throw new XmsSystemException(e);
		}

		return fileNameBuffer.toString();
	}

	/**
	 * _E[h_CAOɏ\t@C߂B<br>
	 * [UOCID + &quot;-&quot;
	 * + VXeiYYYYMMddHHmmss`j{&quot;.csv&quot;߂B
	 * 
	 * @return String 肵t@CB
	 */
	private String getDownloadFileName(XmsRequest xmsRequest) throws XmsException {
		String fileName = null;
		
		fileName = makeCsvFileName(xmsRequest);
		
		return fileName;
	}
	/**
	 * NGXgɑΉANVNX擾B<br>
	 * w肵NGXgANVID擾A
	 * ΉANVNXECX^X𐶐AԋpB
	 * 
	 * @param xmsRequest HTTPNGXgB
	 * @param xmsResponse HTTPX|XB
	 * @return XmsScreenAction ANVIDɑΉANVNXB
	 * @throws XmsException ANVID܂܂ȂꍇA
	 * ΉANVNX݂ȂꍇB
	 */
	private XmsScreenAction getScreenAction(
		XmsRequest xmsRequest,
		XmsResponse xmsResponse)
		throws XmsException {

		// ANVhc
		String actionId = null;
		// ANVNX
		String className = null;
		// ANVNX[hp
		Class actionClass = null;
		// NANVNX
		XmsScreenAction action = null;

		try {
			// ANVhc擾B
			actionId = xmsRequest.getParameter(Constant.REQUEST_ACTION_ID);
			// sNX̑I
			className =
				XmsScreenXMLPerser.getScreenActionName(
					actionId,
					xmsResponse.getBusinessStatus());
			if (StringUtil.isNullString(className) == false) {
				actionClass = Class.forName(className);
				action = (XmsScreenAction) actionClass.newInstance();
			}
		} catch (XmsException e) {
			throw e;
		} catch (Exception e) {
			throw new XmsSystemException(e);
		}
		DebugLog.write(this.getClass(), action, DebugLog.MID);
		return action;
	}

	/**
	 * ʃf[^̏o͐߂܂B<br>
	 * @return ʃf[^̏o͐fBNg\FileIuWFNgB
	 */
	private synchronized static File getOutputDir() throws XmsException {

		String strJspRootDir = null;
		try {
			if (CSV_OUTPUT_DIR == null) {
				strJspRootDir = XmsScreenXMLPerser.getOutputDirectory();
				DebugLog.write(
					XmsScreenControl.class,
					"strJspRootDir==null:" + (strJspRootDir == null),
					DebugLog.ROW);

				CSV_OUTPUT_DIR = new File(strJspRootDir);
			}
		} catch (XmsException e) {
			throw e;
		} catch (Exception e) {
			throw new XmsSystemException(e);
		}
		return CSV_OUTPUT_DIR;
	}
}
