/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

//
//	DateUtility
//	ύX
//		2004.02.01	VK쐬
//

package jp.co.ntt.lms.lo.scorm.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.StringTokenizer;

import jp.co.ntt.lms.lo.scorm.kernel.exception.SystemException;

/**
 *  DateUtility<BR>
 *  DateUtilityNX<BR>
 */
public class DateUtility {

	/** ^C][܂ł̋؂萔(؂蕶܂) */
	final static int COUNT_TOKEN_FOR_TIME_ZONE = 11;

	/** ^C][̒ */
	final static int TIME_ZONE_LENGTH = 5;

	/** ^C][̍R[h̒ */
	final static int TIME_ZONE_COUNTRY_LENGTH = 2;

	/** ^C][̎ԕ̒ */
	final static int TIME_ZONE_TIME_LENGTH = 2;

	/** dateTime̋؂蕶 */
	final static String DATE_TIME_DELIM = "-:+T";

	/**
	 *
	 *	CӂdateTimeCalendar^ɕϊ
	 *
	 * @param	dateTime	Calendar^ɕϊ
	 *						Fyyyy-MM-ddThh:mm:ss.sss}xx:tt
	 *								yyyy:
	 *								MM:
	 *								dd:
	 *								T:NƎԂ̋؂BTȉ͎
	 *								hh:
	 *								mm:
	 *								ss.sss:b
	 *								}:^C][̕B+-
	 *								xx:^C][̍R[h
	 *								tt:^C][̎
	 *								^C][͂ȂĂ
	 *
	 * @return 	̓p[^Calendar^ɕϊϐ
	 *
	 */
	public static Calendar toCalendar(String dateTime) throws SystemException {

		try {
			if (dateTime == null || dateTime.equals("")) {
				return null;
			}

			Calendar ss = Calendar.getInstance();
			SimpleDateFormat formatter = null;
			StringBuffer set_time = null;

			// ̓p[^؂蕶ŕ
			StringTokenizer st = new StringTokenizer(dateTime, DATE_TIME_DELIM, true);
			if (st == null || st.countTokens() < COUNT_TOKEN_FOR_TIME_ZONE) {
				throw new SystemException("DateTime[toCalendar]: '" + dateTime + "' ̏G[łB");
			}

			if (st.countTokens() > COUNT_TOKEN_FOR_TIME_ZONE) {
				// ^C][O܂ł̕擾
				set_time = new StringBuffer(st.nextToken());
				for (int i = 1; i < COUNT_TOKEN_FOR_TIME_ZONE; i++) {
					set_time.append(st.nextToken());
				}

				// ^C][̎擾
				set_time.append(st.nextToken());
				if (st.hasMoreTokens()) {
					set_time.append(st.nextToken());
				}
				else {
					throw new SystemException("DateTime[toCalendar]: '" + dateTime + "' ̏G[łB");
				}

				if (st.hasMoreTokens()) {
					// R[hƎԂ̊ԂɁu:v鎞͎菜
					st.nextToken();
					set_time.append(st.nextToken());
				}

				formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
			}
			else { // ̓p[^Ƀ^C][Ȃ
				set_time = new StringBuffer(dateTime);
				formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
			}

			ss.setTime(formatter.parse(set_time.toString()));

			return ss;

		}
		catch (Exception e) {
			throw new SystemException("DateTime[toCalendar()]:'" + dateTime + "' Calendar^ɕϊo܂B", e);
		}
	}

	/**
	 *
	 *	CӂCalendar^ϐString^ɕϊ
	 *
	 * @param	ss	String^ɕϊCalendar^ϐ
	 * @return	̓p[^String^ɕϊϐ
	 * 				Fyyyy-MM-ddThh:mm:ss.sss}xx:tt
	 *								yyyy:
	 *								MM:
	 *								dd:
	 *								T:NƎԂ̋؂BTȉ͎
	 *								hh:
	 *								mm:
	 *								ss.sss:b
	 *								}:^C][̕B+-
	 *								xx:^C][̍R[h
	 *								tt:^C][̎
	 *
	 */

	public static String toString(Calendar ss) throws SystemException {

		try {
			if (ss == null) {
				return ("");
			}

			// ̓p[^𕶎ɕϊ
			SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
			String time_str = formatter.format(ss.getTime());

			// ϊ؂蕶ŕ
			StringTokenizer st = new StringTokenizer(time_str, DATE_TIME_DELIM, true);
			StringBuffer set_time = null;

			// ^C][̕ҏW
			if (st.countTokens() > COUNT_TOKEN_FOR_TIME_ZONE) {
				// ^C][O܂ł̕擾
				set_time = new StringBuffer(st.nextToken());
				for (int i = 0; i < COUNT_TOKEN_FOR_TIME_ZONE; i++) {
					set_time.append(st.nextToken());
				}

				// ^C][̍R[hƎԂ̊ԂɁu:v
				String time_zone = st.nextToken();
				set_time.append(time_zone.substring(0, time_zone.length() - TIME_ZONE_TIME_LENGTH));
				set_time.append(":");
				set_time.append(time_zone.substring(time_zone.length() - TIME_ZONE_TIME_LENGTH));
				return (set_time.toString());
			}
			else {
				// ̓p[^Ƀ^C][Ȃ͕ϊ̂܂ܕԂ
				return time_str;
			}

		}
		catch (Exception e) {
			throw new SystemException("DateTime[toString()]: w肳ꂽCalendar^ϐ𕶎ɕϊo܂B", e);
		}

	}
}
