//
// CopyRight (C) 2002, IPA, eLC, NTT Resonant Inc. All rights reserved.
//
//	Default
//
//	ύX
//		2002.12.25  VK쐬
//

package jp.co.ntt.lms.lo.scorm.kernel;

import java.io.IOException;

import javax.xml.parsers.ParserConfigurationException;

import jp.co.ntt.lms.lo.scorm.kernel.exception.SystemException;
import jp.co.ntt.lms.lo.scorm.util.CachedNode;
import jp.co.ntt.lms.lo.scorm.util.XMLUtil;

import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/**
*  DefaultNX<BR>
*  Sequencing[̃ftHgl擾NX<BR>
*/
public class Default {
	/** "Default.xml"DOM Document */
	private static Document doc;

	/** "Default.xml"̃[gm[h */
	private static CachedNode sequencing;

	/**
	 * ftHgRXgN^
	 */
	private Default() {}

	/**
	 * 
	 */
	private static void initialize() throws IOException, ParserConfigurationException, SAXException {
		synchronized (Default.class) {
			if (doc == null) {
				doc = XMLUtil.newDocumentBuilder(false).parse(Default.class.getResource("/conf/scorm/Default.xml").toString());

				sequencing = new CachedNode(doc.getDocumentElement());
			}
		}
	}

	/**
	 * ftHgl̎擾<BR>
	 *
	 * @param  xpath	ftHglւxpath<BR>
	 * @return ftHg<BR>
	 */
	public static String getValue(String xpath) throws SystemException {
		try {
			initialize();

			CachedNode value = sequencing.selectSimpleSingleNode(xpath);

			if (value == null) {
				throw new SystemException("ftHgl݂܂[" + xpath + "]");
			}

			return value.getNodeValue();
		}
		catch (SystemException ex) {
			throw ex;
		}
		catch (Exception ex) {
			throw new SystemException("ftHgl̎擾Ɏs܂B", ex);
		}
	}

	/**
	 * ftHg̃m[h̎擾<BR>
	 *
	 * @param   xpath 擾m[h̃Gg<BR>
	 * @return  m[h<BR>
	 */
	public static CachedNode getNode(String xpath) throws SystemException {
		try {
			initialize();

			CachedNode node = sequencing.selectSimpleSingleNode(xpath);

			if (node == null) {
				throw new SystemException("ftHgl݂܂[" + xpath + "]");
			}

			return node;
		}
		catch (Exception ex) {
			throw new SystemException("ftHgl̎擾Ɏs܂B", ex);
		}
	}

	/**
	 * ftHg̃m[hXg̎擾<BR>
	 *
	 * @param  xpath 擾m[hXg̃Gg<BR>
	 * @return m[hXg<BR>
	 */
	public static CachedNode[] getNodeList(String xpath) throws SystemException {
		try {
			initialize();

			CachedNode nodes[] = sequencing.selectSimpleNodeList(xpath);

			if ((nodes == null) || (nodes.length <= 0)) {
				throw new SystemException("ftHgl݂܂[" + xpath + "]");
			}

			return nodes;
		}
		catch (Exception ex) {
			throw new SystemException("ftHgl̎擾Ɏs܂B", ex);
		}
	}
}
