/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

//
//@\ 
//		SCORM1.3 f[^f[eBeB NX
//ύX
//		2004.01.20	A.Kudoh  VK쐬
//
package jp.co.ntt.lms.lo.scorm.cbtcom;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
//import java.util.StringTokenizer;
import java.util.Vector;

/**
 * CMI f[^f[eBeB NX <BR>
 * @author A.kudoh
 * 
 */
public class CMIS13ModelUtil {

	/**
	 * SCORM v1.3 DataModel Name
	 */
	public static final String S13_LEARNER_ID	 	= "cmi.learner_id";
	public static final String S13_LEARNER_NAME	= "cmi.learner_name";
	public static final String S13_LOCATION		= "cmi.location";
	public static final String S13_CREDIT		 	= "cmi.credit";
	public static final String S13_LESSON_STATUS 	= "cmi.success_status";
	public static final String S13_COMP_STATUS 	= "cmi.completion_status";
	public static final String S13_ENTRY		 	= "cmi.entry";
	public static final String S13_SCORE_CHILD 	= "cmi.score._children";
	public static final String S13_SCORE_SCALE 	= "cmi.score.scaled";
	public static final String S13_SCORE_RAW	 	= "cmi.score.raw";
	public static final String S13_SCORE_MAX	 	= "cmi.score.max";
	public static final String S13_SCORE_MIN	 	= "cmi.score.min";
	public static final String S13_TOTAL_TIME	 	= "cmi.total_time";
	public static final String S13_MODE			= "cmi.mode";
	public static final String S13_MASTERY_SCORE 	= "cmi.scaled_passing_score";
	public static final String S13_MAX_TIME_ALLOWED = "cmi.max_time_allowed";
	public static final String S13_TIME_LIMIT_ACTION = "cmi.time_limit_action";
	public static final String S13_PREFERENCE_GRP	= "cmi.learner_preference";
	public static final String S13_EXIT			= "cmi.exit";
	public static final String S13_SESSION_TIME	= "cmi.session_time";
	public static final String S13_CMT_GRP		= "cmi.comments_from_learner";
	public static final String S13_INT_GRP		= "cmi.interactions";
	// NTTR*1
	public static final String S13_COMPLETION_THRESHOLD = "cmi.completion_threshold";
	public static final String S13_PROGRESS_MEASURE = "cmi.progress_measure";
	
	// AICC CMI DataModel Name
	private static final String AICC_LEARNER_ID	 	= "cmi.core.student_id";
	private static final String AICC_LEARNER_NAME 	= "cmi.core.student_name";
	private static final String AICC_LOCATION	 		= "cmi.core.lesson_location";
	private static final String AICC_CREDIT		 	= "cmi.core.credit";
	private static final String AICC_LESSON_STATUS	= "cmi.core.lesson_status";
	private static final String AICC_COMP_STATUS 		= "cmi.core.completion_status";
	private static final String AICC_ENTRY		 	= "cmi.core.entry";
	private static final String AICC_SCORE_CHILD 		= "cmi.core.score._children";
	private static final String AICC_SCORE_SCALE 		= "cmi.core.score.scaled";
	private static final String AICC_SCORE_RAW	 	= "cmi.core.score.raw";
	private static final String AICC_SCORE_MAX	 	= "cmi.core.score.max";
	private static final String AICC_SCORE_MIN	 	= "cmi.core.score.min";
	private static final String AICC_TOTAL_TIME	 	= "cmi.core.total_time";
	private static final String AICC_MODE		 		= "cmi.core.lesson_mode";
	private static final String AICC_MASTERY_SCORE 	= "cmi.student_data.mastery_score";
	private static final String AICC_MAX_TIME_ALLOWED = "cmi.student_data.max_time_allowed";
	private static final String AICC_TIME_LIMIT_ACTION = "cmi.student_data.time_limit_action";
	private static final String AICC_PREFERENCE_GRP	= "cmi.student_preference";
	private static final String AICC_EXIT			 	= "cmi.core.exit";
	private static final String AICC_SESSION_TIME	 	= "cmi.core.session_time";
	private static final String AICC_CMT_GRP 			= "cmi.evaluation.comments";
	private static final String AICC_INT_GRP 			= "cmi.interactions";
	//	 NTTR*2
	public static final String AICC_COMPLETION_THRESHOLD = "cmi.core.completion_threshold";
	public static final String AICC_PROGRESS_MEASURE = "cmi.core.progress_measure";

	// AICC Error Code
	/**
	 * Element cannot have a value
	 */
	private static final int AICC_ERROR_204 = 204;
	/**
	 * Not implemented error
	 */
	private static final int AICC_ERROR_401 = 401;
	/**
	 * Element is read only.
	 */
	private static final int AICC_ERROR_403 = 403;
	/**
	 * Element is write only
	 */
	private static final int AICC_ERROR_404 = 404;
	/**
	 * Incorrect Data Type
	 */
	private static final int AICC_ERROR_405 = 405;

	// SCORM1.3 Error Code
	/**
	 * Unimplemented Data Model Element
	 */	
	public static final int S13_ERROR_402 = 402;
	/**
	 * Data Model Element Is Read Only 
	 */
	public static final int S13_ERROR_404 = 404;
	/**
	 * Data Model Element Is Write Only 
	 */
	public static final int S13_ERROR_405 = 405;
	/**
	 * Data Model Element Type Mismatch 
	 */
	public static final int S13_ERROR_406 = 406;
	
	/**
	 *  f[^f}bv
	 */
	private	static HashMap m_hmName;

	/**
	 *  f[^fO[v
	 */
	private	static Vector m_vcGroupName;

	/**
	 *  G[R[h}bv
	 */
	private	static HashMap m_hmErrorCode;
	
	/**
	 *  f[^f^CvB<br>
	 * @@trueFSCORM1.3 f@falseFAICC f
	 */
	private	static boolean m_bScorm13Type;

	/**
	 * sR[h
	 */
	public		static final String CHAR_CRLF = System.getProperty("line.separator");

	/**
	 * X^eBbNCjVCUB<br>
	 * f[^f}bvAG[R[h}bvݒ肷B<br>
	 */
	static {

		m_hmName = new HashMap();
		m_hmErrorCode = new HashMap();
		m_bScorm13Type = true;

		m_vcGroupName = new Vector();

		// f[^f}bvݒ肷
		m_hmName.put(S13_LEARNER_ID, AICC_LEARNER_ID);
		m_hmName.put(S13_LEARNER_NAME, AICC_LEARNER_NAME);
		m_hmName.put(S13_LOCATION, AICC_LOCATION);
		m_hmName.put(S13_CREDIT, AICC_CREDIT);
		m_hmName.put(S13_LESSON_STATUS, AICC_LESSON_STATUS);
		m_hmName.put(S13_COMP_STATUS, AICC_COMP_STATUS);
		m_hmName.put(S13_ENTRY, AICC_ENTRY);
		m_hmName.put(S13_SCORE_CHILD, AICC_SCORE_CHILD);
		m_hmName.put(S13_SCORE_SCALE, AICC_SCORE_SCALE);
		m_hmName.put(S13_SCORE_RAW, AICC_SCORE_RAW);
		m_hmName.put(S13_SCORE_MAX, AICC_SCORE_MAX);
		m_hmName.put(S13_SCORE_MIN, AICC_SCORE_MIN);
		m_hmName.put(S13_TOTAL_TIME, AICC_TOTAL_TIME);
		m_hmName.put(S13_MODE, AICC_MODE);
		m_hmName.put(S13_MASTERY_SCORE,AICC_MASTERY_SCORE);
		m_hmName.put(S13_MAX_TIME_ALLOWED, AICC_MAX_TIME_ALLOWED);
		m_hmName.put(S13_TIME_LIMIT_ACTION, AICC_TIME_LIMIT_ACTION);
		m_hmName.put(S13_PREFERENCE_GRP, AICC_PREFERENCE_GRP);
		m_hmName.put(S13_EXIT,AICC_EXIT);
		m_hmName.put(S13_SESSION_TIME, AICC_SESSION_TIME);
		m_hmName.put(S13_CMT_GRP, AICC_CMT_GRP);

		// NTTR*3
		m_hmName.put(S13_COMPLETION_THRESHOLD, AICC_COMPLETION_THRESHOLD);
		m_hmName.put(S13_PROGRESS_MEASURE, AICC_PROGRESS_MEASURE);

		// f[^fO[vݒ肷
		m_vcGroupName.add(S13_PREFERENCE_GRP);
		m_vcGroupName.add(S13_CMT_GRP);

		// G[R[h}bvݒ肷
		m_hmErrorCode.put(new Integer(AICC_ERROR_204), new Integer(S13_ERROR_404));
		m_hmErrorCode.put(new Integer(AICC_ERROR_401), new Integer(S13_ERROR_402));
		m_hmErrorCode.put(new Integer(AICC_ERROR_403), new Integer(S13_ERROR_404));
		m_hmErrorCode.put(new Integer(AICC_ERROR_404), new Integer(S13_ERROR_405));
		m_hmErrorCode.put(new Integer(AICC_ERROR_405), new Integer(S13_ERROR_406));

	}

	/**	
	 * }bsOɏ]ASCORM1.3̃f[^fAICC CMIf[^
	 * fɕϊÂ̖ԋp<br>
	 * }bsOΏۈȊÕf[^fw肳ꂽꍇ́Aw肳ꂽ
	 * ̂̂܂ܕԋp<br>
	 * @param strS13Name String@SCORM1.3 f[^f
	 * @return String@AICC CMIf[^f
	 */
	public static String changeAiccModelName(String strS13Name) {

		String strAiccName = null;

		// ̓p[^`FbN
		if ((strS13Name != null) && ("".equals(strS13Name) == false)) {
			strAiccName = (String)m_hmName.get(strS13Name);
		}
		if (strAiccName == null) {
			// tł̓qbgȂz܂ރf̏ꍇ
			// iFcmi.learner_preference.n.text Ȃǁj

			String strSubPath;
			StringBuffer sbReplace = new StringBuffer();
			int intCount = m_vcGroupName.size();
			for (int i=0; i < intCount; i++){
				strSubPath = (String)m_vcGroupName.get(i);
				if ( strS13Name.indexOf(strSubPath) != -1 ){
					// ϊAICC̃O[vpXo
					strAiccName = (String)m_hmName.get(strSubPath);
					if (strAiccName != null) {
						// AICC̃O[vpXɒu
						sbReplace.append(strAiccName);
						sbReplace.append(".");
						sbReplace.append(strS13Name.substring(strSubPath.length()+1));

						strAiccName = sbReplace.toString();
						break;
					}
				}
			}
			if (strAiccName == null) {
				// ɓȕϊ̕Kvȃf̏ꍇ
				// z܂݁AȂϊΏۂO[vł͂Ȃf
				// iFcmi.objectives.n.status Ȃǁj
				strSubPath = "cmi.objectives";
				if (strS13Name.indexOf(strSubPath) != -1) {
					int iPos = strS13Name.lastIndexOf("success_status");
					if (iPos != -1) {
						sbReplace.append(strS13Name.substring(0,iPos));
						sbReplace.append("status");

						strAiccName = sbReplace.toString();
					}
				}
				strSubPath = "cmi.interactions";
				if (strS13Name.indexOf(strSubPath) != -1) {
					int iPos = strS13Name.lastIndexOf("timestamp");
					if (iPos != -1) {
						sbReplace.append(strS13Name.substring(0,iPos));
						sbReplace.append("date");

						strAiccName = sbReplace.toString();
					}
					else {
						iPos = strS13Name.lastIndexOf("learner_response");
						if (iPos != -1) {
							sbReplace.append(strS13Name.substring(0,iPos));
							sbReplace.append("student_response");

							strAiccName = sbReplace.toString();
						}
					}
				}

			}
			if (strAiccName == null) {
				strAiccName = strS13Name;
			}
		}
		return strAiccName;
	}

	/**	
	 * }bsOɏ]AAICC̃G[R[hSCORM1.3̃G[R[h
	 * ɕϊÃR[hԋp<br>
	 * }bsOΏۈȊÕG[R[hw肳ꂽꍇ́Aw肳ꂽ
	 * G[R[ĥ܂ܕԋpB<br>
	 * @param intAiccCode int AICC G[R[h
	 * @return int@SCORM1.3 G[R[h
	 */
	public static int changeScormErrorCode(int intAiccCode) {

		Integer iobjScormCode = null;
		int intRetCode = 0;

		// ̓p[^`FbN
		if (intAiccCode >= 0) {
			iobjScormCode = (Integer)m_hmErrorCode.get(new Integer(intAiccCode));
		}
		if (iobjScormCode != null) {
			intAiccCode = iobjScormCode.intValue();
		}
		else {
			intRetCode = intAiccCode;
		}
		return intAiccCode;
	}

	/**
	 * AICC2.x`̃^C}[𕪐͂SCORM1.3`
	 * PyYmMdDThHmMs.sS̕ɕϊB<br>
	 * @param strAiccTime String AICC`iHHHH:MM:SS.SSj̕
	 * @return String SCORM1.3`iPyYmMdDThHmMs.sSjɕϊl
	 * @exception S13LogFormatException ϊɎsꍇ
	 */
	public static String parseS13Timespan( String strAiccTime )
		throws S13LogFormatException
	{
		String strTimespan = "";
		// p[^`FbN
		if( (strAiccTime == null) || ("".equals(strAiccTime) == true) ) {
			throw new S13LogFormatException("Invalid Timespan : " + strAiccTime );
		}

		/*
		 * AICC2.x`̃^C}[SCORM1.3`̃tH[}bgŕҏW
		 */
		// ^C}[l~bŎ擾
		long lngSecond = parseTimespanToLong(strAiccTime);
		// 擾~b̃^C}[lSCORM1.3tH[}bgŕҏW
		strTimespan = formatS13Timespan(lngSecond);
		
		return strTimespan;
	}

	/**
	 * SCORM1.3`(PyYmMdDThHmMs.sS)̃^C}[𕪐͂AICC2.x
	 * `̃^C}[iHHHH:MM:SS.SSjɕϊB<br>
	 * @param strTime String SCORM1.3`(PyYmMdDThHmMs.sS)̕
	 * @return String AICC2.x`iHHHH:MM:SS.SSjɕϊl
	 * @exception S13LogFormatException ϊɎsꍇ
	 */
	public static String parseAiccTimespan( String strTime )
		throws S13LogFormatException
	{
		String strTimespan = "";
		// p[^`FbN
		if( (strTime == null) || ("".equals(strTime) == true) ) {
			throw new S13LogFormatException("Invalid Timespan : " + strTime );
		}

		/*
		 * SCORM1.3`̃^C}[AICC2.x`̃tH[}bgŕҏW
		 */
		// ^C}[l~bŎ擾
		long lngSecond = parseTimeintervalToLong(strTime);
		// 擾~b̃^C}[lAICC2.xtH[}bgŕҏW
		strTimespan = formatAiccTimespan(lngSecond);
		
		return strTimespan;
	}

	/**
	 * AICC2.x`iHHHH:MM:SS.SSjTimespan^long^̃~b
	 * ϊB<br>
	 * @param strAiccTime String AICC`iHHHH:MM:SS.SSj̕
	 * @return long ~bɕϊl
	 * @exception S13LogFormatException ϊɎsꍇ
	 */
	public static long parseTimespanToLong( String strAiccTime )
		throws S13LogFormatException
	{
		// p[^`FbN
		if( (strAiccTime == null) || ("".equals(strAiccTime) == true) ) {
			throw new S13LogFormatException("Invalid Time : " + strAiccTime );
		}

//		StringTokenizer token = new StringTokenizer( strAiccTime, ":" );
		CMITokenizer token = new CMITokenizer( strAiccTime, ":" );

		long lngHour = 0;
		long lngMinute = 0;
		float fltSecond = 0;

		int intCount = 0;
		try {
			while( token.hasMoreTokens() ) {

				String strValue = token.nextToken();
				switch( intCount ) {
					case 0:
						// 
						lngHour = Long.parseLong( strValue );
						break;
					case 1:
						// 
						lngMinute = Long.parseLong( strValue );
						break;
					case 2:
						// b
						fltSecond = Float.parseFloat( strValue );
						break;
					default:
						break;
				}

				// JEgAbv
				intCount++;
			}
		}
		catch( NumberFormatException ne ) {
			throw new S13LogFormatException(ne.getMessage());
		}

		if( intCount != 3 ) {
			throw new S13LogFormatException("Invalid Time : " + strAiccTime );
		}

		long lngRes = 0;

		lngRes = (lngHour * 3600000L) + (lngMinute * 60000L) + (long)(fltSecond * 1000L);

		return lngRes;
	}

	/**
	 * SCORM1.3`iPyYmMdDThHmMs.sSjTimeinterval^
	 * long^̃~bɕϊB<br>
	 * @param strScoTime String SCORM`iPyYmMdDThHmMs.sSj̕
	 * @return long ~bɕϊl
	 * @exception S13LogFormatException ϊɎsꍇ
	 */
	public static long parseTimeintervalToLong( String strScoTime )
		throws S13LogFormatException
	{
		// p[^`FbN
		if( (strScoTime == null) || ("".equals(strScoTime) == true) ) {
			throw new S13LogFormatException("Invalid Time : " + strScoTime );
		}

		long lngYear = 0;
		long lngMonth = 0;
		long lngDay = 0;
		long lngHour = 0;
		long lngMinute = 0;
		float fltSecond = 0;

		String strDate = "";
		String strTime = "";
		if (strScoTime.startsWith("P") != true) {
			throw new S13LogFormatException("Type Mismatch  non-P");
		} 
		int intPos = strScoTime.indexOf('T');
		if (intPos != -1){
			// Ԃ̎w肪ȗĂȂꍇ
			strDate = strScoTime.substring(0,intPos);
			strTime = strScoTime.substring(intPos,strScoTime.length());
		}
		else{
			// Ԃ̎w肪ȗꂽꍇ
			strDate = strScoTime;
		}

		try {

			// N̎擾
			int intStartPos = 1;	// vtBbNXP菜
			intPos = strDate.indexOf('Y');
			if (intPos != -1){
				lngYear = Long.parseLong(strDate.substring(intStartPos,intPos));
				intStartPos = intPos + 1;
			}
			// ̎擾
			intPos = strDate.indexOf('M',intStartPos);
			if (intPos != -1){
				lngMonth = Long.parseLong(strDate.substring(intStartPos,intPos));
				intStartPos = intPos + 1;
			}
			// ̎擾
			intPos = strDate.indexOf('D',intStartPos);
			if (intPos != -1){
				lngDay = Long.parseLong(strDate.substring(intStartPos,intPos));
			}
			// ̎擾
			intStartPos = 1;	// vtBbNXT菜
			intPos = strTime.indexOf('H');
			if (intPos != -1){
				lngHour = Long.parseLong(strTime.substring(intStartPos,intPos));
				intStartPos = intPos + 1;
			}
			// ̎擾
			intPos = strTime.indexOf('M',intStartPos);
			if (intPos != -1){
				lngMinute = Long.parseLong(strTime.substring(intStartPos,intPos));
				intStartPos = intPos + 1;
			}
			// b̎擾
			intPos = strTime.indexOf('S',intStartPos);
			if (intPos != -1){
				fltSecond = Float.parseFloat(strTime.substring(intStartPos,intPos));
			}
		}
		catch( NumberFormatException ne ) {
			throw new S13LogFormatException(ne.getMessage());
		}

		long lngRes = 0;

		lngRes = (lngYear * 3600000L * 24L * 30L * 12L)
			 + (lngMonth * 3600000L * 24L * 30L);
		lngRes = lngRes + (lngDay * 3600000L * 24L) + (lngHour * 3600000L);
		lngRes = lngRes + (lngMinute * 60000L) + (long)(fltSecond * 1000L);

		return lngRes;
	}

	/**
	 * long^̃~bPyYmMdDThHmMs.sS `̕ɕϊB<br>
	 * @param lngTime ~b
	 * @return String PyYmMdDThHmMs.sS `̕
	 */
	public static String formatS13Timespan( long lngTime ) {

		String strTimespan = "";

		// ]ێ
		long lngRem = 0;

		// N̎Zo
		int intYear = (int)(lngTime / (3600000L * 24L * 30L * 12L));
		lngRem = lngTime % (3600000L * 24L * 30L * 12L);

		// ̎Zo
		int intMonth = (int)(lngRem / (3600000L * 24L * 30L));
		lngRem = lngRem % (3600000L * 24L * 30L);

		// ̎Zo
		int intDay = (int)(lngRem / (3600000L * 24L));
		lngRem = lngTime % (3600000L * 24L);

		// ̎Zo
		int intHour = (int)(lngRem / 3600000L);
		lngRem = lngTime % 3600000L;

		// ̎Zo
		int intMinute = (int)(lngRem / 60000L);
		lngRem = lngRem % 60000L;

		// b̎Zo
		float fltSecond = lngRem / 1000F;

		// ÑtH[}bg
		DecimalFormat objYearFormat = new DecimalFormat( "####" );
		String strYear = objYearFormat.format( intYear );

		// ̃tH[}bg
		DecimalFormat objMonthFormat = new DecimalFormat( "##" );
		String strMonth = objMonthFormat.format( intMonth );

		// ̃tH[}bg
		DecimalFormat objDayFormat = new DecimalFormat( "##" );
		String strDay = objDayFormat.format( intDay );

		// Ԃ̃tH[}bg
		DecimalFormat objHourFormat = new DecimalFormat( "##" );
		String strHour = objHourFormat.format( intHour );

		// ̃tH[}bg
		DecimalFormat objMinuteFormat = new DecimalFormat( "##" );
		String strMinute = objMinuteFormat.format( intMinute );

		// b̃tH[}bg
		DecimalFormat objSecondFormat = new DecimalFormat( "#0.##" );
		String strSecond = objSecondFormat.format( fltSecond );

		// tPyYmMdD tH[}bgŕҏW
		strTimespan = "P" + strYear + "Y" + strMonth + "M" + strDay + "D";

		// ԂThHmMs.sS tH[}bgŕҏW
		strTimespan = strTimespan + "T" + strHour + "H" + strMinute + "M";
		strTimespan = strTimespan + strSecond + "S";
		
		return strTimespan;
	}
		

	/**
	 * long^̃~bHHHH:MM:SS.SS `̕ɕϊ܂
	 * @param lngTime ~bɕϊl
	 * @return String HHHH:MM:SS.SS`̕
	 */
	public static String formatAiccTimespan( long lngTime ) {
		// ]ێ
		long lngRem = 0;

		// Ԃ̎Zo
		int intHour = (int)(lngTime / 3600000L);
		lngRem = lngTime % 3600000L;

		// ̎Zo
		int intMinute = (int)(lngRem / 60000L);
		lngRem = lngRem % 60000L;

		// b̎Zo
		float fltSecond = lngRem / 1000F;

		String strInterval = "";
		if ( 10000 <= intHour ) {
			strInterval = "9999:59:59.99";
		}
		else {

			// Ԃ̃tH[}bg
			DecimalFormat objHourFormat = new DecimalFormat( "0000" );
			String strHour = objHourFormat.format( intHour );

			// ̃tH[}bg
			DecimalFormat objMinuteFormat = new DecimalFormat( "00" );
			String strMinute = objMinuteFormat.format( intMinute );

			// b̃tH[}bg
			DecimalFormat objSecondFormat = new DecimalFormat( "00.##" );
			String strSecond = objSecondFormat.format( fltSecond );

			strInterval = strHour + ":" + strMinute + ":" + strSecond;
		}
		return strInterval;
	}


	/**
	 * AICC2.x`̓tAԕ𕪐͂SCORM1.3`<br>
	 * YYYY-MM-DDThh:mm:ss.sTZD `̕ɕϊ <br>
	 * @param strDate yyyy/MM/dd`̓t
	 * @param strTime HH:mm:ss.SS`̓t
	 * @return String tɕϊl
	 * @exception S13LogFormatException ϊɎsꍇ
	 */
	public static String parseS13Date( String strDate, String strTime )
		throws S13LogFormatException
	{
		Date objDate = null;
		String strRetDate = "";
		// p[^`FbN
		if(((strDate == null) || ("".equals(strDate) == true)) &&
			((strTime == null) || ("".equals(strTime) == true))) {
			throw new S13LogFormatException(
				"Invalid DateTime : " + strDate );
		}
		if ((strDate == null) || ("".equals(strDate) == true)) {
			strDate = getSystemDate("yyyy/MM/dd");
		}
		if ((strTime == null) || ("".equals(strTime) == true)) {
			strTime = "00:00:00.00";	// lݒ
		}

		/*
		 * t񂩂DateIuWFNg𐶐
		 */
		// tIuWFNg擾iparsejp̃CX^X𐶐
		DateFormat objParseFormat = 
			new SimpleDateFormat( "yyyy/MM/dd HH:mm:ss.SS" );

		// t̃tH[}bgϊp̃CX^X𐶐
		DateFormat objFormat = 
			new SimpleDateFormat( "yyyy-MM-dd HH:mm:ss.SS" );
		objParseFormat.setLenient( false );
		try {
			int iPos = strTime.indexOf(".");
			if (iPos == -1) {
				strTime = strTime + ".00";
			}
			objDate = objParseFormat.parse( strDate + " " + strTime );
		}
		catch( ParseException pe ) {
			throw new S13LogFormatException( pe.getMessage() );
		}
		strRetDate = objFormat.format(objDate);
		strRetDate = strRetDate.replace(' ','T');
		return strRetDate;
	}

	/**
	 *  w肵VXet擾
	 *  @return String	VXet
	 */
	public static String getSystemDate(String strFormat)
	{
		DateFormat objFormat = new SimpleDateFormat( strFormat );

		return objFormat.format(new Date());
	}

	/**
	 * AICC2.x`̃Xe[^X̐擪𔻒fSCORM1.3
	 * `̍iXe[^XɕϊB
	 * 擪LȊÓiϊΏۊOj̓̕G[ƂB
	 * <PRE>
	 *    n(not attempted)    unknown
	 *    i(incomplete)       unknown
	 *    f(failed)           failed
	 *    c(completed)        unknown
	 *    p(passed)           passed
	 *    b(browsed)          unknown	
	 * </PRE>
	 * @param strAiccStatus Xe[^X
	 * @return String SCORM1.3`̃Xe[^X
	 * @exception S13LogFormatException
	 */
	public static String parseSuccessStatus( String strAiccStatus )
		throws S13LogFormatException
	{

		// p[^`FbN
		if( (strAiccStatus == null) || ("".equals(strAiccStatus) == true) ) {
			throw new S13LogFormatException(
				"Invalid Status : " + strAiccStatus );
		}

		// AICC2.x̃Xe[^XlSCORM1.3̍iXe[^Xlɕϊ
		String strStatus = "";

		strAiccStatus = strAiccStatus.toLowerCase();	// ɕϊ
		char cstatus = strAiccStatus.charAt(0);

		if( (cstatus == 'n') || (cstatus == 'i') || (cstatus == 'c') ||
			(cstatus == 'b') ) {

			strStatus = "unknown";
		}
		else if (cstatus == 'p') {
			strStatus = "passed";
		}
		else if (cstatus == 'f') {
			strStatus = "failed";
		}
		else {
			throw new S13LogFormatException(
				"Invalid Status : " + strAiccStatus );
		}
		return strStatus;
	}

	/**
	 * AICC2.x`̃Xe[^X̐擪𔻒fSCORM1.3
	 * `̊Xe[^XɕϊB
	 * 擪LȊÓiϊΏۊOj̓̕G[ƂB
	 * <PRE>
	 *    n(not attempted)    unknown
	 *    i(incomplete)       incomplete
	 *    f(failed)           incomplete
	 *    c(completed)        completed
	 *    p(passed)           completed
	 *    b(browsed)          incomplete
	 * </PRE>
	 * @param strAiccStatus Xe[^X
	 * @return String SCORM1.3`̃Xe[^X
	 * @exception S13LogFormatException
	 */
	public static String parseCompletionStatus( String strAiccStatus )
		throws S13LogFormatException
	{

		// p[^`FbN
		if( (strAiccStatus == null) || ("".equals(strAiccStatus) == true) ) {
			throw new S13LogFormatException(
				"Invalid Status : " + strAiccStatus );
		}

		// AICC2.x̃Xe[^XlSCORM1.3̍iXe[^Xlɕϊ
		String strStatus = "";

		strAiccStatus = strAiccStatus.toLowerCase();	// ɕϊ
		char cstatus = strAiccStatus.charAt(0);

		if( cstatus == 'n' ) {
			strStatus = "unknown";
		}
		else if ((cstatus == 'i') || (cstatus == 'f') || (cstatus == 'b')) {
			strStatus = "incomplete";
		}
		else if ((cstatus == 'c') || (cstatus == 'p')) {
			strStatus = "completed";
		}
		else {
			throw new S13LogFormatException(
				"Invalid Status : " + strAiccStatus );
		}
		return strStatus;
	}

	/**
	 * SCORM1.3`̂Q̃Xe[^X𔻒fāAAICC2.x`
	 * Xe[^XɕϊB
	 * LȊÓiϊΏۊOj̓̕G[ƂB
	 * <PRE>
	 *    success_status  completion_status  
	 *        unknown         unknown          not attempted
	 *        unknown         incomplete       incomplete
	 *        unknown         completed        completed
	 *        failed          -                failed
	 *        passed          -                passed
	 * </PRE>
	 * @param strSuccessStatus iXe[^X
	 * @param strCompStatus Xe[^X
	 * @return String AICC2.x`̃Xe[^X
	 * @exception S13LogFormatException
	 */
	public static String parseAiccStatus(
			String strSuccessStatus, String strCompStatus)
		throws S13LogFormatException
	{

		// p[^`FbN
		// Success_status̃`FbN
		if( (strSuccessStatus == null) || "".equals(strSuccessStatus)) {
			throw new S13LogFormatException(
				"Invalid Success_status : " + strSuccessStatus );
		}
		// Completion_status̃`FbN
		if( (strCompStatus == null) || "".equals(strCompStatus)) {
			throw new S13LogFormatException(
				"Invalid Completion_status : " + strCompStatus );
		}

		String strStatus = "";

		// SCORM1.3̃Xe[^XlAICC2.xXe[^Xlɕϊ
		if(("unknown".equalsIgnoreCase(strSuccessStatus) == true)
			&& ("unknown".equalsIgnoreCase(strCompStatus) == true)) {

				strStatus = "not attempted";
		}
		else if(("unknown".equalsIgnoreCase(strSuccessStatus) == true)
			&& ("incomplete".equalsIgnoreCase(strCompStatus) == true)) {

				strStatus = "incomplete";
			
		}
		else if(("unknown".equalsIgnoreCase(strSuccessStatus) == true)
			&& ("completed".equalsIgnoreCase(strCompStatus) == true)) {

				strStatus = "completed";
			
		}
		else if( "failed".equalsIgnoreCase(strSuccessStatus) == true ) {

				strStatus = "failed";
			
		}
		else if( "passed".equalsIgnoreCase(strSuccessStatus) == true ) {

				strStatus = "passed";
			
		}
		else {
			throw new S13LogFormatException(
				"Invalid Success_status : " + strSuccessStatus + CHAR_CRLF +
				"Invalid Completion_status : " + strCompStatus);
		}
		return strStatus;
	}

	/**
	 * AICC2.x`Scorerawl𔻒fāASCORM1.3`Scorescaledl
	 * ϊB
	 * <PRE>
	 *    ϊ
	 *      Scorerawl-101ȉA܂101ȏ̏ꍇ
	 *        Scorescaledl = 0iŒlj
	 *      Scorerawl-100ȏ100ȉ̏ꍇ
	 *        Scorescaledl = Scorerawl / 100
	 * </PRE>
	 * @param strAiccScore String AICC2.xScorerawl
	 * @return String SCORM1.3`Scorescaledl
	 */
	public static String parseS13Score(String strAiccScore)
		throws S13LogFormatException
	{
		String strScore = "";
		// p[^`FbN
		// ScoreRawl̃`FbN
		if( (strAiccScore == null) || "".equals(strAiccScore)) {
			throw new S13LogFormatException(
				"Invalid Score raw : " + strAiccScore );
		}

		// AICC2.x`Scorerawlscaled̒l߂
		try {
			float fScoreRaw = Float.parseFloat(strAiccScore);
			if ((-100 <= fScoreRaw) && (fScoreRaw <= 100)) {
				fScoreRaw = fScoreRaw / 100;
			}
			else if ((fScoreRaw < -100) || (100 < fScoreRaw)) {
				fScoreRaw = 0;
			}
			strScore = Float.toString(fScoreRaw);
		}
		catch( NumberFormatException ne ) {
			throw new S13LogFormatException( ne.getMessage() );
		}
		return strScore;
	}

	/**
	 * XRAp̃f[^f擾<br>
	 * @return String ip̃f[^f
	 */
	public static String getCheckScoreName() {
		String strName;
		if (isScorm13() == true) {
			// MfʂASCORM1.3 f̏ꍇ
			strName = "core.score.scaled";
		}
		else {
			// MfʂAAICC f̏ꍇ
			strName = "core.score.raw";
		}
		return strName;
	}

	/**
	 * Mf̎ʂݒ肷<br>
	 * SCORM1.3f[^fȂtrueAAICC2.xf[^fȂfalse
	 * ݒ肷<br>
	 * @param bType boolean f[^f
	 */
	public static void setScorm13(boolean bType) {
		m_bScorm13Type = bType;
	}

	/**
	 * ݂̎MfSCORM1.3ł邩mF<br>
	 * SCORM1.3f[^fȂtrueAAICC2.xf[^fȂfalse
	 * ԋp<br>
	 * @return boolean f[^f
	 */
	public static boolean isScorm13() {
		return m_bScorm13Type;
	}

}
