/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

//
//@\ 
//			CMI f[^f@vfNX
//	ύX
//				2003.11.25	lcg  VK쐬		
//
package jp.co.ntt.lms.lo.scorm.cbtcom;

import java.lang.NumberFormatException;
//import java.util.StringTokenizer;
 
/**
 * CMI f[^f@vfNX
 * @author lcg
 */
public abstract class CMIElement {
	
	/**
	 * CMI AICC o[W
	 */
	public static final String DEF_CMI_AICC_VERSION = "3.0.2";
	
	/**
	 * sR[h
	 */
	public static final String CHAR_CRLF = "\r\n";
   
	/**
	 * sR[h
	 */
	public static final String STR_CRLF = CHAR_CRLF;
   
	/**
     * S(ʏ)
     */
	private int INIT_FULL = 0;
   
	/**
     * ZbV
     */
	private int INIT_SESSION = 1;
   
	/**
     * arraŷƂ̗vfԍ
     * array̗vfłȂƂ́A-1Aŏ̗vf́A0
     */
	protected int m_arrayIndex = -1;
   
	/**
     * vg^CvEf[^
     */
	protected CMIElementProto m_proto = null;
   
	/**
     * eIuWFNg
     */
	protected CMIElement m_parent = null;
   
	/**
     * CBTIuWFNg
     */
	protected CMICBT m_CBT = null;
   
	/**
     * CBTIuWFNg
     */
	protected CMIGlobalCBT m_GCBT = null;
   
	/**
     * lNULLl
     */
	protected boolean m_ValueIsNULL = true;
   
	/**
     * NJEgl
     */
	protected int m_LinkCount = 0;
   
	/**
     * setValue ɂXV
     */
	protected boolean m_bySetValue = false;
   
	/**
     * protof[^VKɍ쐬ꂽǂ̃tO
     */
	protected boolean m_isProtoAllocated = false;
   
	/**
     * CMIElementNX̃RXgN^<br>
     * @param proto vg^CvEf[^
     */
	public CMIElement(CMIElementProto proto) {
		m_proto = proto;
		m_arrayIndex = -1;
		m_parent = null;
		m_CBT = null;
		m_GCBT = null;
		m_ValueIsNULL = true;
		m_LinkCount	= 0;
		m_bySetValue = false;
		m_isProtoAllocated = false;
   }
   
	/**
     * CMIElementNX̃RXgN^<br>
     */
	public CMIElement() {

	   m_arrayIndex	= -1;
	   m_parent = null;
	   m_CBT = null;
	   m_GCBT = null;
	   m_ValueIsNULL = true;
	   m_LinkCount = 0;
	   m_bySetValue = false;
	   m_isProtoAllocated = false;
	}
	
	/**
	 * e ̐ݒ <br>
	 * @param parent
	 */
	public void setParent( CMIElement parent) {
		this.m_parent = parent;
	}
   
	/**
     * CBT ݒ <br>
     * @param cbt
     */
	public void setCBT( CMICBT cbt) {
		this.m_CBT = cbt;
	}
   
	/**
	 * CBT 擾 <br>
	 * @return CMICBT CMICBTIuWFNg
	 */
	public CMICBT getCBT() {
		return m_CBT;
	}
   
	/**
     * CBT ݒ <br>
     * @param@ gcbt CMIGlobalCBT O[oCBTIuWFNg
     */
	public void setGCBT( CMIGlobalCBT gcbt) {
		m_GCBT = gcbt;
   	}
   
	/**
	 * GCBT 擾 <br>
	 * @return CMIGlobalCBT O[oCBTIuWFNg
	 */
	public CMIGlobalCBT getGCBT() {
		return m_GCBT;
	}
   
	/**
	 * vf̎擾 <br>
	 * @return String vf 
	 * 			z̗vf̂Ƃim_arrayIndexj́ACfNXԍ𖼑OƂĕԂB
	 * 			ȊÔƂ́Avgf[^̖OԂB		
	 */
	public String getName() {
		String strName = null;
		if ( 0 <= m_arrayIndex ) {
			strName = String.valueOf( m_arrayIndex );
		} else {
			strName = m_proto.getName();
		}
		return strName;
	}
   
	/**
	 * L[[h̎擾 <br>
	 * @return String L[[h 
	 */
	public String getKeyWord() {
		String strKeyWord = m_proto.getKeyWord();
		if ( null == strKeyWord ) {
			String strName = m_proto.getName();
			strKeyWord = CMIUtil.makeKeyWord(strName);
		}
		return strKeyWord;
   }
   
	/**
	 * nulll  <br>																				
	 * @return boolean nulll̔
	 */
	public boolean isNull() {
		return m_ValueIsNULL;
	}
   
	/**
	 * zvfԍ ݒ <br>																				
	 * @param index
	 */
	public void setArrayIndex(int index) {
		m_arrayIndex = index;
	}
   
	/**
	 * zvfԍ 擾 <br>																				
	 * @return int zvfԍ
	 */
	public int getArrayIndex() {
		return m_arrayIndex;
	}
   
	/**		
	 * NJE^̃CNg <br>	
	 * @return int NJE^̒l
	 */	
	public int incrementLinkCount() {
		m_LinkCount++;
		return m_LinkCount;
	}
   
	/**		
	 * NJE^̃fNg <br>	
	 * @return int NJE^̒l
	 */
	public int decrementLinkCount() {
		return ( m_LinkCount > 0 ) ? ( --m_LinkCount ) : m_LinkCount;
	}
   
	/**
     * NJE^ 擾 <br>
     * @return int NJE^
     */
	public int getLinkCount() {
	    return m_LinkCount;
	}
   
	/**
     * SetValues ̎擾 <br>
     * @return boolean SetValues
     */
	public boolean isSetValue() {
		return m_bySetValue;
	}
	
	/**
	 * SetValues󋵂 Zbg <br>
     */
	public void resetSetValue() {
		m_bySetValue = false;
	}
   
	/**
     * vgf[^vtÕZbg
     */
	public void setIsProtoAllocated( boolean value ) {
		m_isProtoAllocated = value;
	}
   
	/**
	 * vgf[^ ̎擾  <br>
	 * @return CMIElementProto vgf[^
	 */
	public CMIElementProto getElementProto() {
		return m_proto;
	}
   
	/**		
	 * O[o ̔  <br>	
	 * @return boolean O[o  	
	 */	
	public boolean isGlobal() {
		return m_proto.getIsGlobal();
	}
   
	/**		
	 * ZbV  <br>	
	 * @return boolean ZbV 	
	 */
	public boolean isSession() {
		return m_proto.getIsSession();
	}
   
	/**		
	 * [   <br>	
	 * @return boolean [  	
	 */
	public boolean isLeaf() {
		return m_proto.getIsLeaf();
	}
   
	/**
     * z 
     * @return boolean z 
     */
	public boolean isArray() {
		return m_proto.getIsArray();
	}
   
	/**
     * Get ۔
     * @return boolean Getۏ
     */
	public boolean isReadable() {
		return m_proto.getIsReadable();
	}
   
	/**
     * Set ۔
     * @return boolean Setۏ
     */
	public boolean isWritable() {
		return m_proto.getIsWritable();
	}
   
	/**
     * Set K{    <br>
     * @return boolean K{ȂtrueAłȂȂfalse
     */
	public boolean isMandatory() {
		return m_proto.getIsMandatory();
	}
   
	/**
     * VACY   <br>
     * @return boolean
     */
	public boolean isSerializable() {
	    return m_proto.getIsSerializable();
	}
   
	/**
     * CBTo[W 3 ȏł邱Ƃ̔  <br>
     * @return boolean true:3 ȏ̏ꍇ / false:̑
     */
	public boolean isV3Above() {
		boolean blnRet = false;
		CMICBT cbt = getCBT();
		blnRet = cbt.isV3Above();	
		return blnRet;
	}
   
	/**
     * CMIo[W 3 ȏł邱Ƃ̔  <br>
     * @return boolean true:3 ȏ̏ꍇ / false:̑
     */
	public boolean isCMIV3Above() {
		boolean blnRet = false;
		CMICBT cbt = getCBT();
		blnRet = cbt.isCmiV3Above();
		return blnRet;
	}
   
	/**
     * CMIo[W 3 ȏł邱Ƃ̔  <br>
     * @return int true:3 ȏ̏ꍇ / false:̑
     */
	public int getVersion() {
		String strVer = null;
		int intVer;
		CMICBT cbt = getCBT();
		
		// CBTo[W擾
		strVer = cbt.getVersionStr();
	
		if (  null == strVer || "".equals(strVer) ) {
			strVer = DEF_CMI_AICC_VERSION;
		}
	
		intVer = getVersionInteger(strVer);

		return intVer;
	}
   
	/**
     * CBTo[W𐮐^ƂĎ擾  <br>
     * @param version String o[W
     * @return int CBTo[W𐮐Ƃĕԋp
     */
	public int getVersionInteger(String version) {

		//J}Ȃo[W
		StringBuffer sb = new StringBuffer();
		
		//}Ci[ԍ
		int  intLen = 0;
		
		//J}Ŝ̌
		int  intVerFig = 0;
		
		//_݃tO
		boolean blnIndexDot = false;
		
		char [] chrVersion = version.toCharArray();
		
		// o[W񂪑݂ԃ[v
		for ( int i = 0 ; i < chrVersion.length ; i++ ) {
		
			// o[W񂪃hbgȊȌꍇ
			if  ( chrVersion[i]  !=  '.' ) {
		
				// o[W̕i[
				sb.append( chrVersion[i] );
		
				// ɏ_݂ĂꍇA_ȉCNg
				if ( blnIndexDot ) {
					intLen++;
				}
				// ŠCNg
				intVerFig++;
			}
			// _ȑOɂȂꍇA_tOTrueɂ
			else if ( !blnIndexDot ) {
				blnIndexDot = true;
			}
		} // [v܂
		
		// }Ci[ԍ3ɖȂꍇAs0Ō߂
		if ( intLen < 3 ) {
			for ( int i = 0; i < 3 - intLen; i++ ) {
				sb.append( '0' );
			}
		}
		int intVersion;
		// o[Wint^ɕϊ
		try{
			intVersion = Integer.parseInt( sb.toString() );
		}catch( NumberFormatException ex ) { 
			intVersion = 0;
		}
		return intVersion;
	}
   
	/**
     * ΏۂL[[h`FbN  <br>
     * @return boolean L[[h̏ꍇFtrueAL[[hłȂꍇFfalse
     */
	public boolean checkParamKeyword(String paramName) {
		if( paramName == null || "".equals( paramName ) ) {
   			return false;
		}
		//L[[hz̐ݒ
	   	String [] strKeyArray = {"_children","_count","core","objectives"
	   										,"evaluation","interactions","tries"
	   										,"student_data","paths","attempt_records"
	   										,"cmi","student_preference","score"
	   										,"correct_responses","lesson_score"
	   										,"student_demographics"
	   									};
	   	boolean blnExist = false;
	   	for ( int i = 0; i< strKeyArray.length; i++ ) {
	   		if ( paramName.equals( strKeyArray[i] ) ) {
	   			blnExist = true;
	   			break;
	   		}
	   	}
	   	return blnExist;
	}
   
	/**
     * f[^fvfCMINodȅꍇ̃tH[}bg`FbN <br>
     * @param@ value@`FbNf[^
     * @param@ dataType f[^^
     * @param@ name@`FbNf[^
     * @return	 boolean lꍇ(܂):trueAlȊȌꍇ:false
     */
	public boolean checkCMIDataType(String value, int dataType, String name) {
   	
		boolean blnCheck = true;

		if ((value == null) || "".equals(value) == true ) {
			return true;
		}
	
		// ΏۃGg̃f[^^ɂA`FbN𕪊򂷂
		switch(dataType){
			case CMIElementProto.CMIDecimal:
				blnCheck = checkCMIDecimal(value);
				break;
				
			// CMIIdentifer^̃`FbN
			case CMIElementProto.CMIIdentifier:
				blnCheck = checkCMIIdentifer(value);
				break;
			
			// CMIInteger^̃`FbN
			case CMIElementProto.CMIInteger:
				blnCheck = checkCMIInteger(value);
				break;
			
			// CMISInteger^̃`FbN
			case CMIElementProto.CMISInteger:
				blnCheck = checkCMISInteger(value);
				break;
			
			// CMIString256^̃`FbN
			case CMIElementProto.CMIString256:
				blnCheck = checkCMIString256(value);
				break;
			
			// CMIString1000^̃`FbN
			case CMIElementProto.CMIString1000:
				blnCheck = checkCMIString1000(value);
				break;
			
			// CMIString4096^̃`FbN
			case CMIElementProto.CMIString4096:
				blnCheck = checkCMIString4096(value);
				break;
			
			// CMITimespan^̃`FbN
			case CMIElementProto.CMITimespan:
				blnCheck = checkCMITimespan(value);
				break;
			
			// CMIVocabulary^̃`FbN
			case CMIElementProto.CMIVocabulary:
				blnCheck = checkCMIVocabulary(value, name);
				break;
			
			// CMINoType^̏ꍇ̓`FbNsȂ
			default:
				blnCheck = true;
				break;
		}
		return blnCheck;
	}
   
	/**
     * JgGggbv܂ł̃pX𐶐B<br>
     * pX́A擾obt@ɒǉĂB<br>
     * eIuWFNgꍇ́AċNĂяoĂApXǉ <br>
     * @return String ̃pX
     */
	public String getPath() {
	   	StringBuffer sb = new StringBuffer();
	   	
		//eIuWFNgĂяo
		if ( m_parent != null ) {
			sb.append( m_parent.getPath() );
			sb.append( "." );
		}
		// ̂擾obt@ɒǉ
		sb.append( getName() );
		return sb.toString();
	}
   
	/**
     * JgGggbv܂ł̃pX𐶐B<br>
     * pX́A擾obt@ɒǉĂB<br>
     * eIuWFNgꍇ́AċNĂяoĂApXǉB <br>
     * @param outStr StringBuffer pX
     * @return boolean 擾(true-L , false-)
     */
	public boolean getKeyPath( StringBuffer outStr ) {
		// z̏ꍇ́A
		boolean blnIsArray = m_proto.getIsArray();
		if ( blnIsArray ) {
			return false;
		}
		/// eIuWFNgĂяo
		if ( m_parent != null ) {
			boolean blnParent = false;
			blnParent = m_parent.getKeyPath( outStr );
			
			if  ( !blnParent ) {
				return false;
			}
			outStr.append( "." );
		}
	
		/// ̂擾obt@ɒǉ
		outStr.append( getName() );
		
		return true;
   }
   
	/**
     * setAllValuep̒l擾<br>
     * @param value GR[hꂽl
     * @return String GR[hl
     */
	private String putValue(String value) {
		if ( null == value ) {
			return "#";
		}
		String strRet = new String();
		strRet = CMIUtil.urlEncode( value );
		return strRet;
	}
   
	/**
     * f[^CMIDecimal^`FbN<br>
     * @param value `FbNꂽl
     * @return boolean f[^ƌ^vꍇFtrueAf[^ƌ^vȂꍇFfalse
     */
	private boolean checkCMIDecimal(String value) {
		
		// 
		boolean blnCheck = false;
		
		// lł邩𒲂ׂ
		blnCheck = CMIUtil.isNumeric( value, false );
		
		return blnCheck;
	}
   
    /**
     * f[^CMIIdentifer^`FbN<br>
     * @param value String `FbNꂽl
     * @return boolean f[^ƌ^vꍇFtrueAf[^ƌ^vȂꍇFfalse
     */
	private boolean checkCMIIdentifer(String value) {
		//
		boolean blnCheck = false; 
	
		blnCheck = CMIUtil.checkIdentifier(value);
	
		return blnCheck;
	   }
   
	/**
     * f[^CMIInteger^`FbN<br>
     * @param value String `FbNꂽl
     * @return boolean f[^ƌ^vꍇFtrueAf[^ƌ^vȂꍇFfalse
     */
	private boolean checkCMIInteger(String value) {
		
		// 
		boolean blnCheck = false;
		boolean blnIsNum = CMIUtil.isNumber(value);
		
		if ( blnIsNum ) {
			// f[^065536̊Ԃł
			try {
				int intNumber = Integer.parseInt( value );
				if ( 0 <= intNumber && intNumber <= 65536 ) {
					blnCheck = true;
				}
			} catch ( NumberFormatException ex) {
				blnCheck = false;
			}
		}
		return blnCheck;
	}
   
	/**
     * f[^CMISInteger^`FbN<br>
     * @param value String `FbNꂽl
     * @return boolean f[^ƌ^vꍇFtrueAf[^ƌ^vȂꍇFfalse
     */
	private boolean checkCMISInteger(String value) {
		
		//
		boolean blnCheck = false;
		
		boolean blnIsNum = CMIUtil.isNumeric(value, true);
		
		// valuelłA-32768`32768͈͓̔̏ꍇATrueԋp
		if ( blnIsNum ) {
			try {
				int intNumber = Integer.parseInt( value );
				if ( -32768 <= intNumber && intNumber <= 32768 ) {
					blnCheck = true;
				}
			} catch ( NumberFormatException ex) {
				blnCheck = false;
			}
		}
		return blnCheck;
   }
   
	/**
     * f[^CMIString256^`FbN<br>
     * @param value String `FbNꂽl
     * @return boolean f[^ƌ^vꍇFtrueAf[^ƌ^vȂꍇFfalse
     */
	private boolean checkCMIString256(String value) {
		
		//
		boolean blnCheck = false; 

		// o[W̎擾
		int version = getVersion();

		// o[W3.4ȍ~̏ꍇ́ACMIString255^ƂȂ
		// f[^255ȓł΁AʂTrueɂ
		if ( 3400 <= version || CMIS13ModelUtil.isScorm13() == true) {
			if ( value.length( ) <= 255 ) {
				blnCheck = true;
			}
		}
		// o[W3.4ȑȌꍇ́ACMIString256^ƂȂ
		// f[^256ȓł΁AʂFalseɂ
		else {
			if ( value.length() <= 256 ) {
				blnCheck = true;
			}
		}
		// ʂ̕ԋp
		return blnCheck;
   }
   
	/**
     * f[^CMIString4096^`FbN<br>
     * @param value String `FbNꂽl
     * @return boolean f[^ƌ^vꍇFtrueAf[^ƌ^vȂꍇFfalse
     */
	private boolean checkCMIString4096(String value) {
		//
		boolean blnCheck = false; 

		// f[^4096ȓłΌʂTrueɂ
		if ( value.length() <= 4096 ) {
			blnCheck = true;
		}
		return blnCheck;   
	}

   
	/**
	 * f[^CMIString1000^`FbN<br>
	 * @param value String `FbNꂽl
	 * @return boolean f[^ƌ^vꍇFtrueAf[^ƌ^vȂꍇFfalse
	 */
	private boolean checkCMIString1000(String value) {
		//
		boolean blnCheck = false; 

		// f[^1000ȓłΌʂTrueɂ
		if ( value.length() <= 1000 ) {
			blnCheck = true;
		}
		return blnCheck;   
	}
   
	/**
     * f[^CMITimespan^`FbN<br>
     * @param value String `FbNꂽl
     * @return boolean f[^ƌ^vꍇFtrueAf[^ƌ^vȂꍇFfalse
     */
	private boolean checkCMITimespan(String value) {
		
		//
		boolean blnCheck = false; 
		
		try {
			CMIS13ModelUtil.parseTimeintervalToLong(value);
			blnCheck = true;
		}
		catch (S13LogFormatException ex) {
			blnCheck = false;
		}
		
		return blnCheck; 
	}
   
	/**
     * setValue<br>
     * @param name O
     * @param value l
     * @param doCheck `FbNtO
     */
	public abstract void localSetValue(String name, String value, boolean doCheck);
   
	/**
     * f[^CMIVocabulary^`FbN<br>
     * @param value `FbNꂽl
     * @param name `FbNꂽO
     * @return boolean f[^ƌ^vꍇFtrueAf[^ƌ^vȂꍇFfalse
     */
	private boolean checkCMIVocabulary(String value, String name) {
   	
		//
		boolean blnCheck = false; 
	
		name = name.toLowerCase();
		value = value.toLowerCase();
	
		if ( (value == null) || ("".equals(value) == true) ) {
			return true;
		}
	
		if ( "mode".equals( name ) || "lesson_mode".equals( name ) ) {
			if ( "normal".equals( value ) || "browse".equals( value ) || "review".equals( value ) ||
			   value.charAt(0) == 'n' || value.charAt(0) == 'b'   || value.charAt(0) == 'r'  ) {
				blnCheck = true;
			}
		} else if ( "status".equals( name ) || "lesson_status".equals( name )  ) {
			// Mo[WSCORM1.3̏ꍇ
			if ( "passed".equals( value ) || "failed".equals( value ) ||
				"unknown".equals( value ) ) {
				blnCheck = true;
			}
		} else if ( "completion_status".equals( name ) ) {
			// Mo[WSCORM1.3̏ꍇ̂ݎs
			if ( "completed".equals( value ) || "incomplete".equals( value ) ||
				"unknown".equals( value ) ) {
				blnCheck = true;
			}
		} else if ( "exit".equals( name ) ) {
			if ( "time-out".equals( value ) || "suspend".equals( value ) || "logout".equals( value ) ||
			   value.charAt(0) == 't'	   ||  value.charAt(0) == 's'	 ||  value.charAt(0) == 'l'   ) {
				blnCheck = true;
			}
		} else if ( "why_left".equals( name ) ) {
			if( "student selected".equals( value ) || "lesson directed".equals( value ) ||
				"exit".equals( value ) || "directed departure".equals( value ) ||
				value.charAt(0) == 's' || value.charAt(0)  == 'l' || value.charAt(0)  == 'e' ||
				value.charAt(0)  == 'd')	{
					blnCheck = true;
			}
		} else if ( "credit".equals( name ) ) {
			if ( "credit".equals( value ) || "no-credit".equals( value ) ||
			   value.charAt(0) == 'c'	 || value.charAt(0) == 'n'		 ) {
				blnCheck = true;
			}
		} else if ( "entry".equals( name ) ) {
			if ( "ab-initio".equals( name ) || "ab initio".equals( name ) ||  "resume".equals( name ) ||
			   value.charAt(0) == 'a' || value.charAt(0) == 'r' ) {
				blnCheck = true;
			}
		} else if ( "time_limit_action".equals( name )) {
			if ( "exit, message".equals( value ) || "exit, no message".equals( value )||
				"continue, message".equals( value ) || "continue, no message".equals( value )	||
				value.charAt(0) == 'e' || value.charAt(0) == 'c'){
					blnCheck = true;
			}
		} else if ("type".equals( name ) ) {
			if ( "true-false".equals( value ) ||  "choice".equals( value ) ||
				"fill-in".equals( value ) || "matching".equals( value ) ||
				"performance".equals( value ) || "likert".equals( value ) ||
				"sequencing".equals( value ) || "unique".equals( value ) ||
				 "numeric".equals( value ) || value.charAt(0) == 't' || 
				 value.charAt(0)== 'c' || value.charAt(0)== 'f' || value.charAt(0) == 'm' || 
				 value.charAt(0) == 'p' || value.charAt(0) == 'l' ||	value.charAt(0) == 's' || 
				 value.charAt(0) == 'u' || value.charAt(0) == 'n' ) {
					blnCheck = true;
			}
		} else if( "result".equals( name ) ) {
			if ( "correct".equals( value ) || "wrong".equals( value )	|| "incorrect".equals( value )	||
				"unanticipated".equals( value ) || "neutral".equals( value )	||
				CMIUtil.isNumeric(value, false)	 || value.charAt(0) == 'c' ||
				value.charAt(0) == 'w' || value.charAt(0) == 'u' || value.charAt(0) == 'n') {
				blnCheck = true;
			}
		}
	
		return blnCheck;
	}
   
	/**
     * f[^CMIVocabulary^`FbN<br>
     * @return String VACYf[^
     */
	protected String serializeCMIValue() {
   	    
		StringBuffer sbOut = new StringBuffer();
		String strName = getName();
		String strLocalValue = getLocalValue();
		String strLessonValue = getLessonValue();
		
		strLocalValue = putValue ( strLocalValue );
		strLessonValue = putValue( strLessonValue );
	
		sbOut.append(strLocalValue);
		sbOut.append(":");
		sbOut.append(strLessonValue);
		//VACYf[^𕜋A
		return sbOut.toString();
	}
   
	/**
	 * VACYf[^𓀂AlZbg<br>
     * @param data String VACYꂽf[^
     */
	protected void deserializeCMIValue(String data) {
   	
		String strLocalValue = "";
		String strLessonValue = "";
		int iLessonPos = data.indexOf(":");
		if (iLessonPos != -1) {
			strLocalValue = data.substring(0,iLessonPos);
			strLessonValue = data.substring(iLessonPos+1,data.length());
		}
			
		if ( null != strLocalValue && !"#".equals( strLocalValue ) ) {
			strLocalValue = CMIUtil.urlDecode( strLocalValue );
			setLocalValue( strLocalValue );
			m_bySetValue = true;
		}
		if ( null != strLessonValue && !"#".equals( strLessonValue ) ) {
			strLessonValue = CMIUtil.urlDecode( strLessonValue );
			setLessonValue( strLessonValue );
			m_bySetValue = true;
		}
	}
   
	/**
     * lݒ肷BGgpXŎw肵GgɒlZbg<br>
     * @param name GgpX
     * @param value l
     */
	public abstract void localSetValue(String name, String value);
   
	/**
     * l擾BGgpXŎw肵Ggɒl擾<br>
     * @param name GgpX
     * @param doCheck `FbNtO
     * @return String 擾ꂽl
     */
	public abstract String localGetValue(String name, boolean doCheck);
   
	/**
     * l擾BGgpXŎw肵Ggɒl擾<br>
     * @param name GgpX
     * @return String 擾ꂽl
     */
	public String localGetValue(String name) {
    	return localGetValue( name, true );
	}
   
    /**
     * localValue ̒lݒ肷<br>
     * @param name GgO
     */
	public abstract void setLocalValue(String name);
   
    /**
     * localValue ̒lݒ肷<br>
     * @param name GgO
     * @param value ݒ肳ꂽl
     */
	public abstract void setLocalValue(String name, String value);
   
	/**
     * localValue ̒l擾<br>
     * @return String 擾ꂽl
     */
	public abstract String getLocalValue();
   
	/**
     * localValue ̒lnullǂ̔f<br>
     * @return boolean 擾ꂽl
     */
	public abstract boolean getIsNullValue();

	/**
     * localValue ̒l擾<br>
     * @param name String O
     * @return String 擾ꂽl
     */
	public abstract String getLocalValue(String name);
   
	/**
     * lessonValue ̒lݒ肷<br>
     * @param value String ݒ肳ꂽl
     */
	public abstract void setLessonValue(String value);
   
	/**
     * lessonValue ̒lݒ肷<br>
     * @param name String GgO
     * @param value String ݒ肳ꂽl
     */
	public abstract void setLessonValue(String name, String value);
   
	/**
	 * lessonValue ̒l擾<br>
	 * @return String 擾ꂽl
	 */
	public abstract String getLessonValue();
   
    /**
     * lessonValue ̒l擾<br>
     * @param name String O
     * @return String 擾ꂽl
     */
	public abstract String getLessonValue(String name);
   
	/**
     * localValue l<br>
     */
	public abstract void initLocalValue(); 
   
	/**
     * localValue l<br>
     * @param value String ̒l
     */
	public abstract void initLocalValue(String value);
   
	/**
     * lessonValue l<br>
     */
	public abstract void initLessonValue();
   
	/**
     * localValue l<br>
     * @param name String ꂽpX
     */
	public abstract void initLessonValue(String name);
   
	/**
	 * K{`FbN <br>
	 * @return boolean K{͂̏ꍇ:trueAK{͂Ȃꍇ:false
	 */
	public abstract boolean checkMandatory(); 
   
	/**
	 * ftHglZbg <br>
	 */
	public abstract void setDefaultValue();
   
	/**
	 * O <br>
	 */
	public abstract void before_initialize();
   
	/**
	 *  <br>
	 */
	public abstract void initialize();
   
	/**
	 * VACY <br>
	 * lVACYf[^𐶐B<br>
	 * @param buf StringBuffer VACYf[^
	 */
	public abstract void serialize(StringBuffer buf);
   
	/**
	 * p[^̎擾 <br>
	 * VACYf[^𓀂AlZbg<br>
	 * @param inString String VACYf[^
	 */
	public abstract void deserialize(String inString);
   
	/**
	 * fVACY <br>
	 * @param buf StringBuffer f[^obt@
	 * @return int G[R[h
	 */
	public int getParam(StringBuffer buf) {
		int intErrCode = HACPError.HACP_ERR_SUCCESSFUL;
	
		IMaintenanceGetParam maintenanceGetParam = m_proto.getMaintenanceGetParam();
	
		if ( maintenanceGetParam != null ) {
			intErrCode = maintenanceGetParam.getParam(this, buf);
		} else {
			intErrCode = getParamSub(buf);
		}
		return intErrCode;
	}

	/**
	 * p[^̐ݒ <br>
	 * @param name String O
	 * @param inString String f[^
	 * @return int G[R[h
	 */
	public int putParam(String name, String inString) {
		int intErrCode = HACPError.HACP_ERR_SUCCESSFUL;
		IMaintenancePutParam maintenancePutParam = m_proto.getMaintenancePutParam();
		StringBuffer sbBuffer = new StringBuffer();
		sbBuffer.append( inString );
		if ( maintenancePutParam != null ) {	
			intErrCode = maintenancePutParam.putParam( this, sbBuffer );
		} else {
			intErrCode = putParamSub(name, inString);
		}
		return intErrCode;
   }
   
	/**
	 * Tup[^擾 <br>
	 * @param value StringBuffer 擾̃f[^
	 * @return int G[R[h
	 */
	public abstract int getParamSub(StringBuffer value);
   
	/**
	 * Tup[^ݒ <br>
	 * @param name String O
	 * @param inString String f[^
	 * @return int G[R[h
	 */
	public abstract int putParamSub(String name, String inString);
   
	/**
	 * PutParamɕKvCMIf[^擾
	 * CMIvgf[^CX^Xɓo^ĂPutParamp̃O[v
	 * f[^擾\bh݂ꍇÃ\bhs <br>
	 * @param buf StringBuffer 擾̃f[^
	 * @return int G[R[h
	 */
	public int getPutParam(StringBuffer buf) {
		int intErrCode = HACPError.HACP_ERR_SUCCESSFUL;
		IMaintenanceGetPutParam maintenanceGetPutParam = m_proto.getMaintenanceGetPutParam();
		
		if ( maintenanceGetPutParam != null ) {
			// CMIvgf[^CX^XPutParamp̃O[vf[^擾
			// \bh݂ꍇÃ\bhs
			intErrCode = maintenanceGetPutParam.getPutParam(this, buf);
		}
		return intErrCode;
	}
   
	/**
	 * G[R[hݒ肷
	 * @param code int G[R[h
	 */
	public void setError(int code) {
		if ( m_CBT != null ) {
			m_CBT.setError(code);
		} else {
			m_GCBT.setError(code);
		}
	}
   
	/**
	 * G[R[h擾
	 * @return int G[R[h
	 */
	public int getError() {
		int intErrCode;
		if ( m_CBT != null) {
			intErrCode = m_CBT.getError();
		} else {
			intErrCode = m_GCBT.getError();
		}
		return intErrCode;
   }
   
	/**
     * G[R[hݒ肷
     * @param msg String G[bZ[W
     */
	public void setVendorError(String msg) {
		if ( m_CBT != null ) {
			m_CBT.setVendorError(msg);
		} else {
			m_GCBT.setVendorError(msg);
		}
	}
   
	/**
     * fobO(vg^Cv)擾
     * @return String fobO(vg^Cv)
     */
	public abstract String getDebugProto();
   
	/**
     * fobO(CMIf[^)擾擾
     * @return fobO(CMIf[^)擾
     */
	public abstract String getDebugCMIData();
   
	/**
     * bZ[WƃGg琶x_[bZ[W擾B
     * @param buffer String bZ[W
     * @param element CMIElement Gg
     * @return String bZ[W
     */
	public String getVendorData(String buffer, CMIElement element){
		StringBuffer sbBuffer = new StringBuffer();

		if ( buffer != null ) {
			sbBuffer.append(buffer);
		}
		if ( element != null ) {	
			String strPath = element.getPath();
			sbBuffer.append("/");
			sbBuffer.append(strPath);
		}

		return sbBuffer.toString();
	 }
	 
	/**
	 * bZ[W琶x_[bZ[W擾B
	 * @param buffer String bZ[W
	 * @return String x_[
	 */
	public String getVendorData(String buffer){
		return getVendorData(buffer, null);
	}

	/**
	 * ێĂlVACYf[^𐶐B<br>
	 * @param buf StringBuffer VACYXMLf[^
	 */
	public abstract void serializeXMLLog(StringBuffer buf);

	/**
	 * XML`Ńf[^擾<br>
	 * @return String VACYf[^iXML`j
	 */
	protected String serializeXMLValue() {
   	    
		StringBuffer sbOut = new StringBuffer();
		String strName = getName();
		String strLocalValue = getLocalValue();
		String strLessonValue = getLessonValue();

		if ((strLessonValue == null) || "".equals(strLessonValue) ) {
			if (strLocalValue != null) {
				sbOut.append(strLocalValue);
			}
		}
		else {
			sbOut.append(strLessonValue);
		}

		//VACYf[^𕜋A
		return sbOut.toString();
	}

} 
