/*
 * irQ[VvNX
 * 
 * 쐬: 2006/05/11
 */
package jp.co.ntt.lms.imode.lo.scorm.engine;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.xml.transform.stream.StreamResult;

import jp.co.ntt.lms.lo.util.UserIDFolder;
import jp.co.ntt.lms.lo.scorm.engine.Engine;
import jp.co.ntt.lms.lo.scorm.engine.ExecuteParameters;
import jp.co.ntt.lms.lo.scorm.engine.SCORMAPIAdapter;
import jp.co.ntt.lms.lo.scorm.kernel.Activity;
import jp.co.ntt.lms.lo.scorm.kernel.exception.SequencingException;
import jp.co.ntt.lms.lo.scorm.kernel.exception.SystemException;
import jp.co.ntt.lms.lo.scorm.util.Debug;
import jp.co.ntt.lms.lo.scorm.util.SG;
import jp.co.ntt.lms.lo.scorm.util.XMLUtil;
import jp.co.ntt.lms.xmo.util.DebugLog;
import jp.co.ntt.lms.xms.framework.XmsException;
import jp.co.ntt.lms.xms.framework.XmsSystemException;
import jp.co.ntt.lms.xms.framework.XmsWarningException;

import org.w3c.dom.Document;

/**
 * irQ[VvNX<br>
 * SCORMGWɃirQ[VR}hNGXg܂B<br>
 * 
 * <pre>
 * R}h 
 * EwKJn
 * EO
 * E
 * Ef
 * EI
 * </pre>
 * 
 * @author ntc-sakai
 * 
 */
public class NavigateEngine {

	private String scoUrl;
	private String aiccSid;
	private boolean endLearn;

	/**
	 * SCORMGWɃNGXgv܂B
	 * 
	 * @param request NGXg
	 * @param pCommand vR}h
	 * @param activityID ANeBreBID
	 * @throws XmsException
	 */
	public void execute(HttpServletRequest request, String pCommand, String activityID)
		throws XmsException {
		// knfo
		DebugLog.write(getClass(), "[request]:HEAD command = " + pCommand, DebugLog.ROW);

		endLearn = false;
		HttpSession session = request.getSession();
		ServletContext application = session.getServletContext();

		try {
			// Np[^session擾
			ExecuteParameters executeParameters =
				(ExecuteParameters) session.getAttribute("SCORM.EXECUTE_PARAMETERS");

			// session擾łȂꍇ  Session Timeout 
			if (executeParameters == null) {
				// knfo
				DebugLog.write(getClass(),
						"[request]SessionTimeout(executeParameters is null)", DebugLog.HIGHT);
				throw new XmsWarningException("SessionTimeout");
			}

			// sessionapi adapter擾
			SCORMAPIAdapter apiAdapter =
				(SCORMAPIAdapter) session.getAttribute("SCORM.API_ADAPTER");

			// session擾łȂꍇ  Session Timeout 
			if (apiAdapter == null) {
				// knfo
				DebugLog.write(getClass(),
						"[request]SessionTimeout(apiAdapter is null)",
						DebugLog.HIGHT);
				throw new XmsWarningException("SessionTimeout");
			}

			// GWapplication擾
			String engineKeyName = "SCORM." + executeParameters.getUserID()
								 + "."  + executeParameters.getLOID() + ".ENGINE";

			Engine engine = (Engine) application.getAttribute(engineKeyName);

			// application擾łȂꍇ  ɋނIĂꍇ  Session TimeoutɌ
			if (engine == null) {
				// knfo
				DebugLog.write(getClass(),
						"[request]SessionTimeout(Engine is null)", DebugLog.HIGHT);
				throw new XmsWarningException("SessionTimeout");
			}

			// NGXgirQ[VR}h擾
			String command = pCommand;

			if (apiAdapter.getCommunicationModule() != null) {
				// "cmi.exit"̒l擾
				String exitStatus =
					apiAdapter.getCommunicationModule().getValue("cmi.exit");

				if (exitStatus != null) {
					// "cmi.exit"̒l"time-out"̏ꍇ́AExitAlls
					if (exitStatus.equals("time-out")) {
						command = "ExitAll";
					}
					// "cmi.exit"̒l"logout"̏ꍇ́ASuspendAlls
					else if (exitStatus.equals("logout")) {
						command = "SuspendAll";
					}
				}
			}

			boolean result;
			StringBuffer SCOURL = null;

			try {
				// ANeBreBID擾
				if (activityID == null) {
					activityID = "";
				}
				// GWɃirQ[Vvs
				result = engine.navigate(command, activityID);

				// Iꍇ́AV[PVOONA
				engine.setLastSequencingException(null);

				// uwKp\vȏꍇ
				if (result) {
					// JgANeBreB݂邩ǂ`FbN
					if (engine.getCurrentActivity() != null) {
						int attemptCount = 0;

						if (engine.getCurrentActivity().getActivityProgressStatus()) {
							attemptCount =
								engine.getCurrentActivity().getActivityAttemptCount();
						}

						// AICCO̊i[tH_쐬
						StringBuffer learningLogFolder = new StringBuffer();

						learningLogFolder.append(userIDPath(SG.get("LearningLogBaseURL"), executeParameters.getUserID()));
						learningLogFolder.append(File.separator);
						learningLogFolder.append(executeParameters.getLOID());
						learningLogFolder.append(File.separator);
						learningLogFolder.append(executeParameters.getStudySessionCount());
						learningLogFolder.append(File.separator);
						learningLogFolder.append(executeParameters.getLaunchCount());
						learningLogFolder.append(File.separator);
						learningLogFolder.append(engine.getCurrentActivity().getIdentifier());
						learningLogFolder.append(File.separator);
						learningLogFolder.append(new DecimalFormat("0000000000").format(attemptCount));
						learningLogFolder.append(File.separator);
						learningLogFolder.append(
								new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date()));
						learningLogFolder.append(File.separator);

						// ()SCOւURL擾
						String baseSCOURL = engine.getURL(learningLogFolder.toString());
						// ()SCOURL擾łꍇ
						if (baseSCOURL != null) {
							scoUrl = getNextSco(baseSCOURL);
							aiccSid = getAiccSid(baseSCOURL);
						}

						// api adapterJgANeBreBapi adapterɕύX
						apiAdapter.setCommunicationModule(engine.getCommunicationModule());

					} else {
						// irQ[VvG[
						// knfo
						DebugLog.write(getClass(),
										"[request]Navigation reqest error command = "
										+ pCommand	+ " ActivityID = "
										+ request.getParameter("ActivityID"),
										DebugLog.HIGHT);
					}
				}
			} catch (SequencingException e) {
				Debug.write(e);

				// V[PVOOꍇ
				result = true;
				engine.setLastSequencingException(e);
				throw new XmsSystemException(e);
			}

			Document traceLog = engine.getTraceLog();

			// g[XO݂ꍇ
			if (traceLog != null) {
				// g[XÕtpX쐬
				StringBuffer navtraceLogFile = new StringBuffer();

				navtraceLogFile.append(userIDPath(SG.get("ResumeDataBaseURL"), executeParameters.getUserID()));
				navtraceLogFile.append(File.separator);
				navtraceLogFile.append(executeParameters.getLOID());
				navtraceLogFile.append(File.separator);
				navtraceLogFile
						.append(executeParameters.getStudySessionCount());
				navtraceLogFile.append(File.separator);
				navtraceLogFile.append(executeParameters.getLaunchCount());
				navtraceLogFile.append(File.separator);
				navtraceLogFile.append("navtrace.xml");

				// g[XOuǉ[hvŃI[v
				BufferedOutputStream bos = new BufferedOutputStream(
						new FileOutputStream(navtraceLogFile.toString(), true));

				try {
					// navtrace.xmlɃg[XOǉ
					XMLUtil.output(traceLog.getDocumentElement(), true, SG
							.get("XMLEncoding"), new StreamResult(bos));
				} finally {
					bos.close();
				}
			}

			// uwKfv́uwKv̏ꍇ
			if (!result) {
				// api adapter𖢐ݒԂɐݒ肷
				apiAdapter.setCommunicationModule(null);

				// root activity擾
				Activity rootActivity = engine.getRootActivity();
				String exitResult;

				// activty is suspended ̏ꍇ͒f("SuspendAll"sꂽ)
				if (rootActivity.isSuspended() && !command.equalsIgnoreCase("ExitAll")) {
					exitResult = "SUSPEND";
				}
				// activty is suspended
				// łȂꍇ͏I(ɋނ̊wKIA"ExitAll"sꂽ)
				else {
					exitResult = "EXIT";
				}

				// fXMSU֑M
				Exception error = null;

				synchronized (engine) {
					try {
						// fsAfXMSU֑M
						engine.discontinue(exitResult, false);
					} catch (Exception ex) {
						Debug.write(ex);
						error = ex;
					}

					// GWapplication폜
					application.removeAttribute(engineKeyName);
				}

				// session폜
				session.removeAttribute("SCORM.TIMEOUT_WATCHER");
				session.removeAttribute("SCORM.EXECUTE_PARAMETERS");
				session.removeAttribute("SCORM.API_ADAPTER");

				// fɗOꍇ
				if (error != null) {
					// knfo
					DebugLog.write(getClass(),
							"[request]Suspend Execute error", DebugLog.HIGHT);
					throw new XmsSystemException("Suspend Execute error");
				}
				// fEI^[
				endLearn = true;
				return;
			}

			// knfo
			DebugLog.write(getClass(), "[request]:Next SCO = " + scoUrl, DebugLog.ROW);

		} catch (Exception e) {
			DebugLog.write(getClass(), "[request]:Exception", DebugLog.HIGHT);
			throw new XmsSystemException(e);
		}

		// knfo
		DebugLog.write(getClass(), "[request]:TAIL", DebugLog.ROW);

	}

	/**
	 * scoUrlscot@CpX𔲂o܂B
	 * 
	 * @param scoUrl
	 * @return scot@C
	 */
	private String getNextSco(String scoUrl) {

		int endIndex;
		String nextSco = "";

		endIndex = scoUrl.indexOf("?&");

		if (endIndex > 0) {
			try {
				nextSco = scoUrl.substring(0, endIndex);
				nextSco = URLDecoder.decode(nextSco, "UTF-8");
			} catch (UnsupportedEncodingException e) {
			}
		}

		return nextSco;
	}

	/**
	 * SCOURLaicc_sid̒l𔲂o܂B
	 * 
	 * @param SCOURL
	 * @return aicc_sid
	 */
	private String getAiccSid(String SCOURL) {

		int beginIndex;
		int endIndex;
		String aicc_sid = "";

		beginIndex = SCOURL.indexOf("AICC_SID=");

		if (beginIndex > "AICC_SID=".length()) {
			endIndex = SCOURL.indexOf("&", beginIndex);

			if (endIndex > 0) {
				try {
					aicc_sid = SCOURL.substring(beginIndex
						+ "AICC_SID=".length(), endIndex);
					aicc_sid = URLDecoder.decode(aicc_sid, "UTF-8");
				} catch (UnsupportedEncodingException e) {
				}
			}
		}

		return aicc_sid;
	}

	/**
	 * rbntqk߂܂B
	 * 
	 * @return SCOURL
	 */
	public String getScoUrl() {
		return scoUrl;
	}

	/**
	 * aiccsid߂܂B
	 * 
	 * @return aiccSid HACPpaiccsid
	 */
	public String getAiccSid() {
		return aiccSid;
	}

	/**
	 * wKIԂ߂܂B
	 * 
	 * @return true:wKI false:wK
	 */
	public boolean isEndLean() {
		return endLearn;
	}

	/**
	 * irQ[V̗LE߂܂B
	 * 
	 * @param request HttpNGXg
	 * @param command irQ[VR}h
	 * @param url identifier
	 * @return L̏ꍇtrue ̏ꍇfalse ANeBreBids̏ꍇnull
	 */
	public String getRequestValid(HttpServletRequest request, String command, String url) {

		HttpSession session = request.getSession();
		ServletContext application = session.getServletContext();

		// Np[^session擾
		ExecuteParameters executeParameters =
			(ExecuteParameters)session.getAttribute("SCORM.EXECUTE_PARAMETERS");
		if (executeParameters == null) {
			// SessionTimeOut
			DebugLog.write(getClass(),
					"[getRequestValid]Session TimeOut ExecuteParameters is null",
					DebugLog.HIGHT);
			return null;
		}

		String engineKeyName =
			"SCORM." + executeParameters.getUserID() + "." + executeParameters.getLOID() + ".ENGINE";

		Engine engine = (Engine)application.getAttribute(engineKeyName);

		if (engine == null) {
			// SessiontimeOut
			DebugLog.write(getClass(),
					"[getRequestValid]Session TimeOut Engine is null",
					DebugLog.HIGHT);
			return null;
		}

		String result = null;
		try {
			if (command.equals("continue")) {
				result = Boolean.toString(engine.canContinue());
			} else if (command.equals("previous")) {
				result = Boolean.toString(engine.canPrevious());
			} else if (command.equals("choice")) {
				Boolean canChoiceResult =
					engine.canChoice((Activity) null, url);
				// w肳ꂽactivity idsȏꍇ
				if (canChoiceResult != null) {
					result = canChoiceResult.toString();
				}
			}
		} catch (SystemException e) {
			DebugLog.write(getClass(), "[getRequestValid] engine execute Error", DebugLog.HIGHT);
		}
		return result;
	}

	private static String userIDPath(String strDirPath, String strUserID)
	{
		return UserIDFolder.getPath(strDirPath, strUserID);
	}
}
