/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

package jp.co.ntt.lms.installer.core.util;

import java.io.File;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;

import jp.co.ntt.lms.installer.core.InstallerException;
import jp.co.ntt.lms.installer.core.InstallerOverwriteXmlValue;
import jp.co.ntt.lms.installer.core.InstallerValues;
import jp.co.ntt.lms.installer.util.LoggerUtil;
import jp.co.ntt.lms.installer.util.StringUtil;
import jp.co.ntt.lms.installer.util.XmlUtil;

import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/**
 * wlk[eBeBENXB
 * @author T.Nishiki
 */
public class InstallerXmlUtil {
	/**
	 * Oo̓IuWFNgB
	 */
	private static Logger _logger;

	/**
	 * X^eBbNECjVCUB<br>
	 * Oo̓IuWFNg擾܂B
	 */
	static {
		_logger = LoggerUtil.getLogger(InstallerXmlUtil.class);
	}

	/**
	 * w肳ꂽ\[XDOM DocumentƂă[h܂B<br>
	 * @param values CXg[ʃf[^IuWFNgB
	 * @param resourceKey 擾郊\[Ẍʒu擾邽߂̃L[B
	 * @return resourceKeywpX̃\[X
	 *          ꂽDOM Document߂܂B
	 * @throws InstallerException \[X擾ɎsꍇB
	 */
	public static Document load(InstallerValues values, String resourceKey)
			throws InstallerException {
		// \bhJn^O
		LoggerUtil.methodHead(_logger, "load(" + resourceKey + ")");
		// ̃\bh̖߂l
		Document document = null;
		// \[X̓̓Xg[
		InputStream stream = null;
		// tOiꍇtrueɕύXj
		boolean successFlag = false;
		try {
			stream = values.getResourceKeyStream(resourceKey);
			document = XmlUtil.convertXmlStreamToDocument(stream);
			successFlag = true;
		}
		catch (InstallerException e) {
			throw e;
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}
		finally {
			InstallerFileUtil.close(stream, successFlag);
		}
		// \bhI^O
		LoggerUtil.methodTail(_logger, "load(" + resourceKey + ")");
		return document;
	}

	/**
	 * w肳ꂽP[VpXɑΉm[h̏l擾܂B<br>
	 * _ƂȂhLgƁAQƂhLgƂׂāA
	 * ҂̎w̃m[hɍقꍇ́AQƂhLg̃m[hl܂B
	 * قȂꍇ́Anull߂܂B
	 *
	 * @param targetDoc ق擾̂߂ɎQƂDOM DocumentB
	 * @param originDoc ق̊_ƂȂDOM DocumentB
	 * @param xpath قmFXPathP[VpXB
	 * @return w肳ꂽpX̃m[hɍق΁A
	 *          targetDoc̃m[h̒l߂B
	 *          قȂnull߂B
	 * @throws InstallerException m[h̎擾ɎsꍇB
	 */
	public static String determineInitialNodeValue(
			Document targetDoc,	Document originDoc, String xpath)
			throws InstallerException {
		// \bhJn^O
		LoggerUtil.methodHead(_logger,
			"determineInitialNodeValue("
				+ targetDoc + "," + originDoc + "," + xpath + ")");

		String initialValue = null;
		try {
			// ̃m[hl擾
			if (targetDoc != null) {
				String targetValue = XmlUtil.getNodeValue(targetDoc, xpath);
				String originValue = XmlUtil.getNodeValue(originDoc, xpath);
				if (StringUtil.isEmpty(targetValue)) {
					initialValue = null;
				}
				else if (StringUtil.isEmpty(originValue)) {
					initialValue = targetValue;
				}
				else if (targetValue.equals(originValue)) {
					initialValue = null;
				}
				else {
					initialValue = targetValue;
				}
			}
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}
		// \bhI^O
		LoggerUtil.methodTail(_logger,
			"determineInitialNodeValue("
				+ targetDoc + "," + originDoc + "," + xpath + ")",
			initialValue);

		return initialValue;
	}

	/**
	 * wlkt@C㏑܂B<br>
	 * @param values CXg[ʃf[^IuWFNgB
	 * @param xmlValue ㏑鍀ڂɂĎ擾łf[^B
	 * @throws InstallerException vpeBt@C̎擾EɎsꍇB
	 */
	public static void overwriteXml(
			InstallerValues values,
			InstallerOverwriteXmlValue xmlValue)
			throws InstallerException {
		// \bhJn^O
		LoggerUtil.methodHead(_logger,
			"overwriteXml(InstallerValues," + xmlValue + ")");

		try {
			// =================================================================
			// {ƂȂwlk̎擾
			Document doc
				= InstallerXmlUtil.load(values, xmlValue.getTargetFileKey());
			// =================================================================
			// ㏑ΏۂƂȂm[h̒l
			Properties nodeValues
				= xmlValue.getOverwrittenNodeValues(values);
			// m[h̒l̏㏑
			if (nodeValues != null) {
				Set keySet = nodeValues.keySet();
				for (Iterator it = keySet.iterator(); it.hasNext();) {
					String nodeXPath = (String)it.next();
					_logger.info("Node XPath:[" + nodeXPath + "]");
					String nodeValue = nodeValues.getProperty(nodeXPath);
					_logger.info("Node Value:[" + nodeValue + "]");
					Node node = XPathAPI.selectSingleNode(doc, nodeXPath);
					if (node == null) {
						_logger.info(
							"selectSingleNode[" + nodeXPath + "] is Null");
						continue;
					}
					node.setNodeValue(nodeValue);
				}
			}
			// =================================================================
			// ݑΏۂ̃t@C
			File targetFile = values.getFileOnSystem(
				xmlValue.getTargetFileKey());
			_logger.info("XML Output target[" + targetFile + "]");
			// XMLϊvpeB𐶐
			String xmlEncode = values.getProperty(
					xmlValue.getXmlFileEncodeKey());
			Properties outputProperties = new Properties();
			if (xmlEncode != null) {
				outputProperties.setProperty("encoding", xmlEncode);
			}
			// t@Cɏo
			XmlUtil.convertDocumentToFile(doc, targetFile, outputProperties);
		}
		catch (InstallerException e) {
			throw e;
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}
		// \bhI^O
		LoggerUtil.methodTail(_logger,
			"overwriteXml(InstallerValues," + xmlValue + ")");
	}
}
