//
// CopyRight (C) 2002, IPA, eLC, NTT Resonant Inc. All rights reserved.
//
//	Resource
//
//	ύX
//		2002.12.25  VK쐬
//

package jp.co.ntt.lms.lo.scorm.kernel;

import jp.co.ntt.lms.lo.scorm.kernel.exception.IllegalManifestException;
import jp.co.ntt.lms.lo.scorm.kernel.exception.SystemException;
import jp.co.ntt.lms.lo.scorm.util.CachedNode;

/**
 * Resource class<BR>
 * \[X\NX<BR>
 */
public class Resource {

	/** resource node */
	private CachedNode resourceNode;

	/** identifierRef */
	private String identifierRef;

	/**
	 *	RXgN^
	 *
	 * @param	identifierRef 	o\[Xm[hID
	 * @param	resourcesNode	resourcesm[h
	 */
	public Resource(String identifierRef, CachedNode resourcesNode) throws SystemException {

		try {
			if (resourcesNode == null) {
				throw new IllegalManifestException("Manifest is Illegal. [(manifest)/resources=null]");
			}

			this.identifierRef = identifierRef;

			resourceNode = resourcesNode.selectSingleNodeWithNodeTest("resource", "@identifier", identifierRef);
			if (resourceNode == null) {
				throw new IllegalManifestException("Manifest is Illegal. [(resources/)resource[@identifier='"+identifierRef+"']=null]");
			}
		}
		catch (Exception e) {
			throw new SystemException("Resource failed.", e);
		}
	}

	/**
	 *	Href ̎擾
	 *
	 *	@return	\[Xhrefl
	 */
	public String getHref() throws SystemException {

		if (resourceNode == null) {
			throw new IllegalManifestException("Manifest is Illegal. [(resources/)resource[@identifier='"+identifierRef+"']=null]");
		}
		try {
			//@20040603 ADD NTTR
			StringBuffer retUrl = new StringBuffer("");
			CachedNode bNode = resourceNode.selectSingleChildNode("@xml:base");
			if(bNode != null){
				retUrl.append(bNode.getNodeValue());
			}
			
			//m[hhreflo
			CachedNode n = resourceNode.selectSingleChildNode("@href");
			if (n == null) {
				return null;
			}
			retUrl.append(n.getNodeValue());
			return retUrl.toString();
		}
		catch (Exception e) {
			throw new SystemException("getHref failed.", e);
		}
	}

	/**
	 *	Href ̎擾
     *
	 *	@return	\[Xhrefl
	 */
	public String getBaseURL() throws SystemException {
		if (resourceNode == null) {
			throw new IllegalManifestException("Manifest is Illegal. [(resources/)resource[@identifier='"+identifierRef+"']=null]");
		}
		try {
			//@20040603 ADD NTTR
			StringBuffer retUrl = new StringBuffer("");
			CachedNode bNode = resourceNode.selectSingleChildNode("@base");
			if(bNode != null){
				retUrl.append(bNode.getNodeValue());
			}
			return retUrl.toString();
		}
		catch (Exception e) {
			throw new SystemException("getBaseUrl failed.", e);
		}
			
	}
	
	/**
	 *	ScormType ̎擾
	 *
	 *	@return	\[Xscormtypel
	 */
	public String getScormType() throws SystemException {

		if (resourceNode == null) {
			throw new IllegalManifestException("Manifest is Illegal. [(resources/)resource[@identifier='"+identifierRef+"']=null]");
		}
		try {
			// m[hscormtypelo
			CachedNode scormType = resourceNode.selectSingleChildNode("@scormType");
			if (scormType != null) {
				return scormType.getNodeValue();
			}else{
				scormType = resourceNode.selectSingleChildNode("@scormtype");
				if (scormType != null) {
					return scormType.getNodeValue();
				}
			}
			return null;
		}
		catch (Exception e) {
			throw new SystemException("getScormType failed.", e);
		}
	}

	/**
	 * I
	 */
	public void terminate() {
		resourceNode = null;
	}
}
