//
// CopyRight (C) 2002, IPA, eLC, NTT Resonant Inc. All rights reserved.
//
//	ActivityPath
//
//	ύX
//		2002.12.25  VK쐬
//

package jp.co.ntt.lms.lo.scorm.kernel;

import jp.co.ntt.lms.lo.scorm.kernel.exception.SystemException;

/**
 * ActivityPathNX<BR>
 * Activity֘A𐶐擾NX<BR>
 */
public class ActivityPath {

	/**
	 * activity path Ί֌W ꂩ̃ANeBreBNULL̏ꍇ
	 */
	public static final int NULL_ACTIVITY = 0;

	/**
	 * activity path Ί֌W ANeBreB̏ꍇ<BR>
	 */
	public static final int SAME_ACTIVITY = 1;

	/**
	 * activity path Ί֌W ZANeBreB̏ꍇ<BR>
	 */
	public static final int SIBLING = 2;

	/**
	 * activity path Ί֌W JgANeBreBʂ̐ȅꍇ<BR>
	 */
	public static final int ACT1_ACTIVITY_IS_COMMON_ANCESTOR = 3;

	/**
	 * activity path Ί֌W ^[QbgANeBreBʂ̐ȅꍇ<BR>
	 */
	public static final int ACT2_ACTIVITY_IS_COMMON_ANCESTOR = 4;

	/**
	 * activity path Ί֌W ̑<BR>
	 */
	public static final int ETC = 5;

	/** activities in the activity path */
	private Activity[] activitySet;

	/** position */
	private int pos;

	/**
	 *	RXgN^<BR>
	 *
	 * @param	startActivity	ANeBreBpX̎n_ANeBreB<BR>
	 * @param   endActivity 	ANeBreBpX̏I_ANeBreB<BR>
	 */
	public ActivityPath(Activity startActivity, Activity endActivity) throws SystemException {

		try {
			pos = 0; // pos ̏
			if (startActivity == null || endActivity == null) {
				activitySet = null;
				return;
			}

			//startActivityendActivityȂÃANeBreB
			if (startActivity.getIdentifier().equals(endActivity.getIdentifier())) {
				activitySet = new Activity[1];
				activitySet[0] = startActivity;
			}
			else
				if ((!startActivity.isRoot()) && (!endActivity.isRoot())) {
					//Z̃`FbN(eȂZ)
					if (startActivity.getParent() == endActivity.getParent()) { //ZȂ̂ŉpath
						Activity[] actSet = startActivity.getParent().getAvailableChildren(); // p\ȌZActivity擾
						int startOrder = 0;
						int endOrder = 0;
						int path_len = 0;
						boolean reverse_flg = false;

						if (startActivity.getAvailableOrder() - endActivity.getAvailableOrder() < 0) {
							startOrder = startActivity.getAvailableOrder();
							endOrder = endActivity.getAvailableOrder();
						}
						else {
							startOrder = endActivity.getAvailableOrder();
							endOrder = startActivity.getAvailableOrder();
							reverse_flg = true;
						}

						// pX̒𒲂ׂ
						for (int i = 0; i < actSet.length; i++) {
							if (startOrder <= actSet[i].getAvailableOrder()
								&& endOrder >= actSet[i].getAvailableOrder()) {
								path_len++;
							}
						}

						// pX̏
						activitySet = new Activity[path_len];

						// pX쐬
						int j = 0;
						for (int i = 0; i < path_len; i++) {
							for (; j < actSet.length;) {
								if (startOrder <= actSet[j].getAvailableOrder()
									&& endOrder >= actSet[j].getAvailableOrder()) {
									activitySet[i] = actSet[j];
									j++;
									break;
								}
								j++;
							}
						}

						if (reverse_flg) {
							this.reverseList();
						}
					}

					else { // Zł͂ȂActivity
						int st_path_count = 0;
						int ed_path_count = 0;

						// startActivity烋[gActivity܂łActivityPath擾
						ActivityPath st_path = new ActivityPath(startActivity, startActivity.getRoot());
						// [gActivityendActivity܂łActivityPath擾
						ActivityPath ed_path = new ActivityPath(endActivity.getRoot(), endActivity);

						// startActivityendActivity̋ʐeActivity擾
						Activity p_act = ActivityPath.getCommonParent(startActivity, endActivity);

						// startActivity狤ʐe܂łActivity𐔂
						for (int i = 0; i < st_path.activitySet.length; i++) {
							if (st_path.activitySet[i] == p_act) {
								st_path_count = i + 1;
								break;
							}
						}
						// ʐeendActivity܂łActivity𐔂
						for (int i = 0; i < ed_path.activitySet.length; i++) {
							if (ed_path.activitySet[i] == p_act) {
								ed_path_count = ed_path.activitySet.length - i;
								break;
							}
						}

						// ActivityPath쐬
						// startActivity狤ʐe܂ł̃pX쐬
						this.activitySet = new Activity[st_path_count + ed_path_count - 1];
						for (int i = 0; i < st_path_count; i++) {
							this.activitySet[i] = st_path.activitySet[i];
						}
						// ʐeendActivity܂ł̃pX쐬
						int j = ed_path.activitySet.length - ed_path_count + 1;
						for (int i = 0; i < ed_path_count - 1; i++) {
							this.activitySet[st_path_count + i] = ed_path.activitySet[j++];
						}
					}
				}
				else { // ꂩActivityroot
					Activity act;
					boolean reverse_flg = false;
					if (startActivity.isRoot() == true) {
						act = endActivity;
						reverse_flg = true;
					}
					else {
						act = startActivity;
					}

					// [gActivity܂łActivity𐔂
					Activity p_act = act.getParent();
					int count;
					for (count = 1; p_act.isRoot() != true; count++) {
						p_act = p_act.getParent();
					}

					// [g܂łActivitypX쐬
					activitySet = new Activity[count + 1];
					activitySet[0] = act;
					for (int i = 1; i <= count; i++) {
						activitySet[i] = activitySet[i - 1].getParent();
					}

					if (reverse_flg) {
						this.reverseList();
					}
				}

			// 쐬ActivitypXAvailablełȂActivity鎞̓G[
			for (int i = 0; i < activitySet.length; i++) {
				if (!activitySet[i].isAvailable()) {
					throw new SystemException("ActivityPath[ActivityPath()]:pX܂BAvailablełȂActivityɃpX낤ƂĂ܂B");
				}
			}

		}
		catch (Exception e) {
			throw new SystemException("ActivityPath[ActivityPath()]: pX܂B", e);
		}

	}

	/**
	 *	Activitymł̋ʐeActivity擾
	 *	@param	act1
	 *			act2
	 *	@return ʐeActivity
	 */
	public static Activity getCommonParent(Activity act1, Activity act2) throws SystemException {

		Activity com_p_act = null;
		boolean break_flg = false;

		// ꂩActivitynull̎
		if (act1 == null || act2 == null) {
			return null;
		}

		// Activitym̎
		if (act1 == act2) {
			if (act1.isRoot()) {
				return null; // act1act2[gActivity̎͋ʐeƂnullԂ
			}
			return (act1.getParent());
		}

		// [gActivity܂łActivityPath擾
		ActivityPath act1_path = new ActivityPath(act1, act1.getRoot());
		ActivityPath act2_path = new ActivityPath(act2, act2.getRoot());

		// 擾ActivityPathm̒狤ActivityT
		for (int i = 0; i < act1_path.activitySet.length; i++) {
			for (int j = 0; j < act2_path.activitySet.length; j++) {
				if (act1_path.activitySet[i] == act2_path.activitySet[j]) {
					com_p_act = act1_path.activitySet[i];
					break_flg = true;
					break;
				}
			}
			if (break_flg) {
				break;
			}
		}

		return com_p_act;
	}

	/**
	 *	ActivityPath̏Ԃtɂ
	 */
	public void reverseList() {

		if (activitySet == null) {
			return;
		}

		Activity tmp;
		int len = activitySet.length;
		int i, j;

		for (i = 0; i < len; i++) {
			tmp = activitySet[0];
			for (j = 0; j < len - (i + 1); j++) {
				activitySet[j] = activitySet[j + 1];
			}
			activitySet[j] = tmp;
		}
	}

	/**
	 *	ActivityPath̍ŏActivity폜
	 */
	public void removeFirst() {

		if (activitySet == null) {
			return;
		}

		int len = activitySet.length;

		if (len > 1) {
			Activity[] tmp = new Activity[len - 1];
			for (int i = 1; i < len; i++) {
				tmp[i - 1] = activitySet[i];
			}
			activitySet = new Activity[len - 1];
			activitySet = tmp;
		}
		else
			if (len == 1) {
				activitySet = null;
			}
	}

	/**
	 *	ActivityPath̍ŌActivity폜
	 */
	public void removeLast() {

		if (activitySet == null) {
			return;
		}

		int len = activitySet.length;

		if (len > 1) {
			Activity[] tmp = new Activity[len - 1];
			for (int i = 0; i < len - 1; i++) {
				tmp[i] = activitySet[i];
			}
			activitySet = new Activity[len - 1];
			activitySet = tmp;
		}
		else
			if (len == 1) {
				activitySet = null;
			}
	}

	/**
	 *	ActivityPath邩Ȃ
	 *
	 * 	@return	true	ANeBreBpXȂ<BR>
	 *         	false	ANeBreBpX<BR>
	 *
	 */
	public boolean isEmpty() {

		if (activitySet == null || activitySet.length == 0) {
			return true;
		}

		return false;
	}

	/**
	 *	ActivityPath̎ActivityԂ
	 *	@return ActivityPath̎Activity
	 */
	public Activity getNext() {

		if (activitySet == null) {
			return null;
		}

		if ((pos >= activitySet.length)) {
			return null;
		}

		pos++;

		return (activitySet[pos - 1]);
	}

	/**
	 *	Activitym̑O֌W
	 *
	 *  @param	act1
	 *		    act2
	 *	@return act1act2OA͓Ȃ^
	 *			 act1act2ȂU
	 */
	public static boolean isForward(Activity act1, Activity act2) throws SystemException {

		try {
			// ꂩActivitynull̎
			if (act1 == null || act2 == null) {
				throw new SystemException("ActivityPath[isForward()]:null  Activity w肳܂B");
			}

			// ZActivity̎
			if (act1.getParent() == act2.getParent()) {
				if (!act1.isRoot()) {
					if (act1.getAvailableOrder() >= act2.getAvailableOrder()) {
						return true;
					}
					return false;
				}
				return true;
			}

			// ZActivityȊO̎
			// ʂ̐eActivity߂
			Activity p_act = ActivityPath.getCommonParent(act1, act2);
			if (p_act != null) {
				// ʐeActivity܂łActivityPath쐬
				ActivityPath act1_path = new ActivityPath(act1, p_act);
				ActivityPath act2_path = new ActivityPath(act2, p_act);

				// act1  act2 ̒nq̎
				if (act1_path.activitySet[act1_path.activitySet.length - 1] == act2) {
					return true;
				}
				// act2  act1 ̒nq̎
				if (act2_path.activitySet[act2_path.activitySet.length - 1] == act1) {
					return false;
				}

				// ʐe̒Activitym(=ZActivity)̃I[_[߂
				int act1_order = act1_path.activitySet[act1_path.activitySet.length - 2].getAvailableOrder();
				int act2_order = act2_path.activitySet[act2_path.activitySet.length - 2].getAvailableOrder();

				if (act1_order >= act2_order) {
					return true;
				}
				return false;
			}
			return true;
		}
		catch (Exception e) {
			throw new SystemException("ActivityPath[isForward()]: Activitym̑O֌W𔻒ł܂B", e);
		}
	}

	/**
	 * ANeBreB̈ʒu֌WԂ<BR>
	 *
	 *
	 * @param act1 ̃ANeBreB<BR>
	 * @param act2 ^[QbgANeBreB<BR>
	 *
	 * @return ȉ̊֌WԂ
	 *      (1)SAME_ACTIVITY
	 *				act1  act2 ANeBreBł<BR>
	 *      (2)SIBLING
	 *				act1  act2 ZANeBreBł<BR>
	 *      (3)ACT1_ACTIVITY_IS_COMMON_ANCESTOR
	 *				act1ʂ̐eł<BR>
	 *      (4)ACT2_ACTIVITY_IS_COMMON_ANCESTOR
	 *				act2ʂ̐eł<BR>
	 *		(5)ETC
	 *				̑<BR>
	 *
	 */
	public static int checkTarget(Activity act1, Activity act2) throws SystemException {

		try {
			if (act1 == null || act2 == null) {
				// ꂩActivitynull̎
				return (NULL_ACTIVITY);
			}

			if (act1 == act2) {
				// act1  act2 ANeBreB̎
				return (SAME_ACTIVITY);
			}
			else
				if (act1.getParent() == act2.getParent()) {
					// act1  act2 ZANeBreB̎
					return (SIBLING);
				}
				else {
					if (act1.isRoot()) {
						//act1ʂ̐eł
						return (ACT1_ACTIVITY_IS_COMMON_ANCESTOR);
					}
					else
						if (act2.isRoot()) {
							//act2ʂ̐eł
							return (ACT2_ACTIVITY_IS_COMMON_ANCESTOR);
						}
						else {
							// ʂ̐eActivity߂
							Activity p_act = ActivityPath.getCommonParent(act1, act2);

							// ʐeActivity܂łActivityPath쐬
							ActivityPath act1_path = new ActivityPath(act1, p_act);
							ActivityPath act2_path = new ActivityPath(act2, p_act);

							if (act2_path.activitySet[act2_path.activitySet.length - 1] == act1) {
								// act2  act1 ̒nq̎  act1ʂ̐eł
								return (ACT1_ACTIVITY_IS_COMMON_ANCESTOR);
							}
							else
								if (act1_path.activitySet[act1_path.activitySet.length - 1] == act2) {
									// act1  act2 ̒nq̎  act2ʂ̐eł
									return (ACT2_ACTIVITY_IS_COMMON_ANCESTOR);
								}else{
									// ̑
									return (ETC);
								}
						}
				}
		}
		catch (Exception e) {
			throw new SystemException("ActivityPath[checkTarget()]: Activitÿʒu֌W𔻒ł܂B");
		}
	}

	/**
	 * ActivityPath̃Jg|WVŌォۂ<BR>
	 * @return true Ō̃ANeBreB<BR>
	 *         false ŌłȂ<BR>
	 */

	public boolean isLast() {
		if (pos >= activitySet.length) {
			return true;
		}
		return false;
	}

	/**
	 * ActivityPath̃Jg|WVŏ̈ʒuɃZbgȂ<BR>
	 */
	public void setPos() {
		pos = 0;
	}
}
