/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/
package jp.co.ntt.lms.installer.lms;

import java.io.File;
import java.util.Properties;
import java.util.logging.Logger;

import jp.co.ntt.lms.installer.core.InstallerAction;
import jp.co.ntt.lms.installer.core.InstallerActionValue;
import jp.co.ntt.lms.installer.core.InstallerException;
import jp.co.ntt.lms.installer.core.InstallerValues;
import jp.co.ntt.lms.installer.core.util.InstallerCheckUtil;
import jp.co.ntt.lms.installer.core.util.InstallerPropertiesUtil;
import jp.co.ntt.lms.installer.core.util.InstallerUiUtil;
import jp.co.ntt.lms.installer.util.FileUtil;
import jp.co.ntt.lms.installer.util.LoggerUtil;

/**
 * }l[Wݒt@C̏ڂɂē͂߂ANVNXB
 * @author T.Nishiki
 */
public class ManagerInputAction implements InstallerAction {
	/**
	 * Oo̓IuWFNgB
	 */
	private static Logger _logger;

	/**
	 * X^eBbNECjVCUB
	 */
	static {
		_logger = LoggerUtil.getLogger(ManagerInputAction.class);
	}

	/**
	 * ANVXLbv邩肵܂B<br>
	 * XLbvȂ̂false߂܂B<br>
	 *
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @return false߂܂B
	 */
	public boolean isSkipped(InstallerValues values) {
		return false;
	}

	/**
	 * }l[Wݒt@C̏ڂɂḗEmF߂܂B<br>
	 *
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @return ManagerInputValue߂܂B
	 * @throws InstallerException sɗOꍇB
	 * @see ManagerInputValue
	 */
	public InstallerActionValue action(InstallerValues values)
		throws InstallerException {
		////////////////////////////////////////////////////////////////////////
		// \bhJnO
		LoggerUtil.methodHead(_logger, "action(InstallerValues)");
		// ̓f[^
		ManagerInputValue inputValue = null;
		try {
			// ̓f[^iftHgf[^ƂĎgpj
			ManagerInputValue defaultValue = getDefaultValue(values);
			// ^Cg̕\
			InstallerUiUtil.outputMessageAsTitle(
				values, "ManagerInputAction.welcome");

			while (true) {
				// ͎s
				inputValue = readInputValue(values, defaultValue);
				// ͊mF
				if (confirmInputValue(values, inputValue) == true) {
					// ͊mFς񂾂A
					// f[^x[X֘Ȁʃf[^Ƃēo^
					values.setDbCategory(inputValue.getDbCategory());
					break;
				}
			}
		}
		catch (InstallerException e) {
			throw e;
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}
		////////////////////////////////////////////////////////////////////////
		// \bhIO
		LoggerUtil.methodTail(_logger, "action(InstallerValues)", inputValue);
		return inputValue;
	}

	/**
	 * }l[Wݒt@C̏ڂɂē͂߂܂B<br>
	 *
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @param defaultValue ftHglB
	 * @return ͂ꂽeManagerInputValue߂܂B
	 * @throws InstallerException sɗOꍇB
	 */
	private ManagerInputValue readInputValue(
			InstallerValues values, ManagerInputValue defaultValue)
			throws InstallerException {
		LoggerUtil.methodHead(_logger,
			"readInputValue(InstallerValues," + defaultValue + ")");

		ManagerInputValue inputValue = null;
		try {
			inputValue = new ManagerInputValue();
			// =================================================================
			// zXg
			String hostName = null;
			while (true) {
				hostName = InstallerUiUtil.askUserInput(values,
						"ManagerInputAction.prompt.hostName",
						defaultValue.getHostName());
				// 
				if (InstallerCheckUtil.isEmptyViolation(hostName, values,
						"ManagerInputAction.error.hostName.empty")) {
					continue;
				}
				break;
			}
			inputValue.setHostName(hostName);
			// =================================================================
			// knzXg
			String loHostName = null;
			while (true) {
				loHostName = InstallerUiUtil.askUserInput(values,
						"ManagerInputAction.prompt.loHostName",
						defaultValue.getLoHostName());
				// 
				if (InstallerCheckUtil.isEmptyViolation(loHostName, values,
						"ManagerInputAction.error.loHostName.empty")) {
					continue;
				}
				break;
			}
			inputValue.setLoHostName(loHostName);
			// =================================================================
			// qcalr̎ޑI
			String dbCategory = null;
			while (true) {
				dbCategory = InstallerUiUtil.askUserInput(values,
					"ManagerInputAction.prompt.dbCategory",
					defaultValue.getDbCategory());
				// ΏۊO̓
				boolean violate = InstallerCheckUtil.isPatternViolation(
					dbCategory, "[0-2]", values,
					"ManagerInputAction.error.dbCategory.format");
				if (violate) {
					continue;
				}
				break;
			}
			inputValue.setDbCategory(dbCategory);
			// =================================================================
			// f[^x[X̃zXg
			String dbHost = null;
			while (true) {
				dbHost = InstallerUiUtil.askUserInput(values,
						"ManagerInputAction.prompt.dbHost",
						defaultValue.getDbHost());
				// 
				if (InstallerCheckUtil.isEmptyViolation(dbHost, values,
						"ManagerInputAction.error.dbHost.empty")) {
					continue;
				}
				break;
			}
			inputValue.setDbHost(dbHost);
			// =================================================================
			// f[^x[Xڑ̃[U
			String dbUser = null;
			while (true) {
				dbUser = InstallerUiUtil.askUserInput(values,
						"ManagerInputAction.prompt.dbUser",
						defaultValue.getDbUser());
				// 
				if (InstallerCheckUtil.isEmptyViolation(dbUser, values,
						"ManagerInputAction.error.dbUser.empty")) {
					continue;
				}
				break;
			}
			inputValue.setDbUser(dbUser);
			// =================================================================
			// f[^x[Xڑ̃pX[h
			String dbPassword = null;
			dbPassword = InstallerUiUtil.askUserInput(values,
					"ManagerInputAction.prompt.dbPassword",
					defaultValue.getDbPassword());
			inputValue.setDbPassword(dbPassword);
			// =================================================================
			// f[^x[X̃|[gԍ
			String dbPort = null;
			while (true) {
				dbPort = InstallerUiUtil.askUserInput(values,
						"ManagerInputAction.prompt.dbPort",
						defaultValue.getDbPort());
				// 
				if (InstallerCheckUtil.isEmptyViolation(dbPort, values,
						"ManagerInputAction.error.dbPort.empty")) {
					continue;
				}
				break;
			}
			inputValue.setDbPort(dbPort);
			// =================================================================
			// f[^x[X
			String dbName = null;
			while (true) {
				dbName = InstallerUiUtil.askUserInput(values,
						"ManagerInputAction.prompt.dbName",
						defaultValue.getDbName());
				// 
				if (InstallerCheckUtil.isEmptyViolation(dbName, values,
						"ManagerInputAction.error.dbName.empty")) {
					continue;
				}
				break;
			}
			inputValue.setDbName(dbName);
			// =================================================================
			// f[^x[XEGR[h
			String dbEncode = null;
			while (true) {
				dbEncode = InstallerUiUtil.askUserInput(values,
						"ManagerInputAction.prompt.dbEncode",
						defaultValue.getDbEncode());
				// 
				if (InstallerCheckUtil.isEmptyViolation(dbEncode, values,
						"ManagerInputAction.error.dbEncode.empty")) {
					continue;
				}
				break;
			}
			inputValue.setDbEncode(dbEncode);
		}
		catch (InstallerException e) {
			throw e;
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}

		LoggerUtil.methodTail(_logger,
			"readInputValue(InstallerValues,ManagerInputValue)", inputValue);
		return inputValue;
	}

	/**
	 * ͂e\A[UɊmF߂܂B<br>
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @param inputValue ͂ꂽe
	 * @return ͂ꂽeɃ[UmFƂꂽꍇtrueA
	 *          ƂȂꍇfalse߂܂B
	 * @throws InstallerException ɃG[ꍇB
	 */
	private boolean confirmInputValue(
			InstallerValues values, ManagerInputValue inputValue)
			throws InstallerException {

		LoggerUtil.methodHead(_logger,
			"confirmInputValue(InstallerValues, ManagerInputValue)");
		boolean confirm = false;
		try {
			// =================================================================
			// ^Cg\
			InstallerUiUtil.outputConfirmTitle(values,
				"ManagerInputAction.confirm.title");
			// =================================================================
			// ͓e̕\
			// =================================================================
			// zXg
			InstallerUiUtil.outputConfirm(values,
				"ManagerInputAction.confirm.hostName",
				inputValue.getHostName());
			// knzXg
			InstallerUiUtil.outputConfirm(values,
				"ManagerInputAction.confirm.loHostName",
				inputValue.getLoHostName());
			// f[^x[X
			String dbCategoryName = values.getMessage(
				"ManagerInputAction.confirm.dbCategory."
					+ inputValue.getDbCategory());
			InstallerUiUtil.outputConfirm(values,
				"ManagerInputAction.confirm.dbCategory", dbCategoryName);
			// f[^x[XEzXg
			InstallerUiUtil.outputConfirm(values,
				"ManagerInputAction.confirm.dbHost",
				inputValue.getDbHost());
			// f[^x[XE[U
			InstallerUiUtil.outputConfirm(values,
				"ManagerInputAction.confirm.dbUser",
				inputValue.getDbUser());
			// f[^x[XEpX[h
			InstallerUiUtil.outputConfirm(values,
				"ManagerInputAction.confirm.dbPassword",
				inputValue.getDbPassword());
			// f[^x[XE|[gԍ
			InstallerUiUtil.outputConfirm(values,
				"ManagerInputAction.confirm.dbPort",
				inputValue.getDbPort());
			// f[^x[X
			InstallerUiUtil.outputConfirm(values,
				"ManagerInputAction.confirm.dbName",
				inputValue.getDbName());
			// f[^x[XEGR[h
			InstallerUiUtil.outputConfirm(values,
				"ManagerInputAction.confirm.dbEncode",
				inputValue.getDbEncode());
			// =================================================================
			// [UmF
			confirm = InstallerUiUtil.askUserConfirm(
				values, "ManagerInputAction.confirm" );
		}
		catch (InstallerException e) {
			throw e;
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}

		LoggerUtil.methodTail(_logger,
			"confirmInputValue(InstallerValues, ManagerInputValue)", confirm);
		return confirm;
	}

	/**
	 * ̃f[^A͍ڂ̃ftHgl擾܂B<br>
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @return ftHglManagerInputValuě`Ŗ߂܂B
	 * @throws InstallerException sɗOꍇB
	 */
	private ManagerInputValue getDefaultValue(InstallerValues values)
			throws InstallerException {
		// \bhJnO
		LoggerUtil.methodHead(_logger,
			"getDefaultValue(InstallerValues)");

		ManagerInputValue defaultValue = null;
		try {
			defaultValue = new ManagerInputValue();
			////////////////////////////////////////////////////////////////////
			// vpeB̎擾
			// =================================================================
			// ̓e
			File existFile = values.getFileOnSystem(
					defaultValue.getTargetFileKey());
			Properties existProperties
				= FileUtil.loadAsProperties(existFile);
			// =================================================================
			// \[Xi{j̓e
			Properties resourceProperties
				= InstallerPropertiesUtil.load(
					values, defaultValue.getTargetFileKey());
			// =================================================================
			// zXg
			String hostName = InstallerPropertiesUtil.determineInitialValue(
								existProperties, resourceProperties,
								ManagerInputValue.KEY_HOST_NAME);
			defaultValue.setHostName(hostName);
			// =================================================================
			// LOzXg
			String loHostName = InstallerPropertiesUtil.determineInitialValue(
								existProperties, resourceProperties,
								ManagerInputValue.KEY_LO_HOST_NAME);
			defaultValue.setLoHostName(loHostName);
			// =================================================================
			// f[^x[XE
			String dbCategory = InstallerPropertiesUtil.determineInitialValue(
								existProperties, resourceProperties,
								ManagerInputValue.KEY_DB_CATEGORY);
			defaultValue.setDbCategory(dbCategory);
			// =================================================================
			// f[^x[XEzXg
			String dbHost = InstallerPropertiesUtil.determineInitialValue(
								existProperties, resourceProperties,
								ManagerInputValue.KEY_DB_HOST);
			defaultValue.setDbHost(dbHost);
			// =================================================================
			// f[^x[Xڑ̃[U
			String dbUser = InstallerPropertiesUtil.determineInitialValue(
								existProperties, resourceProperties,
								ManagerInputValue.KEY_DB_USER);
			defaultValue.setDbUser(dbUser);
			// =================================================================
			// f[^x[Xڑ̃pX[h
			//String dbPassword = InstallerPropertiesUtil.determineInitialValue(
			//					existProperties, resourceProperties,
			//					ManagerInputValue.KEY_DB_PASS);
			//defaultValue.setDbPassword(dbPassword);
			// =================================================================
			// f[^x[X̃|[gԍ
			String dbPort = InstallerPropertiesUtil.determineInitialValue(
								existProperties, resourceProperties,
								ManagerInputValue.KEY_DB_PORT);
			defaultValue.setDbPort(dbPort);
			// =================================================================
			// f[^x[X
			String dbName = InstallerPropertiesUtil.determineInitialValue(
								existProperties, resourceProperties,
								ManagerInputValue.KEY_DB_NAME);
			defaultValue.setDbName(dbName);
			// =================================================================
			// f[^x[XEGR[h
			String dbEncode = InstallerPropertiesUtil.determineInitialValue(
								existProperties, resourceProperties,
								ManagerInputValue.KEY_DB_ENCODE);
			defaultValue.setDbEncode(dbEncode);
		}
		catch (InstallerException e) {
			throw e;
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}
		// \bhIO
		LoggerUtil.methodTail(_logger,
			"getDefaultValue(InstallerValues)", defaultValue);
		return defaultValue;
	}
}
